/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.base.util.BlockPropertyUtil;
import org.violetmoon.quark.content.building.block.VariantChestBlock;
import org.violetmoon.quark.content.building.block.VariantTrappedChestBlock;
import org.violetmoon.quark.content.building.block.be.VariantChestBlockEntity;
import org.violetmoon.quark.content.building.block.be.VariantTrappedChestBlockEntity;
import org.violetmoon.quark.content.building.client.render.be.VariantChestRenderer;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorAbstractChestedHorse;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.ZEntityJoinLevel;
import org.violetmoon.zeta.event.play.entity.living.ZLivingDeath;
import org.violetmoon.zeta.event.play.entity.player.ZPlayerInteract;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.BooleanSuppliers;
import org.violetmoon.zeta.util.VanillaWoods;
import org.violetmoon.zeta.util.handler.StructureBlockReplacementHandler;

@ZetaLoadModule(category="building", antiOverlap={"woodworks"})
public class VariantChestsModule
extends ZetaModule {
    @Config(flag="chest_reversion")
    private static boolean enableRevertingWoodenChests = true;
    public static final List<Block> regularChests = new ArrayList<Block>();
    public static final List<Block> trappedChests = new ArrayList<Block>();
    public static BlockEntityType<VariantChestBlockEntity> chestTEType;
    public static BlockEntityType<VariantTrappedChestBlockEntity> trappedChestTEType;
    @Config
    protected boolean replaceWorldgenChests = true;
    @Config(description="Chests to put in structures. It's preferred to use worldgen tags for this. The format per entry is \"structure=chest\", where \"structure\" is a structure ID, and \"chest\" is a block ID, which must correspond to a standard chest block.")
    public List<String> structureChests = new ArrayList<String>();
    protected final Map<ResourceLocation, Block> manualChestMappings = new HashMap<ResourceLocation, Block>();
    protected final Map<ResourceLocation, Block> manualTrappedChestMappings = new HashMap<ResourceLocation, Block>();
    protected final Map<TagKey<Structure>, Block> chestMappings = new HashMap<TagKey<Structure>, Block>();
    protected final Map<TagKey<Structure>, Block> trappedChestMappings = new HashMap<TagKey<Structure>, Block>();
    private static final String DONK_CHEST = "Quark:DonkChest";
    private static final ThreadLocal<ItemStack> WAIT_TO_REPLACE_CHEST;

    @LoadEvent
    public final void register(ZRegister event) {
        for (VanillaWoods.Wood s : VanillaWoods.ALL) {
            this.makeChestBlocks(s.name(), Blocks.CHEST, s.soundPlanks());
        }
        this.makeChestBlocks("nether_brick", Blocks.NETHER_BRICKS, null);
        this.makeChestBlocks("purpur", Blocks.PURPUR_BLOCK, null);
        this.makeChestBlocks("prismarine", Blocks.PRISMARINE, null);
        CreativeTabManager.daisyChain();
        for (Block regularChest : regularChests) {
            CreativeTabManager.addToCreativeTabNextTo((ResourceKey)CreativeModeTabs.FUNCTIONAL_BLOCKS, (ItemLike)regularChest, (ItemLike)Blocks.CHEST, (boolean)false);
        }
        CreativeTabManager.endDaisyChain();
        CreativeTabManager.daisyChain();
        for (Block trappedChest : trappedChests) {
            CreativeTabManager.addToCreativeTabNextTo((ResourceKey)CreativeModeTabs.REDSTONE_BLOCKS, (ItemLike)trappedChest, (ItemLike)Blocks.TRAPPED_CHEST, (boolean)false);
        }
        CreativeTabManager.endDaisyChain();
        StructureBlockReplacementHandler.addReplacement(this::getGenerationChestBlockState);
    }

    private void makeChestBlocks(String name, Block base, @Nullable SoundType sound) {
        this.makeChestBlocks(this, name, base, sound, BooleanSuppliers.TRUE);
    }

    private void makeChestBlocks(ZetaModule module, String name, Block base, @Nullable SoundType sound, BooleanSupplier condition) {
        BlockBehaviour.Properties props = BlockPropertyUtil.copyPropertySafe(base);
        if (sound != null) {
            props = props.sound(sound);
        }
        VariantChestBlock regularChest = new VariantChestBlock(name, module, () -> chestTEType, props).setCondition(condition);
        regularChests.add((Block)regularChest);
        this.chestMappings.put(Quark.asTagKey(Registries.STRUCTURE, name + "_chest_structures"), (Block)regularChest);
        VariantTrappedChestBlock trappedChest = new VariantTrappedChestBlock(name, module, () -> trappedChestTEType, props).setCondition(condition);
        trappedChests.add((Block)trappedChest);
        this.trappedChestMappings.put(Quark.asTagKey(Registries.STRUCTURE, name + "_chest_structures"), (Block)trappedChest);
        Quark.LOOTR_INTEGRATION.makeChestBlocks(module, name, base, condition, (Block)regularChest, (Block)trappedChest);
    }

    public static void makeChestBlocksExternal(ZetaModule module, String name, Block base, @Nullable SoundType sound, BooleanSupplier condition) {
        VariantChestsModule me = (VariantChestsModule)Quark.ZETA.modules.get(VariantChestsModule.class);
        me.makeChestBlocks(module, name, base, sound, () -> me.isEnabled() && condition.getAsBoolean());
    }

    @LoadEvent
    public void postRegister(ZRegister.Post e) {
        chestTEType = BlockEntityType.Builder.of(VariantChestBlockEntity::new, (Block[])regularChests.toArray(new Block[0])).build(null);
        trappedChestTEType = BlockEntityType.Builder.of(VariantTrappedChestBlockEntity::new, (Block[])trappedChests.toArray(new Block[0])).build(null);
        Quark.ZETA.registry.register(chestTEType, "variant_chest", Registries.BLOCK_ENTITY_TYPE);
        Quark.ZETA.registry.register(trappedChestTEType, "variant_trapped_chest", Registries.BLOCK_ENTITY_TYPE);
        Quark.LOOTR_INTEGRATION.postRegister();
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        this.manualChestMappings.clear();
        this.manualTrappedChestMappings.clear();
        ArrayList<String> chestsClone = new ArrayList<String>(this.structureChests);
        for (String s : chestsClone) {
            String[] toks = s.split("=");
            if (toks.length != 2) continue;
            String left = toks[0];
            String right = toks[1];
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)right));
            if (block == Blocks.AIR) continue;
            this.manualChestMappings.put(ResourceLocation.parse((String)left), block);
            if (!regularChests.contains(block)) continue;
            Block trapped = trappedChests.get(regularChests.indexOf(block));
            this.manualTrappedChestMappings.put(ResourceLocation.parse((String)left), trapped);
        }
    }

    private BlockState getGenerationChestBlockState(ServerLevelAccessor accessor, BlockState current, StructureBlockReplacementHandler.StructureHolder structure) {
        if (this.isEnabled() && this.replaceWorldgenChests) {
            if (current.getBlock() == Blocks.CHEST) {
                return this.replaceChestState(accessor, current, structure, this.chestMappings, this.manualChestMappings);
            }
            if (current.getBlock() == Blocks.TRAPPED_CHEST) {
                return this.replaceChestState(accessor, current, structure, this.trappedChestMappings, this.manualTrappedChestMappings);
            }
        }
        return null;
    }

    @Nullable
    private BlockState replaceChestState(ServerLevelAccessor accessor, BlockState current, StructureBlockReplacementHandler.StructureHolder structure, Map<TagKey<Structure>, Block> mappings, Map<ResourceLocation, Block> manualMappings) {
        Holder structureHolder = StructureBlockReplacementHandler.getStructure((ServerLevelAccessor)accessor, (StructureBlockReplacementHandler.StructureHolder)structure);
        if (structureHolder != null) {
            for (TagKey<Structure> structureTagKey : mappings.keySet()) {
                if (!structureHolder.is(structureTagKey)) continue;
                Block block = mappings.get(structureTagKey);
                return block.withPropertiesOf(current);
            }
            Optional<Block> manualMapping = structureHolder.unwrapKey().map(ResourceKey::location).map(manualMappings::get);
            if (manualMapping.isPresent()) {
                return manualMapping.get().withPropertiesOf(current);
            }
        }
        return null;
    }

    @PlayEvent
    public void onClickEntity(ZPlayerInteract.EntityInteractSpecific event) {
        AbstractChestedHorse horse;
        Entity target = event.getTarget();
        Player player = event.getEntity();
        ItemStack held = player.getItemInHand(event.getHand());
        if (!held.isEmpty() && target instanceof AbstractChestedHorse && !(horse = (AbstractChestedHorse)target).hasChest() && held.getItem() != Items.CHEST && held.is(Tags.Items.CHESTS_WOODEN)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)player.level().isClientSide));
            if (!target.level().isClientSide) {
                ItemStack copy = held.copy();
                copy.setCount(1);
                held.shrink(1);
                horse.getPersistentData().put(DONK_CHEST, copy.save((HolderLookup.Provider)player.level().registryAccess()));
                horse.setChest(true);
                horse.createInventory();
                ((AccessorAbstractChestedHorse)horse).quark$playChestEquipsSound();
            }
        }
    }

    @PlayEvent
    public void onDeath(ZLivingDeath event) {
        Entity target = event.getEntity();
        if (target instanceof AbstractChestedHorse) {
            AbstractChestedHorse horse = (AbstractChestedHorse)target;
            ItemStack chest = ItemStack.parseOptional((HolderLookup.Provider)target.level().registryAccess(), (CompoundTag)horse.getPersistentData().getCompound(DONK_CHEST));
            if (!chest.isEmpty() && horse.hasChest()) {
                WAIT_TO_REPLACE_CHEST.set(chest);
            }
        }
    }

    @PlayEvent
    public void onEntityJoinWorld(ZEntityJoinLevel event) {
        ItemEntity item;
        Entity target = event.getEntity();
        if (target instanceof ItemEntity && (item = (ItemEntity)target).getItem().getItem() == Items.CHEST) {
            ItemStack local = WAIT_TO_REPLACE_CHEST.get();
            if (local != null && !local.isEmpty()) {
                ((ItemEntity)target).setItem(local);
            }
            WAIT_TO_REPLACE_CHEST.remove();
        }
    }

    static {
        WAIT_TO_REPLACE_CHEST = new ThreadLocal();
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends VariantChestsModule {
        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            BlockEntityRenderers.register((BlockEntityType)chestTEType, ctx -> new VariantChestRenderer(ctx, false));
            BlockEntityRenderers.register((BlockEntityType)trappedChestTEType, ctx -> new VariantChestRenderer(ctx, true));
            QuarkClient.LOOTR_INTEGRATION.clientSetup(event);
        }
    }

    public static interface IVariantChest {
        public String getTexturePath();

        default public String getTextureFolder() {
            return "quark_variant_chests";
        }
    }
}

