/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block.be;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.violetmoon.quark.addons.oddities.block.pipe.BasePipeBlock;
import org.violetmoon.quark.addons.oddities.module.PipesModule;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.zeta.util.MiscUtil;
import org.violetmoon.zeta.util.SimpleInventoryBlockEntity;

public class PipeBlockEntity
extends SimpleInventoryBlockEntity {
    private static final String TAG_PIPE_ITEMS = "pipeItems";
    private static final String TAG_CONNECTIONS = "connections";
    private boolean iterating = false;
    public final List<PipeItem> pipeItems = new LinkedList<PipeItem>();
    public final List<PipeItem> queuedItems = new LinkedList<PipeItem>();
    private boolean skipSync = false;
    private final ConnectionType[] connectionsCache = new ConnectionType[6];
    private boolean convert = false;

    public PipeBlockEntity(BlockPos pos, BlockState state) {
        super(PipesModule.blockEntityType, pos, state);
    }

    public static boolean isTheGoodDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 4 && calendar.get(5) == 1;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PipeBlockEntity be) {
        be.tick();
    }

    public void tick() {
        Direction[] directionArray;
        boolean enabled;
        if (this.convert) {
            this.convert = false;
            this.refreshVisualConnections();
        }
        if (!(enabled = this.isPipeEnabled()) && this.level.getGameTime() % 10L == 0L && (directionArray = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)directionArray;
            serverLevel.sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f), (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, 3, 0.2, 0.2, 0.2, 0.0);
        }
        BlockState blockAt = this.level.getBlockState(this.worldPosition);
        if (!this.level.isClientSide && enabled && blockAt.is(PipesModule.pipesTag)) {
            for (Direction side : Direction.values()) {
                if (this.connectionsCache[side.ordinal()] != ConnectionType.OPENING) continue;
                double minX = (double)this.worldPosition.getX() + 0.25 + 0.5 * (double)Math.min(0, side.getStepX());
                double minY = (double)this.worldPosition.getY() + 0.25 + 0.5 * (double)Math.min(0, side.getStepY());
                double minZ = (double)this.worldPosition.getZ() + 0.25 + 0.5 * (double)Math.min(0, side.getStepZ());
                double maxX = (double)this.worldPosition.getX() + 0.75 + 0.5 * (double)Math.max(0, side.getStepX());
                double maxY = (double)this.worldPosition.getY() + 0.75 + 0.5 * (double)Math.max(0, side.getStepY());
                double maxZ = (double)this.worldPosition.getZ() + 0.75 + 0.5 * (double)Math.max(0, side.getStepZ());
                Direction opposite = side.getOpposite();
                boolean pickedItemsUp = false;
                Predicate<ItemEntity> predicate = entity -> {
                    if (entity == null || !entity.isAlive()) {
                        return false;
                    }
                    Vec3 motion = entity.getDeltaMovement();
                    Direction dir = Direction.getNearest((double)motion.x, (double)motion.y, (double)motion.z);
                    return dir == opposite;
                };
                for (ItemEntity item : this.level.getEntitiesOfClass(ItemEntity.class, new AABB(minX, minY, minZ, maxX, maxY, maxZ), predicate)) {
                    this.passIn(item.getItem().copy(), side);
                    if (PipesModule.doPipesWhoosh) {
                        if (PipeBlockEntity.isTheGoodDay()) {
                            this.level.playSound(null, item.getX(), item.getY(), item.getZ(), QuarkSounds.BLOCK_PIPE_PICKUP_LENNY, SoundSource.BLOCKS, 1.0f, 1.0f);
                        } else {
                            this.level.playSound(null, item.getX(), item.getY(), item.getZ(), QuarkSounds.BLOCK_PIPE_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                    if (PipesModule.emitVibrations) {
                        this.getLevel().gameEvent((Holder)GameEvent.PROJECTILE_LAND, this.getBlockPos(), GameEvent.Context.of((BlockState)this.getBlockState()));
                    }
                    pickedItemsUp = true;
                    item.discard();
                }
                if (!pickedItemsUp) continue;
                this.sync();
            }
        }
        int currentOut = this.getComparatorOutput();
        if (!this.pipeItems.isEmpty()) {
            if (PipesModule.maxPipeItems > 0 && this.pipeItems.size() > PipesModule.maxPipeItems && !this.level.isClientSide) {
                this.level.levelEvent(2001, this.worldPosition, Block.getId((BlockState)this.level.getBlockState(this.worldPosition)));
                this.dropItem(new ItemStack((ItemLike)this.getBlockState().getBlock()));
                this.level.removeBlock(this.getBlockPos(), false);
            }
            ListIterator<PipeItem> itemItr = this.pipeItems.listIterator();
            this.iterating = true;
            while (itemItr.hasNext()) {
                PipeItem item = itemItr.next();
                Direction lastFacing = item.outgoingFace;
                if (!item.tick(this)) continue;
                itemItr.remove();
                if (item.valid) {
                    this.passOut(item);
                    continue;
                }
                if (this.level.isClientSide) continue;
                this.dropItem(item.stack, lastFacing, true);
            }
            this.iterating = false;
            this.pipeItems.addAll(this.queuedItems);
            if (!this.queuedItems.isEmpty()) {
                this.sync();
            }
            this.queuedItems.clear();
        }
        if (this.getComparatorOutput() != currentOut) {
            this.level.updateNeighbourForOutputSignal(this.getBlockPos(), this.getBlockState().getBlock());
        }
    }

    public int getComparatorOutput() {
        return Math.min(15, this.pipeItems.size());
    }

    public Iterator<PipeItem> getItemIterator() {
        return this.pipeItems.iterator();
    }

    public boolean allowsFullConnection(ConnectionType conn) {
        BasePipeBlock pipe;
        Block block = this.getBlockState().getBlock();
        return block instanceof BasePipeBlock && (pipe = (BasePipeBlock)block).allowsFullConnection(conn);
    }

    public boolean passIn(ItemStack stack, Direction face, Direction backlog, long seed, int time) {
        PipeItem item = new PipeItem(stack, face, seed);
        item.lastTickUpdated = this.level.getGameTime();
        item.backloggedFace = backlog;
        if (!this.iterating) {
            int currentOut = this.getComparatorOutput();
            this.pipeItems.add(item);
            item.timeInWorld = time;
            if (this.getComparatorOutput() != currentOut) {
                this.level.updateNeighbourForOutputSignal(this.getBlockPos(), this.getBlockState().getBlock());
            }
        } else {
            this.queuedItems.add(item);
        }
        return true;
    }

    public boolean passIn(ItemStack stack, Direction face) {
        return this.passIn(stack, face, null, this.level.random.nextLong(), 0);
    }

    protected void passOut(PipeItem item) {
        boolean did = false;
        BlockPos targetPos = this.getBlockPos().relative(item.outgoingFace);
        if (this.level.getBlockState(targetPos).getBlock() instanceof WorldlyContainerHolder) {
            ItemStack result = MiscUtil.putIntoInv((ItemStack)item.stack, (LevelAccessor)this.level, (BlockPos)targetPos, null, (Direction)item.outgoingFace.getOpposite(), (boolean)false, (boolean)false);
            if (result.getCount() != item.stack.getCount()) {
                did = true;
                if (!result.isEmpty()) {
                    this.bounceBack(item, result);
                }
            }
        } else {
            BlockEntity tile = this.level.getBlockEntity(targetPos);
            if (tile != null) {
                ItemStack result;
                if (tile instanceof PipeBlockEntity) {
                    PipeBlockEntity pipe = (PipeBlockEntity)tile;
                    did = pipe.passIn(item.stack, item.outgoingFace.getOpposite(), null, item.rngSeed, item.timeInWorld);
                } else if (!this.level.isClientSide && (result = MiscUtil.putIntoInv((ItemStack)item.stack, (LevelAccessor)this.level, (BlockPos)targetPos, (BlockEntity)tile, (Direction)item.outgoingFace.getOpposite(), (boolean)false, (boolean)false)).getCount() != item.stack.getCount()) {
                    did = true;
                    if (!result.isEmpty()) {
                        this.bounceBack(item, result);
                    }
                }
            }
        }
        if (!did) {
            this.bounceBack(item, null);
        }
    }

    private void bounceBack(PipeItem item, ItemStack stack) {
        if (!this.level.isClientSide) {
            this.passIn(stack == null ? item.stack : stack, item.outgoingFace, item.incomingFace, item.rngSeed, item.timeInWorld);
        }
    }

    public void dropItem(ItemStack stack) {
        this.dropItem(stack, null, false);
    }

    public void dropItem(ItemStack stack, Direction facing, boolean playSound) {
        if (!this.level.isClientSide) {
            double posX = (double)this.worldPosition.getX() + 0.5;
            double posY = (double)this.worldPosition.getY() + 0.25;
            double posZ = (double)this.worldPosition.getZ() + 0.5;
            if (facing != null) {
                double shift = this.allowsFullConnection(ConnectionType.OPENING) ? 0.7 : 0.4;
                posX -= (double)facing.getStepX() * shift;
                posY -= (double)facing.getStepY() * (shift + 0.15);
                posZ -= (double)facing.getStepZ() * shift;
            }
            boolean shootOut = this.isPipeEnabled();
            float pitch = 1.0f;
            if (!shootOut) {
                pitch = 0.025f;
            }
            if (playSound) {
                if (PipesModule.doPipesWhoosh) {
                    if (PipeBlockEntity.isTheGoodDay()) {
                        this.level.playSound(null, posX, posY, posZ, QuarkSounds.BLOCK_PIPE_SHOOT_LENNY, SoundSource.BLOCKS, 1.0f, pitch);
                    } else {
                        this.level.playSound(null, posX, posY, posZ, QuarkSounds.BLOCK_PIPE_SHOOT, SoundSource.BLOCKS, 1.0f, pitch);
                    }
                }
                if (PipesModule.emitVibrations) {
                    this.getLevel().gameEvent((Holder)GameEvent.PROJECTILE_SHOOT, this.getBlockPos(), GameEvent.Context.of((BlockState)this.getBlockState()));
                }
            }
            ItemEntity entity = new ItemEntity(this.level, posX, posY, posZ, stack);
            entity.setDefaultPickUpDelay();
            double velocityMod = 0.5;
            if (!shootOut) {
                velocityMod = 0.125;
            }
            if (facing != null) {
                double mx = (double)(-facing.getStepX()) * velocityMod;
                double my = (double)(-facing.getStepY()) * velocityMod;
                double mz = (double)(-facing.getStepZ()) * velocityMod;
                entity.setDeltaMovement(mx, my, mz);
            }
            this.level.addFreshEntity((Entity)entity);
        }
    }

    public void dropAllItems() {
        for (PipeItem item : this.pipeItems) {
            this.dropItem(item.stack);
        }
        this.pipeItems.clear();
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void readSharedNBT(CompoundTag tag, HolderLookup.Provider provider) {
        this.skipSync = true;
        super.readSharedNBT(tag, provider);
        this.skipSync = false;
        ListTag pipeItemList = tag.getList(TAG_PIPE_ITEMS, (int)tag.getId());
        this.pipeItems.clear();
        pipeItemList.forEach(listCmp -> {
            PipeItem item = PipeItem.readFromNBT((CompoundTag)listCmp, provider);
            this.pipeItems.add(item);
        });
        if (tag.contains(TAG_CONNECTIONS)) {
            byte[] c = tag.getByteArray(TAG_CONNECTIONS);
            for (int i = 0; i < c.length; ++i) {
                this.connectionsCache[i] = ConnectionType.values()[c[i]];
            }
        }
    }

    public void writeSharedNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeSharedNBT(tag, provider);
        ListTag pipeItemList = new ListTag();
        for (PipeItem item : this.pipeItems) {
            CompoundTag listCmp = new CompoundTag();
            item.writeToNBT(listCmp, provider);
            pipeItemList.add((Object)listCmp);
        }
        tag.put(TAG_PIPE_ITEMS, (Tag)pipeItemList);
        for (int i = 0; i < this.connectionsCache.length; ++i) {
            if (this.connectionsCache[i] != null) continue;
            this.connectionsCache[i] = ConnectionType.NONE;
            this.convert = true;
        }
        tag.putByteArray(TAG_CONNECTIONS, Arrays.stream(this.connectionsCache).map(c -> (byte)c.ordinal()).toList());
    }

    protected boolean canFit(ItemStack stack, BlockPos pos, Direction face) {
        if (this.level.getBlockState(pos).getBlock() instanceof WorldlyContainerHolder) {
            return MiscUtil.canPutIntoInv((ItemStack)stack, (LevelAccessor)this.level, (BlockPos)pos, null, (Direction)face, (boolean)false);
        }
        BlockEntity tile = this.level.getBlockEntity(pos);
        if (tile == null) {
            return false;
        }
        if (tile instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)tile;
            return pipe.isPipeEnabled();
        }
        return MiscUtil.canPutIntoInv((ItemStack)stack, (LevelAccessor)this.level, (BlockPos)pos, (BlockEntity)tile, (Direction)face, (boolean)false);
    }

    protected boolean isPipeEnabled() {
        BlockState state = this.level.getBlockState(this.worldPosition);
        return state.is(PipesModule.pipesTag) && !this.level.hasNeighborSignal(this.worldPosition);
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack itemStackIn, @NotNull Direction direction) {
        return direction != null && index == direction.ordinal() && this.isPipeEnabled();
    }

    public void setItem(int i, @NotNull ItemStack itemstack) {
        if (!itemstack.isEmpty()) {
            Direction side = Direction.values()[i];
            this.passIn(itemstack, side);
            if (!this.level.isClientSide && !this.skipSync) {
                this.sync();
            }
        }
    }

    public void startOpen(@NotNull Player player) {
    }

    public void stopOpen(@NotNull Player player) {
    }

    public void inventoryChanged(int i) {
    }

    public int getContainerSize() {
        return 6;
    }

    protected boolean needsToSyncInventory() {
        return true;
    }

    public void sync() {
        MiscUtil.syncTE((BlockEntity)this);
    }

    public void refreshVisualConnections() {
        for (Direction direction : Direction.values()) {
            this.updateConnection(direction);
        }
    }

    public ConnectionType updateConnection(Direction facing) {
        ConnectionType c;
        this.connectionsCache[facing.ordinal()] = c = PipeBlockEntity.computeConnectionTo((BlockGetter)this.level, this.worldPosition, facing);
        return c;
    }

    public ConnectionType getConnectionTo(Direction side) {
        ConnectionType c = this.connectionsCache[side.ordinal()];
        if (c == null) {
            c = this.updateConnection(side);
        }
        return c;
    }

    public static ConnectionType computeConnectionTo(BlockGetter world, BlockPos pos, Direction face) {
        return PipeBlockEntity.computeConnectionTo(world, pos, face, false);
    }

    private static ConnectionType computeConnectionTo(BlockGetter world, BlockPos pos, Direction face, boolean recursed) {
        block8: {
            BlockPos truePos = pos.relative(face);
            BlockState state = world.getBlockState(truePos);
            if (state.getBlock() instanceof WorldlyContainerHolder) {
                return ConnectionType.TERMINAL;
            }
            BlockEntity tile = world.getBlockEntity(truePos);
            if (tile != null) {
                if (tile instanceof PipeBlockEntity) {
                    return ConnectionType.PIPE;
                }
                if (tile instanceof Container) {
                    return PipeBlockEntity.canHaveOffset(state, pos, world, face) ? ConnectionType.TERMINAL_OFFSET : ConnectionType.TERMINAL;
                }
            }
            if (!recursed) {
                ConnectionType other = PipeBlockEntity.computeConnectionTo(world, pos, face.getOpposite(), true);
                if (other.isSolid) {
                    for (Direction d : Direction.values()) {
                        if (d.getAxis() == face.getAxis()) continue;
                        other = PipeBlockEntity.computeConnectionTo(world, pos, d, true);
                        if (!other.isSolid) {
                            continue;
                        }
                        break block8;
                    }
                    return ConnectionType.OPENING;
                }
            }
        }
        return ConnectionType.NONE;
    }

    private static boolean canHaveOffset(BlockState state, BlockPos pos, BlockGetter world, Direction dir) {
        VoxelShape shape = state.getCollisionShape(world, pos);
        if (dir.getAxisDirection() == Direction.AxisDirection.NEGATIVE) {
            return shape.max(dir.getAxis()) < 1.0;
        }
        return shape.min(dir.getAxis()) > 0.0;
    }

    public static enum ConnectionType {
        NONE(false, false, false, 0.0),
        PIPE(true, true, false, 0.0),
        OPENING(false, true, true, -0.125, 0.1875),
        TERMINAL(true, true, true, 0.125),
        TERMINAL_OFFSET(true, true, true, 0.1875);

        public final boolean isSolid;
        public final boolean allowsItems;
        public final boolean isFlared;
        private final double flareShift;
        private final double fullFlareShift;

        private ConnectionType(boolean isSolid, boolean allowsItems, boolean isFlared, double flareShift, double fullFlareShift) {
            this.isSolid = isSolid;
            this.allowsItems = allowsItems;
            this.isFlared = isFlared;
            this.flareShift = flareShift;
            this.fullFlareShift = fullFlareShift;
        }

        private ConnectionType(boolean isSolid, boolean allowsItems, boolean isFlared, double flareShift) {
            this(isSolid, allowsItems, isFlared, flareShift, flareShift);
        }

        public double getFlareShift(PipeBlockEntity pipe) {
            return pipe.allowsFullConnection(this) ? this.fullFlareShift : this.flareShift;
        }
    }

    public static class PipeItem {
        private static final String TAG_TICKS = "ticksInPipe";
        private static final String TAG_INCOMING = "incomingFace";
        private static final String TAG_OUTGOING = "outgoingFace";
        private static final String TAG_BACKLOGGED = "backloggedFace";
        private static final String TAG_RNG_SEED = "rngSeed";
        private static final String TAG_TIME_IN_WORLD = "timeInWorld";
        private static final List<Direction> HORIZONTAL_SIDES_LIST = Arrays.asList(MiscUtil.HORIZONTALS);
        public final ItemStack stack;
        public int ticksInPipe;
        public final Direction incomingFace;
        public Direction outgoingFace;
        public Direction backloggedFace;
        public long rngSeed;
        public int timeInWorld = 0;
        public boolean valid = true;
        protected long lastTickUpdated = 0L;

        public PipeItem(ItemStack stack, Direction face, long rngSeed) {
            this.stack = stack;
            this.ticksInPipe = 0;
            this.incomingFace = this.outgoingFace = face;
            this.rngSeed = rngSeed;
        }

        protected boolean tick(PipeBlockEntity pipe) {
            long gameTime = pipe.level.getGameTime();
            if (this.lastTickUpdated != gameTime) {
                this.lastTickUpdated = gameTime;
                ++this.ticksInPipe;
                ++this.timeInWorld;
                if (this.ticksInPipe == PipesModule.effectivePipeSpeed / 2 - 1) {
                    this.outgoingFace = this.getTargetFace(pipe);
                }
                if (this.outgoingFace == null) {
                    this.valid = false;
                    return true;
                }
            }
            return this.ticksInPipe >= PipesModule.effectivePipeSpeed;
        }

        protected Direction getTargetFace(PipeBlockEntity pipe) {
            BlockPos pipePos = pipe.getBlockPos();
            if (this.incomingFace != Direction.DOWN && this.backloggedFace != Direction.DOWN && pipe.canFit(this.stack, pipePos.relative(Direction.DOWN), Direction.UP)) {
                return Direction.DOWN;
            }
            Direction incomingOpposite = this.incomingFace;
            if (this.incomingFace.getAxis() != Direction.Axis.Y && (incomingOpposite = this.incomingFace.getOpposite()) != this.backloggedFace && pipe.canFit(this.stack, pipePos.relative(incomingOpposite), this.incomingFace)) {
                return incomingOpposite;
            }
            ArrayList<Direction> sides = new ArrayList<Direction>(HORIZONTAL_SIDES_LIST);
            sides.remove(this.incomingFace);
            sides.remove(incomingOpposite);
            Random rng = new Random(this.rngSeed);
            this.rngSeed = rng.nextLong();
            Collections.shuffle(sides, rng);
            for (Direction side : sides) {
                if (side == this.backloggedFace || !pipe.canFit(this.stack, pipePos.relative(side), side.getOpposite())) continue;
                return side;
            }
            if (this.incomingFace != Direction.UP && this.backloggedFace != Direction.UP && pipe.canFit(this.stack, pipePos.relative(Direction.UP), Direction.DOWN)) {
                return Direction.UP;
            }
            if (this.backloggedFace != null) {
                return this.backloggedFace;
            }
            return null;
        }

        public float getTimeFract(float partial) {
            return ((float)this.ticksInPipe + partial) / (float)PipesModule.effectivePipeSpeed;
        }

        public void writeToNBT(CompoundTag cmp, HolderLookup.Provider provider) {
            this.stack.save(provider, (Tag)cmp);
            cmp.putInt(TAG_TICKS, this.ticksInPipe);
            cmp.putInt(TAG_INCOMING, this.incomingFace.ordinal());
            cmp.putInt(TAG_OUTGOING, this.outgoingFace.ordinal());
            cmp.putInt(TAG_BACKLOGGED, this.backloggedFace != null ? this.backloggedFace.ordinal() : -1);
            cmp.putLong(TAG_RNG_SEED, this.rngSeed);
            cmp.putInt(TAG_TIME_IN_WORLD, this.timeInWorld);
        }

        public static PipeItem readFromNBT(CompoundTag cmp, HolderLookup.Provider provider) {
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)cmp);
            Direction inFace = Direction.values()[cmp.getInt(TAG_INCOMING)];
            long rngSeed = cmp.getLong(TAG_RNG_SEED);
            PipeItem item = new PipeItem(stack, inFace, rngSeed);
            item.ticksInPipe = cmp.getInt(TAG_TICKS);
            item.outgoingFace = Direction.values()[cmp.getInt(TAG_OUTGOING)];
            item.timeInWorld = cmp.getInt(TAG_TIME_IN_WORLD);
            int backloggedId = cmp.getInt(TAG_BACKLOGGED);
            item.backloggedFace = backloggedId == -1 ? null : Direction.values()[backloggedId];
            return item;
        }
    }
}

