/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.integration.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.block.be.MatrixEnchantingTableBlockEntity;
import org.violetmoon.quark.addons.oddities.client.screen.BackpackInventoryScreen;
import org.violetmoon.quark.addons.oddities.client.screen.CrateScreen;
import org.violetmoon.quark.addons.oddities.module.MatrixEnchantingModule;
import org.violetmoon.quark.addons.oddities.util.CustomInfluence;
import org.violetmoon.quark.addons.oddities.util.Influence;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.building.module.VariantFurnacesModule;
import org.violetmoon.quark.content.tools.item.AncientTomeItem;
import org.violetmoon.quark.content.tools.module.AncientTomesModule;
import org.violetmoon.quark.content.tools.module.PickarangModule;
import org.violetmoon.quark.content.tweaks.module.DiamondRepairModule;
import org.violetmoon.quark.integration.jei.BackpackRecipeTransferHandler;
import org.violetmoon.quark.integration.jei.InfluenceCategory;
import org.violetmoon.quark.integration.jei.InfluenceEntry;

@JeiPlugin
public class QuarkJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = Quark.asResource("quark");
    public static final RecipeType<InfluenceEntry> INFLUENCING = RecipeType.create((String)"quark", (String)"influence", InfluenceEntry.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registration) {
    }

    public void registerVanillaCategoryExtensions(@NotNull IVanillaCategoryExtensionRegistration registration) {
    }

    private boolean matrix() {
        return Quark.ZETA.modules.isEnabled(MatrixEnchantingModule.class) && MatrixEnchantingModule.allowInfluencing && !MatrixEnchantingModule.candleInfluencingFailed;
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        if (this.matrix()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new InfluenceCategory(registration.getJeiHelpers().getGuiHelper())});
        }
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        if (Quark.ZETA.modules.isEnabled(AncientTomesModule.class)) {
            this.registerAncientTomeAnvilRecipes(registration, factory);
        }
        if (Quark.ZETA.modules.isEnabled(PickarangModule.class)) {
            this.registerPickarangAnvilRepairs(PickarangModule.pickarang, Items.DIAMOND, registration, factory);
            this.registerPickarangAnvilRepairs(PickarangModule.flamerang, Items.NETHERITE_INGOT, registration, factory);
        }
        if (this.matrix()) {
            this.registerInfluenceRecipes(registration);
        }
        if (Quark.ZETA.modules.isEnabled(DiamondRepairModule.class)) {
            this.registerCustomAnvilRecipes(registration, factory);
        }
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        if (Quark.ZETA.modules.isEnabled(VariantFurnacesModule.class)) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)VariantFurnacesModule.deepslateFurnace), new RecipeType[]{RecipeTypes.FUELING, RecipeTypes.SMELTING});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)VariantFurnacesModule.blackstoneFurnace), new RecipeType[]{RecipeTypes.FUELING, RecipeTypes.SMELTING});
        }
        if (this.matrix()) {
            if (MatrixEnchantingModule.automaticallyConvert) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.ENCHANTING_TABLE), new RecipeType[]{INFLUENCING});
            } else {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)MatrixEnchantingModule.matrixEnchanter), new RecipeType[]{INFLUENCING});
            }
        }
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(CrateScreen.class, (IGuiContainerHandler)new CrateGuiHandler());
        registration.addRecipeClickArea(BackpackInventoryScreen.class, 137, 29, 10, 13, new RecipeType[]{RecipeTypes.CRAFTING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new BackpackRecipeTransferHandler(registration.getTransferHelper()), RecipeTypes.CRAFTING);
    }

    private void registerAncientTomeAnvilRecipes(@NotNull IRecipeRegistration registration, @NotNull IVanillaRecipeFactory factory) {
        ArrayList<IJeiAnvilRecipe> recipes = new ArrayList<IJeiAnvilRecipe>();
        for (Holder<Enchantment> enchant : AncientTomesModule.validEnchants) {
            EnchantmentInstance data = new EnchantmentInstance(enchant, ((Enchantment)enchant.value()).getMaxLevel());
            recipes.add(factory.createAnvilRecipe(EnchantedBookItem.createForEnchantment((EnchantmentInstance)data), Collections.singletonList(AncientTomeItem.getEnchantedItemStack(enchant)), Collections.singletonList(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(data.enchantment, data.level + 1)))));
        }
        registration.addRecipes(RecipeTypes.ANVIL, recipes);
    }

    private void registerPickarangAnvilRepairs(Item pickarang, Item repairMaterial, @NotNull IRecipeRegistration registration, @NotNull IVanillaRecipeFactory factory) {
        ItemStack nearlyBroken = new ItemStack((ItemLike)pickarang);
        nearlyBroken.setDamageValue(nearlyBroken.getMaxDamage());
        ItemStack veryDamaged = nearlyBroken.copy();
        veryDamaged.setDamageValue(veryDamaged.getMaxDamage() * 3 / 4);
        ItemStack damaged = nearlyBroken.copy();
        damaged.setDamageValue(damaged.getMaxDamage() * 2 / 4);
        IJeiAnvilRecipe materialRepair = factory.createAnvilRecipe(nearlyBroken, Collections.singletonList(new ItemStack((ItemLike)repairMaterial)), Collections.singletonList(veryDamaged));
        IJeiAnvilRecipe toolRepair = factory.createAnvilRecipe(veryDamaged, Collections.singletonList(veryDamaged), Collections.singletonList(damaged));
        registration.addRecipes(RecipeTypes.ANVIL, Arrays.asList(materialRepair, toolRepair));
    }

    private void registerInfluenceRecipes(@NotNull IRecipeRegistration registration) {
        registration.addRecipes(INFLUENCING, Arrays.stream(DyeColor.values()).map(color -> {
            Block candle = MatrixEnchantingTableBlockEntity.CANDLES.get(color.getId());
            Influence influence = MatrixEnchantingModule.candleInfluences.get(color).toInfluence();
            return new InfluenceEntry(candle, influence);
        }).filter(InfluenceEntry::hasAny).collect(Collectors.toList()));
        registration.addRecipes(INFLUENCING, MatrixEnchantingModule.customInfluences.entrySet().stream().map(entry -> {
            Block block = ((BlockState)entry.getKey()).getBlock();
            Influence influence = ((CustomInfluence)entry.getValue()).influence().toInfluence();
            return new InfluenceEntry(block, influence);
        }).filter(InfluenceEntry::hasAny).collect(Collectors.toList()));
    }

    private void hideAnvilRepairRecipes(@NotNull IRecipeManager manager) {
        Stream anvilRecipe = manager.createRecipeLookup(RecipeTypes.ANVIL).get();
        List hidden = anvilRecipe.filter(r -> {
            ItemStack left = r.getLeftInputs().stream().filter(st -> {
                Item i = st.getItem();
                return DiamondRepairModule.repairChanges.containsKey((Object)i) || DiamondRepairModule.unrepairableItems.contains(i);
            }).findFirst().orElse(null);
            if (left != null) {
                for (ItemStack right : r.getRightInputs()) {
                    Item item = left.getItem();
                    if (!item.isValidRepairItem(left, right)) continue;
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
        manager.hideRecipes(RecipeTypes.ANVIL, hidden);
    }

    private void registerCustomAnvilRecipes(@NotNull IRecipeRegistration registration, @NotNull IVanillaRecipeFactory factory) {
        for (Item item : DiamondRepairModule.repairChanges.keySet()) {
            ItemStack left = new ItemStack((ItemLike)item);
            ItemStack out = left.copy();
            int max = (Integer)left.get(DataComponents.MAX_DAMAGE);
            left.setDamageValue(max - 1);
            out.setDamageValue(max - max / 4);
            for (Item repair : DiamondRepairModule.repairChanges.get((Object)item)) {
                IJeiAnvilRecipe toolRepair = factory.createAnvilRecipe(left, Collections.singletonList(new ItemStack((ItemLike)repair)), Collections.singletonList(out));
                registration.addRecipes(RecipeTypes.ANVIL, List.of(toolRepair));
            }
        }
    }

    private static class CrateGuiHandler
    implements IGuiContainerHandler<CrateScreen> {
        private CrateGuiHandler() {
        }

        @NotNull
        public List<Rect2i> getGuiExtraAreas(@NotNull CrateScreen containerScreen) {
            return containerScreen.getExtraAreas();
        }
    }
}

