/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.entity.rang;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.content.mobs.entity.Toretoise;
import org.violetmoon.quark.content.tools.config.PickarangType;
import org.violetmoon.quark.content.tools.entity.rang.Flamerang;
import org.violetmoon.quark.content.tools.module.PickarangModule;

public abstract class AbstractPickarang<T extends AbstractPickarang<T>>
extends Projectile {
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.defineId(AbstractPickarang.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Boolean> RETURNING = SynchedEntityData.defineId(AbstractPickarang.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private UUID ownerId;
    protected int liveTime;
    private int slot;
    private int blockHitCount;
    private IntOpenHashSet entitiesHit;
    private static final String TAG_RETURNING = "returning";
    private static final String TAG_LIVE_TIME = "liveTime";
    private static final String TAG_BLOCKS_BROKEN = "hitCount";
    private static final String TAG_RETURN_SLOT = "returnSlot";
    private static final String TAG_ITEM_STACK = "itemStack";

    public AbstractPickarang(EntityType<? extends AbstractPickarang<?>> type, Level worldIn) {
        super(type, worldIn);
    }

    public AbstractPickarang(EntityType<? extends AbstractPickarang<?>> type, Level worldIn, LivingEntity throwerIn) {
        super(type, worldIn);
        Vec3 pos = throwerIn.position();
        this.setPos(pos.x, pos.y + (double)throwerIn.getEyeHeight(), pos.z);
        this.ownerId = throwerIn.getUUID();
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -Mth.sin((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.cos((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
        Vec3 Vector3d = entityThrower.getDeltaMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(Vector3d.x, entityThrower.onGround() ? 0.0 : Vector3d.y, Vector3d.z));
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vec = new Vec3(x, y, z).normalize().add(this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy).scale((double)velocity);
        this.setDeltaMovement(vec);
        float f = (float)vec.horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)vec.x, (double)vec.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec.y, (double)f) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void lerpMotion(double x, double y, double z) {
        this.setDeltaMovement(x, y, z);
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float f = (float)Math.sqrt(x * x + z * z);
            this.setYRot((float)(Mth.atan2((double)x, (double)z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)y, (double)f) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
    }

    public void setThrowData(int slot, ItemStack stack) {
        this.slot = slot;
        this.setStack(stack.copy());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(STACK, (Object)new ItemStack((ItemLike)PickarangModule.pickarang));
        builder.define(RETURNING, (Object)false);
    }

    protected void checkImpact() {
        if (this.level().isClientSide) {
            return;
        }
        Vec3 motion = this.getDeltaMovement();
        Vec3 position = this.position();
        Vec3 rayEnd = position.add(motion);
        boolean doEntities = true;
        int tries = 100;
        while (this.isAlive() && !this.isReturning()) {
            if (doEntities) {
                result = this.raycastEntities(position, rayEnd);
                if (result != null) {
                    this.onHit((HitResult)result);
                } else {
                    doEntities = false;
                }
            } else {
                result = this.level().clip(new ClipContext(position, rayEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                if (result.getType() == HitResult.Type.MISS) {
                    return;
                }
                this.onHit((HitResult)result);
            }
            if (tries-- > 0) continue;
            new RuntimeException("Pickarang hit way too much, this shouldn't happen").printStackTrace();
            return;
        }
    }

    @Nullable
    protected EntityHitResult raycastEntities(Vec3 from, Vec3 to) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)from, (Vec3)to, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), entity -> !(entity.isSpectator() || !entity.isAlive() || !entity.isPickable() && !(entity instanceof AbstractPickarang) || entity == this.getOwner() || this.entitiesHit != null && this.entitiesHit.contains(entity.getId())));
    }

    protected boolean isBlockBlackListead(BlockState state) {
        return state.is(PickarangModule.pickarangImmuneTag);
    }

    protected void onHitBlock(BlockHitResult result) {
        Entity entity;
        super.onHitBlock(result);
        BlockPos hit = result.getBlockPos();
        BlockState state = this.level().getBlockState(hit);
        if (this.getPiercingModifier() == 0 || state.isSolid()) {
            this.addHit();
        }
        if (!((entity = this.getOwner()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ItemStack prev = player.getMainHandItem();
        player.getInventory().setItem(player.getInventory().selected, this.getStack());
        player.setItemInHand(InteractionHand.MAIN_HAND, this.getStack());
        float progress = this.getBlockDestroyProgress(state, (Player)player, (BlockGetter)this.level(), hit);
        if (progress == 0.0f) {
            return;
        }
        float equivalentHardness = 1.0f / progress / 100.0f * 3.3333333f;
        if ((double)equivalentHardness <= this.getPickarangType().maxHardness && equivalentHardness >= 0.0f && !this.isBlockBlackListead(state) || player.getAbilities().instabuild) {
            if (player.gameMode.destroyBlock(hit)) {
                this.level().levelEvent(null, 2001, hit, Block.getId((BlockState)state));
            } else {
                this.clank((HitResult)result);
            }
            this.setStack(player.getInventory().getSelected());
        } else {
            this.clank((HitResult)result);
        }
        player.setItemInHand(InteractionHand.MAIN_HAND, prev);
        player.getInventory().setItem(player.getInventory().selected, prev);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity owner = this.getOwner();
        Entity hit = result.getEntity();
        if (hit == owner) {
            return;
        }
        this.addHit(hit);
        if (hit instanceof AbstractPickarang) {
            AbstractPickarang apg = (AbstractPickarang)hit;
            apg.setReturning();
            this.clank((HitResult)result);
            return;
        }
        ItemStack pickarang = this.getStack();
        ItemAttributeModifiers modifiers = pickarang.getAttributeModifiers();
        ArrayListMultimap attributeModifiers = ArrayListMultimap.create();
        for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
            attributeModifiers.put((Object)entry.attribute(), (Object)entry.modifier());
        }
        if (owner instanceof LivingEntity) {
            Toretoise toretoise;
            int ore;
            float prevHealth;
            LivingEntity leOwner = (LivingEntity)owner;
            ItemStack prev = leOwner.getMainHandItem();
            leOwner.setItemInHand(InteractionHand.MAIN_HAND, pickarang);
            leOwner.getAttributes().addTransientAttributeModifiers((Multimap)attributeModifiers);
            PickarangModule.setActivePickarangDamage(PickarangModule.getDamageSource((Entity)this, (Entity)leOwner));
            int ticksSinceLastSwing = leOwner.attackStrengthTicker;
            leOwner.attackStrengthTicker = (int)(1.0 / leOwner.getAttributeValue(Attributes.ATTACK_SPEED) * 20.0) + 1;
            float f = prevHealth = hit instanceof LivingEntity ? ((LivingEntity)hit).getHealth() : 0.0f;
            if (hit instanceof Toretoise && (ore = (toretoise = (Toretoise)hit).getOreType()) != 0) {
                this.addHit((Entity)toretoise);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    LootParams.Builder lootBuilder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.TOOL, (Object)pickarang);
                    if (owner instanceof Player) {
                        Player player = (Player)owner;
                        lootBuilder.withLuck(player.getLuck());
                    }
                    toretoise.dropOre(ore, lootBuilder);
                }
            } else {
                if (owner instanceof Player) {
                    Player p = (Player)owner;
                    p.attack(hit);
                } else {
                    leOwner.doHurtTarget(hit);
                }
                if (hit instanceof LivingEntity && ((LivingEntity)hit).getHealth() == prevHealth) {
                    this.clank((HitResult)result);
                }
            }
            leOwner.attackStrengthTicker = ticksSinceLastSwing;
            this.setStack(leOwner.getMainHandItem());
            leOwner.setItemInHand(InteractionHand.MAIN_HAND, prev);
            leOwner.getAttributes().addTransientAttributeModifiers((Multimap)attributeModifiers);
            PickarangModule.setActivePickarangDamage(null);
        } else {
            AttributeSupplier.Builder mapBuilder = new AttributeSupplier.Builder();
            mapBuilder.add(Attributes.ATTACK_DAMAGE, 1.0);
            AttributeSupplier map = mapBuilder.build();
            AttributeMap manager = new AttributeMap(map);
            manager.addTransientAttributeModifiers((Multimap)attributeModifiers);
            ItemStack stack = this.getStack();
            stack.hurtAndBreak(1, (LivingEntity)owner, null);
            this.setStack(stack);
            hit.hurt(PickarangModule.getDamageSource((Entity)this, owner), (float)manager.getValue(Attributes.ATTACK_DAMAGE));
        }
    }

    private void setTransientModifiers(ItemAttributeModifiers modifiers, LivingEntity living) {
        for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
            AttributeInstance instance = living.getAttribute(entry.attribute());
            if (instance == null) continue;
            instance.addTransientModifier(entry.modifier());
        }
    }

    private float getBlockDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        float f = state.getDestroySpeed(level, pos);
        if (f == -1.0f) {
            return 0.0f;
        }
        float i = EventHooks.doPlayerHarvestCheck((Player)player, (BlockState)state, (BlockGetter)level, (BlockPos)pos) ? 30.0f : 100.0f;
        float digSpeed = this.getPlayerDigSpeed(player, state, pos);
        return digSpeed / (f * i);
    }

    private float getPlayerDigSpeed(Player player, BlockState state, @Nullable BlockPos pos) {
        float f = 1.0f;
        if (MobEffectUtil.hasDigSpeed((LivingEntity)player)) {
            f *= 1.0f + (float)(MobEffectUtil.getDigSpeedAmplification((LivingEntity)player) + 1) * 0.2f;
        }
        if (player.hasEffect(MobEffects.DIG_SLOWDOWN)) {
            float f1 = switch (player.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            f *= f1;
        }
        if (this.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value())) {
            f /= 5.0f;
        }
        f = EventHooks.getBreakSpeed((Player)player, (BlockState)state, (float)f, (BlockPos)pos);
        return f;
    }

    public void spark() {
        this.playSound(QuarkSounds.ENTITY_PICKARANG_SPARK, 1.0f, 1.0f);
        this.setReturning();
    }

    public void clank(HitResult hit) {
        if (hit instanceof BlockHitResult) {
            BlockHitResult bh = (BlockHitResult)hit;
            BlockState state = this.level().getBlockState(bh.getBlockPos());
            Vec3 hitPos = bh.getLocation();
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), hitPos.x, hitPos.y, hitPos.z, 2, 0.0, 0.0, 0.0, 0.0);
        }
        this.playSound(QuarkSounds.ENTITY_PICKARANG_CLANK, 1.0f, 1.0f);
        this.setReturning();
    }

    public void addHit(Entity entity) {
        if (this.entitiesHit == null) {
            this.entitiesHit = new IntOpenHashSet(5);
        }
        this.entitiesHit.add(entity.getId());
        this.postHit();
    }

    public void postHit() {
        if ((this.entitiesHit == null ? 0 : this.entitiesHit.size()) + this.blockHitCount > this.getPiercingModifier()) {
            this.setReturning();
        } else if (this.getPiercingModifier() > 0) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.8));
        }
    }

    public void addHit() {
        ++this.blockHitCount;
        this.postHit();
    }

    protected void setReturning() {
        this.entityData.set(RETURNING, (Object)true);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void tick() {
        float drag;
        Vec3 pos = this.position();
        this.xOld = pos.x;
        this.yOld = pos.y;
        this.zOld = pos.z;
        super.tick();
        if (!this.isReturning()) {
            this.checkImpact();
        }
        Vec3 ourMotion = this.getDeltaMovement();
        this.setPos(pos.x + ourMotion.x, pos.y + ourMotion.y, pos.z + ourMotion.z);
        float f = (float)ourMotion.horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)ourMotion.x, (double)ourMotion.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)ourMotion.y, (double)f) * 57.2957763671875));
        while (this.getXRot() - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.getXRot() - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.getYRot() - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.getYRot() - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        this.setXRot(Mth.lerp((float)0.2f, (float)this.xRotO, (float)this.getXRot()));
        this.setYRot(Mth.lerp((float)0.2f, (float)this.yRotO, (float)this.getYRot()));
        Level level = this.level();
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, pos.x - ourMotion.x * 0.25, pos.y - ourMotion.y * 0.25, pos.z - ourMotion.z * 0.25, ourMotion.x, ourMotion.y, ourMotion.z);
            }
            drag = 0.8f;
        } else {
            drag = 0.99f;
        }
        if (this.hasDrag()) {
            this.setDeltaMovement(ourMotion.scale((double)drag));
        }
        pos = this.position();
        this.setPos(pos.x, pos.y, pos.z);
        if (!this.isAlive()) {
            return;
        }
        ItemStack stack = this.getStack();
        this.emitParticles(pos, ourMotion);
        boolean returning = this.isReturning();
        ++this.liveTime;
        Entity owner = this.getOwner();
        if (owner == null || !owner.isAlive() || !(owner instanceof Player)) {
            if (!level.isClientSide) {
                while (this.isInWall()) {
                    this.setPos(this.getX(), this.getY() + 1.0, this.getZ());
                }
                this.spawnAtLocation(stack, 0.0f);
                this.discard();
            }
            return;
        }
        if (!returning) {
            if (this.liveTime > this.getPickarangType().timeout) {
                this.setReturning();
            }
            if (!level.getWorldBorder().isWithinBounds(this.getBoundingBox())) {
                this.spark();
            }
        } else {
            this.noPhysics = true;
            int eff = this.getEfficiencyModifier();
            List items = level.getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(2.0));
            List xp = level.getEntitiesOfClass(ExperienceOrb.class, this.getBoundingBox().inflate(2.0));
            Vec3 ourPos = this.position();
            for (ItemEntity item : items) {
                if (item.isPassenger()) continue;
                item.startRiding((Entity)this);
                item.setPickUpDelay(5);
            }
            for (ExperienceOrb xpOrb : xp) {
                if (xpOrb.isPassenger()) continue;
                xpOrb.startRiding((Entity)this);
            }
            Vec3 ownerPos = owner.position().add(0.0, 1.0, 0.0);
            Vec3 motion = ownerPos.subtract(ourPos);
            double motionMag = 3.25 + (double)eff * 0.25;
            if (motion.lengthSqr() < motionMag) {
                Player player = (Player)owner;
                Inventory inventory = player.getInventory();
                ItemStack stackInSlot = inventory.getItem(this.slot);
                if (!level.isClientSide) {
                    this.playSound(QuarkSounds.ENTITY_PICKARANG_PICKUP, 1.0f, 1.0f);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)player;
                        if (this instanceof Flamerang && this.isOnFire() && !this.getPassengers().isEmpty()) {
                            PickarangModule.useFlamerangTrigger.trigger(sp);
                        }
                    }
                    if (!stack.isEmpty()) {
                        if (player.isAlive() && stackInSlot.isEmpty()) {
                            inventory.setItem(this.slot, stack);
                        } else if (!player.isAlive() || !inventory.add(stack)) {
                            player.drop(stack, false);
                        }
                    }
                    if (player.isAlive()) {
                        for (ItemEntity item : items) {
                            if (!item.isAlive()) continue;
                            this.giveItemToPlayer(player, item);
                        }
                        for (ExperienceOrb xpOrb : xp) {
                            if (!xpOrb.isAlive()) continue;
                            xpOrb.playerTouch(player);
                        }
                        for (Entity riding : this.getPassengers()) {
                            if (!riding.isAlive()) continue;
                            if (riding instanceof ItemEntity) {
                                this.giveItemToPlayer(player, (ItemEntity)riding);
                                continue;
                            }
                            if (!(riding instanceof ExperienceOrb)) continue;
                            riding.playerTouch(player);
                        }
                    }
                    this.discard();
                }
            } else {
                this.setDeltaMovement(motion.normalize().scale(0.7 + (double)((float)eff * 0.325f)));
            }
        }
    }

    public boolean isReturning() {
        return (Boolean)this.entityData.get(RETURNING);
    }

    protected void emitParticles(Vec3 pos, Vec3 ourMotion) {
    }

    public boolean hasDrag() {
        return true;
    }

    public abstract PickarangType<T> getPickarangType();

    private void giveItemToPlayer(Player player, ItemEntity itemEntity) {
        itemEntity.setPickUpDelay(0);
        itemEntity.playerTouch(player);
        if (itemEntity.isAlive()) {
            ItemStack drop = itemEntity.getItem();
            player.drop(drop, false);
            itemEntity.discard();
        }
    }

    protected boolean canAddPassenger(@NotNull Entity passenger) {
        return super.canAddPassenger(passenger) || passenger instanceof ItemEntity || passenger instanceof ExperienceOrb;
    }

    @NotNull
    public SoundSource getSoundSource() {
        return SoundSource.PLAYERS;
    }

    public int getEfficiencyModifier() {
        Holder.Reference holder = this.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.EFFICIENCY);
        return Quark.ZETA.itemExtensions.get(this.getStack()).getEnchantmentLevelZeta(this.getStack(), (Holder)holder);
    }

    public int getPiercingModifier() {
        Holder.Reference holder = this.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.PIERCING);
        return Quark.ZETA.itemExtensions.get(this.getStack()).getEnchantmentLevelZeta(this.getStack(), (Holder)holder);
    }

    public ItemStack getStack() {
        return (ItemStack)this.entityData.get(STACK);
    }

    public void setStack(ItemStack stack) {
        this.entityData.set(STACK, (Object)stack);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Tag owner;
        this.entityData.set(RETURNING, (Object)compound.getBoolean(TAG_RETURNING));
        this.liveTime = compound.getInt(TAG_LIVE_TIME);
        this.blockHitCount = compound.getInt(TAG_BLOCKS_BROKEN);
        this.slot = compound.getInt(TAG_RETURN_SLOT);
        if (compound.contains(TAG_ITEM_STACK)) {
            this.setStack(ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)compound.getCompound(TAG_ITEM_STACK)));
        } else {
            this.setStack(new ItemStack((ItemLike)PickarangModule.pickarang));
        }
        if (compound.contains("owner", 10) && (owner = compound.get("owner")) != null) {
            this.ownerId = NbtUtils.loadUUID((Tag)owner);
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        compound.putBoolean(TAG_RETURNING, this.isReturning());
        compound.putInt(TAG_LIVE_TIME, this.liveTime);
        compound.putInt(TAG_BLOCKS_BROKEN, this.blockHitCount);
        compound.putInt(TAG_RETURN_SLOT, this.slot);
        compound.put(TAG_ITEM_STACK, this.getStack().save((HolderLookup.Provider)this.level().registryAccess()));
        if (this.ownerId != null) {
            compound.put("owner", (Tag)NbtUtils.createUUID((UUID)this.ownerId));
        }
    }
}

