/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.violetmoon.quark.base.proxy.ClientProxy;
import org.violetmoon.quark.base.proxy.CommonProxy;
import org.violetmoon.quark.integration.lootr.ILootrIntegration;
import org.violetmoon.quark.integration.lootr.LootrIntegration;
import org.violetmoon.quark.integration.terrablender.AbstractUndergroundBiomeHandler;
import org.violetmoon.quark.integration.terrablender.TerrablenderUndergroundBiomeHandler;
import org.violetmoon.quark.integration.terrablender.VanillaUndergroundBiomeHandler;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.multiloader.Env;
import org.violetmoon.zetaimplforge.ForgeZeta;

@Mod(value="quark")
public class Quark {
    public static final String MOD_ID = "quark";
    public static final Logger LOG = LogManager.getLogger((String)"quark");
    public static final Zeta ZETA = new ForgeZeta("quark", LogManager.getLogger((String)"quark-zeta"));
    public static final String ODDITIES_ID = Quark.ZETA.isProduction ? "quarkoddities" : "quarkoddities";
    public static Quark instance;
    public static CommonProxy proxy;
    public static final ILootrIntegration LOOTR_INTEGRATION;
    public static final AbstractUndergroundBiomeHandler TERRABLENDER_INTEGRATION;

    public Quark(IEventBus bus) {
        instance = this;
        ZETA.start();
        proxy = (CommonProxy)Env.unsafeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        proxy.start();
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static <T> ResourceKey<T> asResourceKey(ResourceKey<? extends Registry<T>> base, String name) {
        return ResourceKey.create(base, (ResourceLocation)Quark.asResource(name));
    }

    public static <T> TagKey<T> asTagKey(ResourceKey<? extends Registry<T>> base, String name) {
        return TagKey.create(base, (ResourceLocation)Quark.asResource(name));
    }

    static {
        LOOTR_INTEGRATION = (ILootrIntegration)ZETA.modIntegration("lootr", () -> LootrIntegration::new, () -> ILootrIntegration.Dummy::new);
        TERRABLENDER_INTEGRATION = (AbstractUndergroundBiomeHandler)ZETA.modIntegration("terrablender", () -> TerrablenderUndergroundBiomeHandler::new, () -> VanillaUndergroundBiomeHandler::new);
    }
}

