/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.mixin.mixins;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.violetmoon.quark.content.client.hax.PseudoAccessorItemStack;
import org.violetmoon.quark.content.client.resources.AttributeSlot;
import org.violetmoon.quark.content.tools.module.AncientTomesModule;

@Mixin(value={ItemStack.class})
public class ItemStackMixin
implements PseudoAccessorItemStack {
    @Unique
    private Map<AttributeSlot, Multimap<Attribute, AttributeModifier>> capturedAttributes = new HashMap<AttributeSlot, Multimap<Attribute, AttributeModifier>>();

    @ModifyReturnValue(method={"getRarity"}, at={@At(value="RETURN")})
    private Rarity getRarity(Rarity prev) {
        return AncientTomesModule.shiftRarity((ItemStack)this, prev);
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="RETURN")})
    private void removeTagIfBaked(Item.TooltipContext context, Player p_41652_, TooltipFlag p_41653_, CallbackInfoReturnable<List<Component>> cir, @Share(value="removedEnchantments") LocalBooleanRef ref) {
        ItemStack self = (ItemStack)this;
    }

    @Override
    public Map<AttributeSlot, Multimap<Attribute, AttributeModifier>> quark$getCapturedAttributes() {
        return this.capturedAttributes;
    }

    @Override
    public void quark$capturePotionAttributes(List<Pair<Attribute, AttributeModifier>> attributes) {
        LinkedHashMultimap attributeContainer = LinkedHashMultimap.create();
        for (Pair<Attribute, AttributeModifier> pair : attributes) {
            attributeContainer.put((Object)((Attribute)pair.getFirst()), (Object)((AttributeModifier)pair.getSecond()));
        }
        this.capturedAttributes.put(AttributeSlot.POTION, (Multimap<Attribute, AttributeModifier>)attributeContainer);
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="HEAD")})
    private void clearCapturedTooltip(Item.TooltipContext context, Player player, TooltipFlag flag, CallbackInfoReturnable<List<Component>> cir) {
        this.capturedAttributes = new HashMap<AttributeSlot, Multimap<Attribute, AttributeModifier>>();
    }
}

