/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.experimental.module;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.client.handler.ClientUtil;
import org.violetmoon.quark.base.network.message.experimental.PlaceVariantRestoreMessage;
import org.violetmoon.quark.base.network.message.experimental.PlaceVariantUpdateMessage;
import org.violetmoon.quark.content.experimental.client.screen.VariantSelectorScreen;
import org.violetmoon.quark.content.experimental.client.tooltip.VariantsComponent;
import org.violetmoon.quark.content.experimental.config.VariantsConfig;
import org.violetmoon.quark.content.experimental.item.HammerItem;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorBlockItem;
import org.violetmoon.zeta.client.event.load.ZKeyMapping;
import org.violetmoon.zeta.client.event.load.ZTooltipComponents;
import org.violetmoon.zeta.client.event.play.ZInput;
import org.violetmoon.zeta.client.event.play.ZRenderGuiOverlay;
import org.violetmoon.zeta.client.event.play.ZRenderTooltip;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.ZEntityJoinLevel;
import org.violetmoon.zeta.event.play.entity.player.ZPlayer;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="experimental", enabledByDefault=false, description="Allows placing variant blocks automatically via a selector menu triggered from a keybind")
public class VariantSelectorModule
extends ZetaModule {
    private static final String TAG_CURRENT_VARIANT = "quark:CurrentSelectedVariant";
    @NotNull
    private static String clientVariant = "";
    private static boolean staticEnabled;
    @Config(description="Set this to true to automatically convert any dropped variant items into their originals. Do this ONLY if you intend to take control of every recipe via a data pack or equivalent, as this will introduce dupes otherwise.")
    public static boolean convertVariantItems;
    @Config(flag="hammer", description="Enable the hammer, allowing variants to be swapped between eachother, including the original block. Do this ONLY under the same circumstances as Convert Variant Items.")
    public static boolean enableHammer;
    @Config
    public static boolean showTooltip;
    @Config
    public static boolean alignHudToHotbar;
    @Config
    public static boolean showSimpleHud;
    @Config
    public static boolean showHud;
    @Config
    public static boolean enableGreenTint;
    @Config
    public static boolean overrideHeldItemRender;
    @Config
    public static int hudOffsetX;
    @Config
    public static int hudOffsetY;
    @Config(description="When true, selector arrow will render in same style as crosshair")
    public static boolean renderLikeCrossHair;
    @Config(description="Uses smaller arrow icon for variant selector overlay")
    public static boolean smallerArrow;
    @Config
    public static VariantsConfig variants;
    public static Item hammer;

    @LoadEvent
    public final void register(ZRegister event) {
        hammer = new HammerItem(this).setCondition(() -> enableHammer);
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.isEnabled();
    }

    @NotNull
    public static String getSavedVariant(Player player) {
        if (player.level().isClientSide) {
            return clientVariant;
        }
        return player.getPersistentData().getString(TAG_CURRENT_VARIANT);
    }

    public static void setSavedVariant(ServerPlayer player, @NotNull String variant) {
        if (variant.isEmpty() || variants.isKnownVariant(variant)) {
            player.getPersistentData().putString(TAG_CURRENT_VARIANT, variant);
        }
    }

    @Nullable
    private static Block getMainHandVariantBlock(Player player, String variant) {
        ItemStack mainHand = player.getMainHandItem();
        Item item = mainHand.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            return VariantSelectorModule.getVariantBlockFromOriginal(block, variant);
        }
        return null;
    }

    @Nullable
    public static Block getVariantBlockFromOriginal(Block original, @NotNull String variant) {
        return variants.getBlockOfVariant(original, variant);
    }

    @Nullable
    public static Block getVariantBlockFromAny(Block block, @NotNull String variant) {
        Block variantBlock;
        Block originalBlock = variants.getOriginalBlock(block);
        Block block2 = variantBlock = variant.isEmpty() ? originalBlock : VariantSelectorModule.getVariantBlockFromOriginal(originalBlock, variant);
        if (variantBlock != block) {
            return variantBlock;
        }
        return null;
    }

    @PlayEvent
    public void onPlayerJoin(ZPlayer.LoggedIn event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            String variant = VariantSelectorModule.getSavedVariant((Player)player2);
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlaceVariantRestoreMessage(variant), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @PlayEvent
    public void addEntityToWorld(ZEntityJoinLevel event) {
        BlockItem bi;
        Block block;
        Block otherBlock;
        ItemEntity ie;
        ItemStack stack;
        Item item;
        Entity entity = event.getEntity();
        if (convertVariantItems && entity instanceof ItemEntity && (item = (stack = (ie = (ItemEntity)entity).getItem()).getItem()) instanceof BlockItem && (otherBlock = variants.getOriginalBlock(block = (bi = (BlockItem)item).getBlock())) != block) {
            ItemStack clone = new ItemStack((ItemLike)otherBlock.asItem());
            ie.setItem(clone);
        }
    }

    public static BlockState modifyBlockPlacementState(BlockState state, BlockPlaceContext ctx) {
        Item item;
        Block target;
        String variant;
        if (!staticEnabled || state == null) {
            return state;
        }
        Player player = ctx.getPlayer();
        if (player != null && !(variant = VariantSelectorModule.getSavedVariant(player)).isEmpty() && (target = VariantSelectorModule.getVariantBlockFromOriginal(state.getBlock(), variant)) != null && (item = target.asItem()) instanceof AccessorBlockItem) {
            AccessorBlockItem accessor = (AccessorBlockItem)item;
            return accessor.quark$getPlacementState(ctx);
        }
        return state;
    }

    static {
        convertVariantItems = false;
        enableHammer = false;
        showTooltip = true;
        alignHudToHotbar = false;
        showSimpleHud = false;
        showHud = true;
        enableGreenTint = true;
        overrideHeldItemRender = true;
        hudOffsetX = 0;
        hudOffsetY = 0;
        renderLikeCrossHair = true;
        smallerArrow = false;
        variants = new VariantsConfig();
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends VariantSelectorModule {
        private static KeyMapping variantSelectorKey;

        public static ItemStack modifyHeldItemStack(AbstractClientPlayer player, ItemStack stack) {
            Item item;
            if (!staticEnabled || !overrideHeldItemRender) {
                return stack;
            }
            Minecraft mc = Minecraft.getInstance();
            if (player == mc.player && (item = stack.getItem()) instanceof BlockItem) {
                Block variant;
                BlockItem bi = (BlockItem)item;
                Block block = bi.getBlock();
                if (!clientVariant.isEmpty() && (variant = variants.getBlockOfVariant(block, clientVariant)) != null && variant != block) {
                    return new ItemStack((ItemLike)variant);
                }
            }
            return stack;
        }

        @LoadEvent
        public void registerKeybinds(ZKeyMapping event) {
            variantSelectorKey = event.init("quark.keybind.variant_selector", "r", "quark.gui.keygroup.misc");
        }

        public static void setClientVariant(String variant, boolean sync) {
            if (sync && !Objects.equals(clientVariant, variant)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PlaceVariantUpdateMessage(variant), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            clientVariant = variant;
        }

        public static ItemStack onPickBlock(Player player, ItemStack pickResult) {
            if (!staticEnabled) {
                return null;
            }
            Item item = pickResult.getItem();
            if (item instanceof BlockItem) {
                ItemStack baseItem;
                String variantKey;
                BlockItem pickedVariant = (BlockItem)item;
                Block pickedBlock = pickedVariant.getBlock();
                Block baseBlock = null;
                ItemStack mainHand = player.getMainHandItem();
                Item item2 = mainHand.getItem();
                if (item2 instanceof BlockItem) {
                    BlockItem handItem = (BlockItem)item2;
                    baseBlock = handItem.getBlock();
                } else if (mainHand.is(hammer)) {
                    baseBlock = variants.getOriginalBlock(pickedBlock);
                }
                if (baseBlock != pickedBlock && (variantKey = variants.getVariantOfBlock(baseBlock, pickedBlock)) != null) {
                    Client.setClientVariant(variantKey, true);
                    return pickResult;
                }
                baseBlock = variants.getOriginalBlock(pickedBlock);
                if (baseBlock != pickedBlock && !(baseItem = new ItemStack((ItemLike)baseBlock)).isEmpty() && player.getInventory().hasAnyMatching(i -> i.is(baseItem.getItem()))) {
                    String variantKey2 = variants.getVariantOfBlock(baseBlock, pickedBlock);
                    if (variantKey2 != null) {
                        Client.setClientVariant(variantKey2, true);
                    }
                    return baseItem;
                }
            }
            return null;
        }

        @PlayEvent
        public void keystroke(ZInput.Key event) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null && event.getAction() == 1 && variantSelectorKey.isDown()) {
                Item item;
                ItemStack stack = mc.player.getMainHandItem();
                Block originalBlock = null;
                if (stack.is(hammer)) {
                    originalBlock = variants.getOriginalBlock(this.getLookedAtBlock());
                } else if (!stack.isEmpty() && (item = stack.getItem()) instanceof BlockItem) {
                    BlockItem bi = (BlockItem)item;
                    originalBlock = bi.getBlock();
                }
                if (originalBlock != null && variants.hasVariants(originalBlock)) {
                    mc.setScreen((Screen)new VariantSelectorScreen(originalBlock, variantSelectorKey, clientVariant, variants.getVisibleVariants()));
                }
            }
        }

        private Block getLookedAtBlock() {
            Minecraft mc = Minecraft.getInstance();
            HitResult result = mc.hitResult;
            if (result instanceof BlockHitResult) {
                BlockHitResult bhr = (BlockHitResult)result;
                BlockPos pos = bhr.getBlockPos();
                Block block = mc.player.level().getBlockState(pos).getBlock();
                return block;
            }
            return null;
        }

        @LoadEvent
        public void registerClientTooltipComponentFactories(ZTooltipComponents event) {
            event.register(VariantsComponent.class);
        }

        @PlayEvent
        public void gatherComponents(ZRenderTooltip.GatherComponents event) {
            if (!showTooltip) {
                return;
            }
            ItemStack stack = event.getItemStack();
            if (this.hasTooltip(stack)) {
                List elements = event.getTooltipElements();
                int index = 1;
                if (Screen.hasShiftDown()) {
                    elements.add(index, Either.left((Object)Component.translatable((String)"quark.misc.variant_tooltip_header").withStyle(ChatFormatting.GRAY)));
                    elements.add(index + 1, Either.right((Object)new VariantsComponent(stack)));
                } else {
                    elements.add(index, Either.left((Object)Component.translatable((String)"quark.misc.variant_tooltip_hold_shift").withStyle(ChatFormatting.GRAY)));
                }
            }
        }

        private boolean hasTooltip(ItemStack stack) {
            BlockItem bi;
            Item item;
            return !stack.isEmpty() && (item = stack.getItem()) instanceof BlockItem && variants.hasVariants((bi = (BlockItem)item).getBlock());
        }

        @PlayEvent
        public void onRender(ZRenderGuiOverlay.Crosshair.Pre event) {
            GuiGraphics guiGraphics = event.getGuiGraphics();
            Minecraft mc = Minecraft.getInstance();
            if (mc.screen instanceof VariantSelectorScreen || !showHud) {
                return;
            }
            LocalPlayer player = mc.player;
            String savedVariant = Client.getSavedVariant((Player)player);
            ItemStack mainHand = player.getMainHandItem();
            ItemStack displayLeft = mainHand.copy();
            Block variantBlock = null;
            if (displayLeft.is(hammer)) {
                HitResult result = mc.hitResult;
                if (result instanceof BlockHitResult) {
                    BlockHitResult bhr = (BlockHitResult)result;
                    BlockPos pos = bhr.getBlockPos();
                    Block testBlock = player.level().getBlockState(pos).getBlock();
                    displayLeft = new ItemStack((ItemLike)testBlock);
                    variantBlock = Client.getVariantBlockFromAny(testBlock, savedVariant);
                }
            } else {
                variantBlock = VariantSelectorModule.getMainHandVariantBlock((Player)player, savedVariant);
            }
            if (variantBlock != null) {
                ItemStack displayRight = new ItemStack((ItemLike)variantBlock);
                if (displayLeft.getItem() == displayRight.getItem()) {
                    return;
                }
                Window window = event.getWindow();
                int x = window.getGuiScaledWidth() / 2;
                int y = window.getGuiScaledHeight() / 2 + 12;
                if (alignHudToHotbar) {
                    HumanoidArm arm = (HumanoidArm)mc.options.mainHand().get();
                    x = arm == HumanoidArm.RIGHT ? (x += 125) : (x -= 93);
                    y = window.getGuiScaledHeight() - 19;
                }
                int offset = 8;
                int width = smallerArrow ? 13 : 16;
                displayLeft.setCount(1);
                int posX = x - offset - width + hudOffsetX;
                int posY = y + hudOffsetY;
                if (!showSimpleHud) {
                    guiGraphics.renderFakeItem(displayLeft, posX, posY);
                    RenderSystem.enableBlend();
                    if (renderLikeCrossHair) {
                        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    } else {
                        RenderSystem.defaultBlendFunc();
                        RenderSystem.setShaderColor((float)0.8f, (float)0.8f, (float)0.8f, (float)0.7f);
                    }
                    if (smallerArrow) {
                        guiGraphics.blit(ClientUtil.GENERAL_ICONS, posX + 8, posY + 5, 0.0f, 158.0f, 22, 15, 256, 256);
                    } else {
                        guiGraphics.blit(ClientUtil.GENERAL_ICONS, posX + 8, posY, 0.0f, 141.0f, 22, 15, 256, 256);
                    }
                    RenderSystem.defaultBlendFunc();
                    posX += width * 2;
                } else {
                    ResourceLocation WIDGETS_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/gui/widget.png");
                    if (alignHudToHotbar) {
                        RenderSystem.enableBlend();
                        RenderSystem.blendFunc((int)770, (int)771);
                        if (enableGreenTint) {
                            RenderSystem.setShaderColor((float)0.5f, (float)1.0f, (float)0.5f, (float)1.0f);
                        } else {
                            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        }
                        guiGraphics.blit(WIDGETS_LOCATION, posX - 3, posY - 3, 24.0f, 23.0f, 22, 22, 256, 256);
                    } else {
                        posX += width;
                    }
                }
                guiGraphics.renderFakeItem(displayRight, posX, posY);
            }
        }
    }
}

