/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.violetmoon.quark.api.IRotationLockable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.base.client.handler.ClientUtil;
import org.violetmoon.quark.base.network.message.SetLockProfileMessage;
import org.violetmoon.quark.content.building.block.QuarkVerticalSlabBlock;
import org.violetmoon.quark.content.building.block.VerticalSlabBlock;
import org.violetmoon.zeta.client.event.load.ZKeyMapping;
import org.violetmoon.zeta.client.event.play.ZInput;
import org.violetmoon.zeta.client.event.play.ZRenderGuiOverlay;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.play.entity.player.ZPlayer;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.network.IZetaMessage;

@ZetaLoadModule(category="tweaks")
public class LockRotationModule
extends ZetaModule {
    private static final String TAG_LOCKED_ONCE = "quark:locked_once";
    private static final HashMap<UUID, LockProfile> lockProfiles = new HashMap();
    @Config(description="When true, lock rotation indicator in the same style as crosshair")
    public static boolean renderLikeCrossHair = true;

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        lockProfiles.clear();
    }

    public static BlockState fixBlockRotation(BlockState state, BlockPlaceContext ctx) {
        if (state == null || ctx.m_43723_() == null || !Quark.ZETA.modules.isEnabled(LockRotationModule.class)) {
            return state;
        }
        UUID uuid = ctx.m_43723_().m_20148_();
        if (lockProfiles.containsKey(uuid)) {
            LockProfile profile = lockProfiles.get(uuid);
            BlockState transformed = LockRotationModule.getRotatedState(ctx.m_43725_(), ctx.m_8083_(), state, profile.facing.m_122424_(), profile.half);
            if (!transformed.equals(state)) {
                return Block.m_49931_((BlockState)transformed, (LevelAccessor)ctx.m_43725_(), (BlockPos)ctx.m_8083_());
            }
        }
        return state;
    }

    public static BlockState getRotatedState(Level world, BlockPos pos, BlockState state, Direction face, int half) {
        BlockState setState = state;
        ImmutableMap props = state.m_61148_();
        Block block = state.m_60734_();
        if (block instanceof IRotationLockable) {
            IRotationLockable lockable = (IRotationLockable)block;
            setState = lockable.applyRotationLock(world, pos, state, face, half);
        } else if (props.containsKey((Object)BlockStateProperties.f_61372_)) {
            setState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)face);
        } else if (props.containsKey((Object)QuarkVerticalSlabBlock.TYPE) && props.get((Object)QuarkVerticalSlabBlock.TYPE) != VerticalSlabBlock.VerticalSlabType.DOUBLE && face.m_122434_() != Direction.Axis.Y) {
            setState = (BlockState)state.m_61124_((Property)QuarkVerticalSlabBlock.TYPE, (Comparable)((Object)Objects.requireNonNull(VerticalSlabBlock.VerticalSlabType.fromDirection(face))));
        } else if (props.containsKey((Object)BlockStateProperties.f_61374_) && face.m_122434_() != Direction.Axis.Y) {
            setState = block instanceof StairBlock ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)face.m_122424_()) : (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)face);
        } else if (props.containsKey((Object)BlockStateProperties.f_61365_)) {
            setState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)face.m_122434_());
        } else if (props.containsKey((Object)BlockStateProperties.f_61373_)) {
            setState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61373_, (Comparable)(face == Direction.DOWN ? face : face.m_122424_()));
        }
        if (half != -1) {
            if (props.containsKey((Object)BlockStateProperties.f_61397_) && props.get((Object)BlockStateProperties.f_61397_) != SlabType.DOUBLE) {
                setState = (BlockState)setState.m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)(half == 1 ? SlabType.TOP : SlabType.BOTTOM));
            } else if (props.containsKey((Object)BlockStateProperties.f_61402_)) {
                setState = (BlockState)setState.m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)(half == 1 ? Half.TOP : Half.BOTTOM));
            }
        }
        return setState;
    }

    @PlayEvent
    public void onPlayerLogoff(ZPlayer.LoggedOut event) {
        lockProfiles.remove(event.getEntity().m_20148_());
    }

    public static void setProfile(Player player, LockProfile profile) {
        UUID uuid = player.m_20148_();
        if (profile == null) {
            lockProfiles.remove(uuid);
        } else {
            boolean locked = player.getPersistentData().m_128471_(TAG_LOCKED_ONCE);
            if (!locked) {
                MutableComponent keybind = Component.m_237117_((String)"quark.keybind.lock_rotation").m_130940_(ChatFormatting.AQUA);
                MutableComponent text = Component.m_237110_((String)"quark.misc.rotation_lock", (Object[])new Object[]{keybind});
                player.m_213846_((Component)text);
                player.getPersistentData().m_128379_(TAG_LOCKED_ONCE, true);
            }
            lockProfiles.put(uuid, profile);
        }
    }

    @PlayEvent
    public void respawn(ZPlayer.Clone event) {
        if (event.getOriginal().getPersistentData().m_128471_(TAG_LOCKED_ONCE)) {
            event.getEntity().getPersistentData().m_128379_(TAG_LOCKED_ONCE, true);
        }
    }

    public record LockProfile(Direction facing, int half) {
        public static LockProfile readProfile(FriendlyByteBuf buf, Field field) {
            boolean valid = buf.readBoolean();
            if (!valid) {
                return null;
            }
            int face = buf.readInt();
            int half = buf.readInt();
            return new LockProfile(Direction.m_122376_((int)face), half);
        }

        public static void writeProfile(FriendlyByteBuf buf, Field field, LockProfile p) {
            if (p == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.writeInt(p.facing.m_122411_());
                buf.writeInt(p.half);
            }
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof LockProfile)) {
                return false;
            }
            LockProfile otherProfile = (LockProfile)other;
            return otherProfile.facing == this.facing && otherProfile.half == this.half;
        }

        @Override
        public int hashCode() {
            return this.facing.hashCode() * 31 + this.half;
        }
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends LockRotationModule {
        private LockProfile clientProfile;
        private KeyMapping keybind;

        @LoadEvent
        public void registerKeybinds(ZKeyMapping event) {
            this.keybind = event.init("quark.keybind.lock_rotation", "k", "quark.gui.keygroup.misc");
        }

        @PlayEvent
        public void onMouseInput(ZInput.MouseButton event) {
            this.acceptInput();
        }

        @PlayEvent
        public void onKeyInput(ZInput.Key event) {
            this.acceptInput();
        }

        /*
         * Unable to fully structure code
         */
        private void acceptInput() {
            block5: {
                mc = Minecraft.m_91087_();
                down = this.keybind.m_90857_();
                if (!mc.m_91302_() || !down || mc.f_91080_ != null) break block5;
                result = mc.f_91077_;
                if (!(result instanceof BlockHitResult)) ** GOTO lbl-1000
                bresult = (BlockHitResult)result;
                if (result.m_6662_() == HitResult.Type.BLOCK) {
                    hitVec = bresult.m_82450_();
                    face = bresult.m_82434_();
                    half = Math.abs((int)((hitVec.f_82480_ - (double)((int)hitVec.f_82480_)) * 2.0));
                    if (face.m_122434_() == Direction.Axis.Y) {
                        half = -1;
                    } else if (hitVec.f_82480_ < 0.0) {
                        half = 1 - half;
                    }
                    newProfile = new LockProfile(face.m_122424_(), half);
                } else lbl-1000:
                // 2 sources

                {
                    look = mc.f_91074_.m_20154_();
                    newProfile = new LockProfile(Direction.m_122372_((float)((float)look.f_82479_), (float)((float)look.f_82480_), (float)((float)look.f_82481_)), -1);
                }
                this.clientProfile = this.clientProfile != null && this.clientProfile.equals(newProfile) != false ? null : newProfile;
                QuarkClient.ZETA_CLIENT.sendToServer((IZetaMessage)new SetLockProfileMessage(this.clientProfile));
            }
        }

        @PlayEvent
        public void onHUDRender(ZRenderGuiOverlay.Crosshair.Post event) {
            if (this.clientProfile != null) {
                GuiGraphics guiGraphics = event.getGuiGraphics();
                RenderSystem.enableBlend();
                if (renderLikeCrossHair) {
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                }
                Window window = event.getWindow();
                int x = window.m_85445_() / 2 + 20;
                int y = window.m_85446_() / 2 - 8;
                guiGraphics.m_280163_(ClientUtil.GENERAL_ICONS, x, y, (float)(this.clientProfile.facing.ordinal() * 16), 65.0f, 16, 16, 256, 256);
                if (this.clientProfile.half > -1) {
                    guiGraphics.m_280163_(ClientUtil.GENERAL_ICONS, x + 16, y, (float)(this.clientProfile.half * 16), 79.0f, 16, 16, 256, 256);
                }
            }
        }
    }
}

