/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.module;

import java.util.ArrayList;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.building.block.StoolBlock;
import org.violetmoon.quark.content.building.client.render.entity.StoolEntityRenderer;
import org.violetmoon.quark.content.building.entity.Stool;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.player.ZRightClickBlock;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.util.MiscUtil;

@ZetaLoadModule(category="building")
public class StoolsModule
extends ZetaModule {
    public static EntityType<Stool> stoolEntity;
    @Hint
    TagKey<Item> stoolsTag;

    @LoadEvent
    public final void register(ZRegister event) {
        ArrayList<StoolBlock> stools = new ArrayList<StoolBlock>();
        CreativeTabManager.daisyChain();
        for (DyeColor dye : MiscUtil.CREATIVE_COLOR_ORDER) {
            stools.add(new StoolBlock(this, dye));
        }
        CreativeTabManager.endDaisyChain();
        CreativeTabManager.daisyChain();
        for (StoolBlock s : stools) {
            s.setCreativeTab(CreativeModeTabs.f_256791_, (ItemLike)Blocks.f_50020_, false);
        }
        CreativeTabManager.endDaisyChain();
        stoolEntity = EntityType.Builder.m_20704_(Stool::new, (MobCategory)MobCategory.MISC).m_20699_(0.375f, 0.5f).m_20702_(3).m_20717_(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false).setCustomClientFactory((spawnEntity, world) -> new Stool(stoolEntity, (Level)world)).m_20712_("stool");
        Quark.ZETA.registry.register(stoolEntity, "stool", Registries.f_256939_);
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        this.stoolsTag = ItemTags.create((ResourceLocation)new ResourceLocation("quark", "stools"));
    }

    @PlayEvent
    public void itemUsed(ZRightClickBlock event) {
        BlockState state;
        Block block;
        if (event.getEntity().m_6144_() && event.getItemStack().m_41720_() instanceof BlockItem && event.getFace() == Direction.UP && (block = (state = event.getLevel().m_8055_(event.getPos())).m_60734_()) instanceof StoolBlock) {
            StoolBlock stool = (StoolBlock)block;
            stool.blockClicked(event.getLevel(), event.getPos());
        }
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends StoolsModule {
        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            EntityRenderers.m_174036_((EntityType)stoolEntity, StoolEntityRenderer::new);
        }
    }
}

