/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.util;

import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class InventoryIIH
implements IItemHandlerModifiable {
    private final IItemHandlerModifiable iih;
    final ItemStack stack;

    public InventoryIIH(ItemStack stack) {
        IItemHandler handler;
        this.stack = stack;
        LazyOptional opt = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
        this.iih = opt.isPresent() ? ((handler = (IItemHandler)opt.orElse(null)) instanceof IItemHandlerModifiable ? (IItemHandlerModifiable)handler : null) : null;
        if (this.iih == null) {
            throw new RuntimeException("Can't load InventoryIIH without a proper IItemHandlerModifiable");
        }
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.iih.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.iih.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.iih.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.iih.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.iih.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.iih.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.iih.isItemValid(slot, stack);
    }
}

