/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.client.render.be;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Calendar;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.block.be.TinyPotatoBlockEntity;
import org.violetmoon.quark.addons.oddities.module.TinyPotatoModule;
import org.violetmoon.quark.addons.oddities.util.TinyPotatoInfo;
import org.violetmoon.quark.content.tools.base.RuneColor;
import org.violetmoon.quark.content.tools.module.ColorRunesModule;
import org.violetmoon.quark.mixin.mixins.client.accessor.AccessorModelManager;

public class TinyPotatoRenderer
implements BlockEntityRenderer<TinyPotatoBlockEntity> {
    public static final String DEFAULT = "default";
    public static final String HALLOWEEN = "halloween";
    public static final String ANGRY = "angry";
    private static final Pattern ESCAPED = Pattern.compile("[^a-z0-9/._-]");
    private final BlockRenderDispatcher blockRenderDispatcher;

    public static boolean isTheSpookDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 10 && calendar.get(5) == 31;
    }

    public TinyPotatoRenderer(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderDispatcher = ctx.m_173584_();
    }

    public static BakedModel getModelFromDisplayName(Component displayName, boolean angry) {
        TinyPotatoInfo info = TinyPotatoInfo.fromComponent(displayName);
        return TinyPotatoRenderer.getModel(info.name(), angry);
    }

    private static BakedModel getModel(String name, boolean angry) {
        ModelManager bmm = Minecraft.m_91087_().m_91304_();
        Map<ResourceLocation, BakedModel> mm = ((AccessorModelManager)bmm).getBakedRegistry();
        BakedModel missing = bmm.m_119409_();
        ResourceLocation location = TinyPotatoRenderer.taterLocation(name);
        BakedModel model = mm.get(location);
        if (model == null) {
            if (TinyPotatoRenderer.isTheSpookDay()) {
                return mm.getOrDefault(TinyPotatoRenderer.taterLocation(HALLOWEEN), missing);
            }
            if (angry) {
                return mm.getOrDefault(TinyPotatoRenderer.taterLocation(ANGRY), missing);
            }
            return mm.getOrDefault(TinyPotatoRenderer.taterLocation(DEFAULT), missing);
        }
        return model;
    }

    private static ResourceLocation taterLocation(String name) {
        return new ResourceLocation("quark", "tiny_potato/" + TinyPotatoRenderer.normalizeName(name));
    }

    private static String normalizeName(String name) {
        return ESCAPED.matcher(name).replaceAll("_");
    }

    public void render(@NotNull TinyPotatoBlockEntity potato, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffers, int light, int overlay) {
        boolean render;
        ms.m_85836_();
        TinyPotatoInfo info = TinyPotatoInfo.fromComponent(potato.name);
        RenderType layer = Sheets.m_110792_();
        BakedModel model = TinyPotatoRenderer.getModel(info.name(), potato.angry);
        ms.m_252880_(0.5f, 0.0f, 0.5f);
        Direction potatoFacing = (Direction)potato.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        float rotY = 0.0f;
        switch (potatoFacing) {
            default: {
                rotY = 180.0f;
                break;
            }
            case NORTH: {
                break;
            }
            case EAST: {
                rotY = 90.0f;
                break;
            }
            case WEST: {
                rotY = 270.0f;
            }
        }
        ms.m_252781_(Axis.f_252392_.m_252977_(rotY));
        float jump = potato.jumpTicks;
        if (jump > 0.0f) {
            jump -= partialTicks;
        }
        float up = (float)Math.abs(Math.sin((double)(jump / 10.0f) * Math.PI)) * 0.2f;
        float rotZ = (float)Math.sin((double)(jump / 10.0f) * Math.PI) * 2.0f;
        float wiggle = (float)Math.sin((double)(jump / 10.0f) * Math.PI) * 0.05f;
        ms.m_252880_(wiggle, up, 0.0f);
        ms.m_252781_(Axis.f_252403_.m_252977_(rotZ));
        boolean bl = render = !info.name().equals("mami") && !info.name().equals("soaryn") && (!info.name().equals("eloraam") || jump == 0.0f);
        if (render) {
            ms.m_85836_();
            ms.m_252880_(-0.5f, 0.0f, -0.5f);
            RuneColor runeColor = info.runeColor();
            if (runeColor != null) {
                ColorRunesModule.setTargetColor(runeColor);
            }
            VertexConsumer buffer = ItemRenderer.m_115211_((MultiBufferSource)buffers, (RenderType)layer, (boolean)true, (boolean)info.enchanted());
            this.renderModel(ms, buffer, light, overlay, model);
            ms.m_85849_();
        }
        ms.m_252880_(0.0f, 1.5f, 0.0f);
        ms.m_85836_();
        ms.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        this.renderItems(potato, potatoFacing, ms, buffers, light, overlay);
        ms.m_85849_();
        ms.m_252781_(Axis.f_252403_.m_252977_(-rotZ));
        ms.m_252781_(Axis.f_252392_.m_252977_(-rotY));
        this.renderName(potato, info.name(), ms, buffers, light);
        ms.m_85849_();
    }

    private void renderName(TinyPotatoBlockEntity potato, String name, PoseStack ms, MultiBufferSource buffers, int light) {
        Minecraft mc = Minecraft.m_91087_();
        HitResult pos = mc.f_91077_;
        if (Minecraft.m_91404_() && !name.isEmpty() && pos != null && pos.m_6662_() == HitResult.Type.BLOCK && potato.m_58899_().equals((Object)((BlockHitResult)pos).m_82425_())) {
            ms.m_85836_();
            ms.m_252880_(0.0f, -0.6f, 0.0f);
            ms.m_252781_(mc.m_91290_().m_253208_());
            float f1 = 0.02666667f;
            ms.m_85841_(-f1, -f1, f1);
            int halfWidth = mc.f_91062_.m_92895_(potato.name.getString()) / 2;
            float opacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int opacityRGB = (int)(opacity * 255.0f) << 24;
            mc.f_91062_.m_272077_(potato.name, (float)(-halfWidth), 0.0f, 0x20FFFFFF, false, ms.m_85850_().m_252922_(), buffers, Font.DisplayMode.SEE_THROUGH, opacityRGB, light);
            mc.f_91062_.m_272077_(potato.name, (float)(-halfWidth), 0.0f, -1, false, ms.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, light);
            if (name.equals("pahimar") || name.equals("soaryn")) {
                ms.m_252880_(0.0f, 14.0f, 0.0f);
                String str = name.equals("pahimar") ? "[WIP]" : "(soon)";
                halfWidth = mc.f_91062_.m_92895_(str) / 2;
                mc.f_91062_.m_271703_(str, (float)(-halfWidth), 0.0f, 0x20FFFFFF, false, ms.m_85850_().m_252922_(), buffers, Font.DisplayMode.SEE_THROUGH, opacityRGB, light);
                mc.f_91062_.m_271703_(str, (float)(-halfWidth), 0.0f, -1, false, ms.m_85850_().m_252922_(), buffers, Font.DisplayMode.SEE_THROUGH, 0, light);
            }
            ms.m_85849_();
        }
    }

    private void renderItems(TinyPotatoBlockEntity potato, Direction facing, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ms.m_85836_();
        ms.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        ms.m_252880_(0.0f, -1.0f, 0.0f);
        float s = 0.2857143f;
        ms.m_85841_(s, s, s);
        for (int i = 0; i < potato.m_6643_(); ++i) {
            ItemStack stack = potato.m_8020_(i);
            if (stack.m_41619_()) continue;
            ms.m_85836_();
            Direction side = Direction.values()[i];
            if (side.m_122434_() != Direction.Axis.Y) {
                float sideAngle = side.m_122435_() - facing.m_122435_();
                side = Direction.m_122364_((double)sideAngle);
            }
            boolean block = stack.m_41720_() instanceof BlockItem;
            boolean mySon = stack.m_41720_() == TinyPotatoModule.tiny_potato.m_5456_();
            switch (side) {
                case UP: {
                    if (mySon) {
                        ms.m_252880_(0.0f, -0.375f, 0.5f);
                    } else if (block) {
                        ms.m_252880_(0.0f, 0.3f, 0.5f);
                    }
                    ms.m_252880_(0.0f, -0.5f, -0.4f);
                    break;
                }
                case DOWN: {
                    ms.m_252880_(0.0f, -2.3f, -0.88f);
                    if (mySon) {
                        ms.m_252880_(0.0f, 1.25f, 0.5f);
                        break;
                    }
                    if (!block) break;
                    ms.m_252880_(0.0f, 1.0f, 0.6f);
                    break;
                }
                case NORTH: {
                    ms.m_252880_(0.0f, -1.9f, 0.02f);
                    if (mySon) {
                        ms.m_252880_(0.0f, -0.29f, 0.6f);
                        break;
                    }
                    if (!block) break;
                    ms.m_252880_(0.0f, 1.0f, 0.6f);
                    break;
                }
                case SOUTH: {
                    ms.m_252880_(0.0f, -1.6f, -0.89f);
                    if (mySon) {
                        ms.m_252880_(0.0f, -0.59f, 0.26f);
                        break;
                    }
                    if (!block) break;
                    ms.m_252880_(0.0f, 1.0f, 0.5f);
                    break;
                }
                case EAST: {
                    if (mySon) {
                        ms.m_252880_(-0.35f, -0.29f, -0.06f);
                    } else if (block) {
                        ms.m_252880_(-0.4f, 0.8f, 0.0f);
                    } else {
                        ms.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                    }
                    ms.m_252880_(-0.3f, -1.9f, 0.04f);
                    break;
                }
                case WEST: {
                    if (mySon) {
                        TinyPotatoInfo info;
                        ms.m_252880_(0.95f, -0.29f, 0.9f);
                        if (stack.m_41788_() && (info = TinyPotatoInfo.fromComponent(stack.m_41786_())).name().equals("kingdaddydmac")) {
                            ms.m_252880_(0.55f, 0.0f, 0.0f);
                        }
                    } else if (block) {
                        ms.m_252880_(1.0f, 0.8f, 1.0f);
                    } else {
                        ms.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                    }
                    ms.m_252880_(-0.3f, -1.9f, -0.92f);
                }
            }
            if (mySon) {
                ms.m_85841_(1.1f, 1.1f, 1.1f);
            } else if (block) {
                ms.m_85841_(0.5f, 0.5f, 0.5f);
            }
            if (block && side == Direction.NORTH) {
                ms.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            }
            this.renderItem(ms, buffers, light, overlay, stack);
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    private void renderModel(PoseStack ms, VertexConsumer buffer, int light, int overlay, BakedModel model) {
        this.blockRenderDispatcher.m_110937_().m_111067_(ms.m_85850_(), buffer, null, model, 1.0f, 1.0f, 1.0f, light, overlay);
    }

    private void renderItem(PoseStack ms, MultiBufferSource buffers, int light, int overlay, ItemStack stack) {
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.HEAD, light, overlay, ms, buffers, (Level)Minecraft.m_91087_().f_91073_, 0);
    }
}

