/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.management.module;

import java.util.function.BooleanSupplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.base.client.handler.InventoryButtonHandler;
import org.violetmoon.quark.base.network.message.SortInventoryMessage;
import org.violetmoon.quark.content.management.client.screen.widgets.MiniInventoryButton;
import org.violetmoon.zeta.client.event.load.ZKeyMapping;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.network.IZetaMessage;

@ZetaLoadModule(category="management")
public class InventorySortingModule
extends ZetaModule {
    @Config
    public static boolean enablePlayerInventory = true;
    @Config
    public static boolean enablePlayerInventoryInChests = true;
    @Config
    public static boolean enableChests = true;
    @Config(description="Play a click when sorting inventories using keybindings")
    public static boolean satisfyingClick = true;

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends InventorySortingModule {
        @LoadEvent
        public void registerKeybinds(ZKeyMapping event) {
            KeyMapping sortPlayer = event.init("quark.keybind.sort_player", null, "quark.gui.keygroup.inv");
            InventoryButtonHandler.addButtonProvider(this, InventoryButtonHandler.ButtonTargetType.PLAYER_INVENTORY, 0, sortPlayer, screen -> {
                if (enablePlayerInventory) {
                    if (satisfyingClick) {
                        this.click();
                    }
                    QuarkClient.ZETA_CLIENT.sendToServer((IZetaMessage)new SortInventoryMessage(true));
                }
            }, this.provider("sort", true, () -> enablePlayerInventory), () -> enablePlayerInventory);
            InventoryButtonHandler.addButtonProvider(this, InventoryButtonHandler.ButtonTargetType.CONTAINER_PLAYER_INVENTORY, 0, sortPlayer, screen -> {
                if (enablePlayerInventoryInChests) {
                    if (satisfyingClick) {
                        this.click();
                    }
                    QuarkClient.ZETA_CLIENT.sendToServer((IZetaMessage)new SortInventoryMessage(true));
                }
            }, this.provider("sort_inventory", true, () -> enablePlayerInventoryInChests), () -> enablePlayerInventoryInChests);
            InventoryButtonHandler.addButtonProvider(event, this, InventoryButtonHandler.ButtonTargetType.CONTAINER_INVENTORY, 0, "quark.keybind.sort_container", screen -> {
                if (enableChests) {
                    if (satisfyingClick) {
                        this.click();
                    }
                    QuarkClient.ZETA_CLIENT.sendToServer((IZetaMessage)new SortInventoryMessage(false));
                }
            }, this.provider("sort_container", false, () -> enableChests), () -> enableChests);
        }

        private InventoryButtonHandler.ButtonProvider provider(String tooltip, boolean forcePlayer, BooleanSupplier condition) {
            return (parent, x, y) -> !condition.getAsBoolean() ? null : new MiniInventoryButton(parent, 0, tooltip.equals("sort_container") ? parent.getXSize() - 18 : x, tooltip.equals("sort_container") ? 5 : y, "quark.gui.button." + tooltip, b -> QuarkClient.ZETA_CLIENT.sendToServer((IZetaMessage)new SortInventoryMessage(forcePlayer)));
        }

        private void click() {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        }
    }
}

