/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.capability;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.module.CrateModule;
import org.violetmoon.quark.base.handler.SortingHandler;

public class CrateItemHandler
extends ItemStackHandler {
    private boolean needsUpdate = false;
    private final int maxItems = CrateModule.maxItems;
    public int displayTotal = 0;
    public int displaySlots = 0;
    private int cachedTotal = -1;

    public CrateItemHandler() {
        super(CrateModule.maxItems);
    }

    private int getTotal() {
        if (this.cachedTotal != -1) {
            return this.cachedTotal;
        }
        int items = 0;
        for (ItemStack stack : this.stacks) {
            items += stack.m_41613_();
        }
        this.cachedTotal = items;
        return items;
    }

    private void changeTotal(ItemStack oldStack, ItemStack newStack) {
        int diff = newStack.m_41613_() - oldStack.m_41613_();
        if (diff != 0) {
            this.changeTotal(diff);
        }
    }

    private void changeTotal(int change) {
        this.cachedTotal = this.getTotal() + change;
    }

    public void recalculate() {
        if (!this.needsUpdate) {
            return;
        }
        this.needsUpdate = false;
        this.displayTotal = 0;
        this.displaySlots = 0;
        NonNullList newStacks = NonNullList.m_122780_((int)this.maxItems, (Object)ItemStack.f_41583_);
        int idx = 0;
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_()) continue;
            newStacks.set(idx, (Object)stack);
            this.displayTotal += stack.m_41613_();
            ++this.displaySlots;
            ++idx;
        }
        this.stacks = newStacks;
        this.cachedTotal = -1;
    }

    public void clear() {
        this.needsUpdate = false;
        this.stacks = NonNullList.m_122780_((int)this.maxItems, (Object)ItemStack.f_41583_);
        this.displayTotal = 0;
        this.displaySlots = 0;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void spill(Level level, BlockPos worldPosition) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>((Collection<ItemStack>)this.stacks);
        SortingHandler.mergeStacks(stacks);
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)level, (double)worldPosition.m_123341_(), (double)worldPosition.m_123342_(), (double)worldPosition.m_123343_(), (ItemStack)stack);
        }
    }

    public int getSlotLimit(int slot) {
        ItemStack stackInSlot = this.getStackInSlot(slot);
        int total = this.getTotal();
        return Mth.m_14045_((int)(stackInSlot.m_41613_() + this.maxItems - total), (int)0, (int)64);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        ItemStack oldStack = ((ItemStack)this.stacks.get(slot)).m_41777_();
        super.setStackInSlot(slot, stack);
        ItemStack newStack = ((ItemStack)this.stacks.get(slot)).m_41777_();
        this.changeTotal(oldStack, newStack);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack oldStack = ((ItemStack)this.stacks.get(slot)).m_41777_();
        ItemStack retStack = super.insertItem(slot, stack, simulate);
        ItemStack newStack = ((ItemStack)this.stacks.get(slot)).m_41777_();
        if (!simulate) {
            this.changeTotal(oldStack, newStack);
        }
        return retStack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack oldStack = ((ItemStack)this.stacks.get(slot)).m_41777_();
        ItemStack retStack = super.extractItem(slot, amount, simulate);
        ItemStack newStack = ((ItemStack)this.stacks.get(slot)).m_41777_();
        if (!simulate) {
            this.changeTotal(oldStack, newStack);
        }
        return retStack;
    }

    public void onContentsChanged(int slot) {
        this.needsUpdate = true;
    }

    protected void onLoad() {
        this.needsUpdate = true;
        this.recalculate();
    }

    public CompoundTag serializeNBT() {
        ListTag items = new ListTag();
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_()) continue;
            items.add((Object)stack.m_41739_(new CompoundTag()));
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("stacks", (Tag)items);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.stacks = NonNullList.m_122780_((int)this.maxItems, (Object)ItemStack.f_41583_);
        ListTag items = nbt.m_128437_("stacks", 10);
        for (int i = 0; i < items.size(); ++i) {
            this.stacks.set(i, (Object)ItemStack.m_41712_((CompoundTag)items.m_128728_(i)));
        }
        this.onLoad();
    }
}

