/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.module;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.api.IQuarkButtonAllowed;
import org.violetmoon.quark.base.client.handler.ClientUtil;
import org.violetmoon.quark.base.client.handler.InventoryButtonHandler;
import org.violetmoon.quark.base.config.QuarkGeneralConfig;
import org.violetmoon.quark.base.config.type.RGBAColorConfig;
import org.violetmoon.quark.base.handler.InventoryTransferHandler;
import org.violetmoon.quark.base.handler.SimilarBlockTypeHandler;
import org.violetmoon.quark.content.management.client.screen.widgets.MiniInventoryButton;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.client.event.play.ZRenderContainerScreen;
import org.violetmoon.zeta.client.event.play.ZScreen;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.ItemNBTHelper;

@ZetaLoadModule(category="client")
public class ChestSearchingModule
extends ZetaModule {
    @Config
    public RGBAColorConfig overlayColor = RGBAColorConfig.forColor(0.0, 0.0, 0.0, 0.67);

    public boolean searchBarShown() {
        return false;
    }

    public boolean namesMatch(ItemStack stack) {
        return false;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends ChestSearchingModule {
        private EditBox searchBar;
        private String text = "";
        public boolean searchEnabled = false;
        private long lastClick;
        private int matched;

        @Override
        public boolean searchBarShown() {
            return this.searchEnabled;
        }

        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            InventoryButtonHandler.addButtonProvider(this, InventoryButtonHandler.ButtonTargetType.CONTAINER_INVENTORY, 1, (parent, x, y) -> new MiniInventoryButton(parent, 3, parent.getXSize() - 30, 5, "quark.gui.button.filter", b -> {
                if (this.searchBar != null) {
                    this.searchEnabled = !this.searchEnabled;
                    this.updateSearchStatus();
                    this.searchBar.m_93692_(true);
                }
            }).setTextureShift(() -> this.searchEnabled), null);
        }

        @PlayEvent
        public void initGui(ZScreen.Init.Post event) {
            Screen gui = event.getScreen();
            boolean apiAllowed = gui instanceof IQuarkButtonAllowed;
            if (!(gui instanceof InventoryScreen) && gui instanceof AbstractContainerScreen) {
                AbstractContainerScreen chest = (AbstractContainerScreen)gui;
                if (apiAllowed || QuarkGeneralConfig.isScreenAllowed(gui)) {
                    Minecraft mc = gui.getMinecraft();
                    if (apiAllowed || InventoryTransferHandler.accepts(chest.m_6262_(), (Player)mc.f_91074_)) {
                        this.searchBar = new EditBox(mc.f_91062_, 18, 6, 117, 10, (Component)Component.m_237113_((String)this.text));
                        this.searchBar.m_94144_(this.text);
                        this.searchBar.m_94199_(50);
                        this.searchBar.m_94182_(false);
                        this.updateSearchStatus();
                        return;
                    }
                }
            }
            this.searchBar = null;
        }

        private void updateSearchStatus() {
            if (this.searchBar != null) {
                this.searchBar.m_94186_(this.searchEnabled);
                this.searchBar.m_94194_(this.searchEnabled);
                if (!this.searchEnabled) {
                    this.searchBar.m_93692_(false);
                }
            }
        }

        @PlayEvent
        public void charTyped(ZScreen.CharacterTyped.Pre event) {
            if (this.searchBar != null && this.searchBar.m_93696_() && this.searchEnabled) {
                this.searchBar.m_5534_(event.getCodePoint(), event.getModifiers());
                this.text = this.searchBar.m_94155_();
                event.setCanceled(true);
            }
        }

        @PlayEvent
        public void onKeypress(ZScreen.KeyPressed.Pre event) {
            if (this.searchBar != null && this.searchBar.m_93696_() && this.searchEnabled) {
                this.searchBar.m_7933_(event.getKeyCode(), event.getScanCode(), event.getModifiers());
                this.text = this.searchBar.m_94155_();
                event.setCanceled(event.getKeyCode() != 256);
            }
        }

        @PlayEvent
        public void onClick(ZScreen.MouseButtonPressed.Pre event) {
            Screen screen;
            if (this.searchBar != null && this.searchEnabled && (screen = event.getScreen()) instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                boolean isMouseOver = this.searchBar.m_5953_(event.getMouseX() - (double)containerScreen.getGuiLeft(), event.getMouseY() - (double)containerScreen.getGuiTop());
                if (event.getButton() == 1 && isMouseOver) {
                    this.searchBar.m_94144_("");
                    this.text = "";
                }
                this.searchBar.m_93692_(isMouseOver);
            }
        }

        @PlayEvent
        public void renderForeground(ZRenderContainerScreen.Foreground event) {
            if (this.searchBar != null && this.searchEnabled) {
                GuiGraphics guiGraphics = event.getGuiGraphics();
                PoseStack matrix = guiGraphics.m_280168_();
                AbstractContainerScreen gui = event.getContainerScreen();
                matrix.m_85836_();
                this.drawBackground(guiGraphics, (Screen)gui, this.searchBar.m_252754_() - 11, this.searchBar.m_252907_() - 3);
                if (!this.text.isEmpty()) {
                    AbstractContainerMenu container = gui.m_6262_();
                    this.matched = 0;
                    for (Slot s : container.f_38839_) {
                        if (!s.m_6659_()) continue;
                        ItemStack stack = s.m_7993_();
                        if (!this.namesMatch(stack, this.text)) {
                            int x = s.f_40220_;
                            int y = s.f_40221_;
                            guiGraphics.m_280509_(x, y, x + 16, y + 16, this.overlayColor.getColor());
                            continue;
                        }
                        ++this.matched;
                    }
                }
                if (this.matched == 0 && !this.text.isEmpty()) {
                    this.searchBar.m_94202_(0xFF5555);
                } else {
                    this.searchBar.m_94202_(0xFFFFFF);
                }
                this.searchBar.m_88315_(guiGraphics, 0, 0, 0.0f);
                matrix.m_85849_();
            }
        }

        private void drawBackground(GuiGraphics guiGraphics, Screen gui, int x, int y) {
            if (gui == null) {
                return;
            }
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280163_(ClientUtil.GENERAL_ICONS, x, y, 0.0f, 0.0f, 126, 13, 256, 256);
        }

        @Override
        public boolean namesMatch(ItemStack stack) {
            return !this.searchEnabled || this.namesMatch(stack, this.text);
        }

        /*
         * WARNING - void declaration
         */
        public boolean namesMatch(ItemStack stack, String search) {
            CompoundTag cmp;
            if ((search = ChatFormatting.m_126649_((String)search.trim().toLowerCase(Locale.ROOT))) == null || search.isEmpty()) {
                return true;
            }
            if (stack.m_41619_()) {
                return false;
            }
            Item item = stack.m_41720_();
            ResourceLocation res = BuiltInRegistries.f_257033_.m_7981_((Object)item);
            if (SimilarBlockTypeHandler.isShulkerBox(res) && (cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)"BlockEntityTag", (boolean)true)) != null) {
                LazyOptional handler;
                BlockEntity te;
                if (!cmp.m_128441_("id")) {
                    cmp = cmp.m_6426_();
                    cmp.m_128359_("id", "minecraft:shulker_box");
                }
                if ((te = BlockEntity.m_155241_((BlockPos)BlockPos.f_121853_, (BlockState)((BlockItem)item).m_40614_().m_49966_(), (CompoundTag)cmp)) != null && (handler = te.getCapability(ForgeCapabilities.ITEM_HANDLER, null)).isPresent()) {
                    void var9_10;
                    IItemHandler items = (IItemHandler)handler.orElseGet(EmptyHandler::new);
                    boolean bl = false;
                    while (var9_10 < items.getSlots()) {
                        if (this.namesMatch(items.getStackInSlot((int)var9_10), search)) {
                            return true;
                        }
                        ++var9_10;
                    }
                }
            }
            String name = stack.m_41786_().getString();
            name = ChatFormatting.m_126649_((String)name.trim().toLowerCase(Locale.ROOT));
            StringMatcher matcher = String::contains;
            if (search.length() >= 3 && search.startsWith("\"") && search.endsWith("\"")) {
                search = search.substring(1, search.length() - 1);
                matcher = String::equals;
            }
            if (search.length() >= 3 && search.startsWith("/") && search.endsWith("/")) {
                search = search.substring(1, search.length() - 1);
                matcher = (s1, s2) -> Pattern.compile(s2).matcher((CharSequence)s1).find();
            }
            if (stack.m_41793_()) {
                Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
                for (Enchantment enchantment : enchants.keySet()) {
                    if (enchantment == null || !matcher.test(enchantment.m_44700_(((Integer)enchants.get(enchantment)).intValue()).toString().toLowerCase(Locale.ROOT), search)) continue;
                    return true;
                }
            }
            ArrayList potionNames = new ArrayList();
            PotionUtils.m_43555_((ItemStack)stack, potionNames, (float)1.0f);
            for (Component component : potionNames) {
                if (!matcher.test(ChatFormatting.m_126649_((String)component.toString().trim().toLowerCase(Locale.ROOT)), search)) continue;
                return true;
            }
            for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
                int lvl = (Integer)entry.getValue();
                Enchantment e = (Enchantment)entry.getKey();
                if (e == null || !matcher.test(e.m_44700_(lvl).toString().toLowerCase(Locale.ROOT), search)) continue;
                return true;
            }
            for (String string : BuiltInRegistries.f_279662_.m_123024_().filter(tab -> tab.m_257694_(stack)).map(tab -> tab.m_40786_().getString().toLowerCase(Locale.ROOT)).toList()) {
                if (!matcher.test(string, search)) continue;
                return true;
            }
            ResourceLocation itemName = BuiltInRegistries.f_257033_.m_7981_((Object)item);
            @Nullable String string = this.zeta.getModDisplayName(itemName.m_135827_());
            if (string != null && matcher.test(string.toLowerCase(Locale.ROOT), search)) {
                return true;
            }
            return matcher.test(name, search);
        }

        private static interface StringMatcher
        extends BiPredicate<String, String> {
        }
    }
}

