/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.handler;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.violetmoon.quark.base.config.QuarkGeneralConfig;

public class SimilarBlockTypeHandler {
    public static List<String> getBasicShulkerBoxes() {
        return ImmutableSet.of((Object)Blocks.f_50457_, (Object)Blocks.f_50458_, (Object)Blocks.f_50459_, (Object)Blocks.f_50460_, (Object)Blocks.f_50461_, (Object)Blocks.f_50462_, (Object[])new Block[]{Blocks.f_50463_, Blocks.f_50464_, Blocks.f_50465_, Blocks.f_50466_, Blocks.f_50520_, Blocks.f_50521_, Blocks.f_50522_, Blocks.f_50523_, Blocks.f_50524_, Blocks.f_50525_}).stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256975_).m_7981_(arg_0)).map(Objects::toString).collect(Collectors.toList());
    }

    public static boolean isShulkerBox(ItemStack stack) {
        return SimilarBlockTypeHandler.isShulkerBox(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_())) && !stack.m_41619_() && stack.m_41741_() == 1;
    }

    public static boolean isShulkerBox(ResourceLocation loc) {
        if (loc == null) {
            return false;
        }
        String locStr = loc.toString();
        if (QuarkGeneralConfig.shulkerBoxes.contains(locStr)) {
            return true;
        }
        return QuarkGeneralConfig.interpretShulkerBoxLikeBlocks && locStr.contains("shulker_box");
    }
}

