/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.integration.jei;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.inventory.BackpackMenu;

public class BackpackRecipeTransferHandler
implements IRecipeTransferHandler<BackpackMenu, RecipeHolder<CraftingRecipe>> {
    private static final IntSet PLAYER_INV_INDEXES = IntArraySet.of((int[])new int[]{0, 1, 3, 4});
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IRecipeTransferHandler<BackpackMenu, RecipeHolder<CraftingRecipe>> handler;

    public BackpackRecipeTransferHandler(IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
        IRecipeTransferInfo basicRecipeTransferInfo = handlerHelper.createBasicRecipeTransferInfo(BackpackMenu.class, null, RecipeTypes.CRAFTING, 1, 4, 9, 36);
        this.handler = handlerHelper.createUnregisteredRecipeTransferHandler(basicRecipeTransferInfo);
    }

    public Class<? extends BackpackMenu> getContainerClass() {
        return this.handler.getContainerClass();
    }

    public Optional<MenuType<BackpackMenu>> getMenuType() {
        return this.handler.getMenuType();
    }

    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(BackpackMenu container, RecipeHolder<CraftingRecipe> recipe, IRecipeSlotsView recipeSlotsView, Player player, boolean maxTransfer, boolean doTransfer) {
        if (!this.handlerHelper.recipeTransferHasServerSupport()) {
            MutableComponent tooltipMessage = Component.translatable((String)"jei.tooltip.error.recipe.transfer.no.server");
            return this.handlerHelper.createUserErrorWithTooltip((Component)tooltipMessage);
        }
        List slotViews = recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT);
        if (!BackpackRecipeTransferHandler.validateIngredientsOutsidePlayerGridAreEmpty(slotViews)) {
            MutableComponent tooltipMessage = Component.translatable((String)"jei.tooltip.error.recipe.transfer.too.large.player.inventory");
            return this.handlerHelper.createUserErrorWithTooltip((Component)tooltipMessage);
        }
        List<IRecipeSlotView> filteredSlotViews = BackpackRecipeTransferHandler.filterSlots(slotViews);
        IRecipeSlotsView filteredRecipeSlots = this.handlerHelper.createRecipeSlotsView(filteredSlotViews);
        return this.handler.transferRecipe((AbstractContainerMenu)container, recipe, filteredRecipeSlots, player, maxTransfer, doTransfer);
    }

    private static boolean validateIngredientsOutsidePlayerGridAreEmpty(List<IRecipeSlotView> slotViews) {
        int bound = slotViews.size();
        for (int i = 0; i < bound; ++i) {
            IRecipeSlotView slotView;
            if (PLAYER_INV_INDEXES.contains(i) || (slotView = slotViews.get(i)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static List<IRecipeSlotView> filterSlots(List<IRecipeSlotView> slotViews) {
        return PLAYER_INV_INDEXES.intStream().mapToObj(slotViews::get).toList();
    }
}

