/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.tools.entity.SkullPike;

public class RunAwayFromPikesGoal
extends Goal {
    protected final PathfinderMob entity;
    private final double farSpeed;
    private final double nearSpeed;
    protected SkullPike avoidTarget;
    protected final float avoidDistance;
    protected Path path;
    protected final PathNavigation navigation;

    public RunAwayFromPikesGoal(PathfinderMob entityIn, float distance, double nearSpeedIn, double farSpeedIn) {
        this.entity = entityIn;
        this.avoidDistance = distance;
        this.farSpeed = nearSpeedIn;
        this.nearSpeed = farSpeedIn;
        this.navigation = entityIn.getNavigation();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        this.avoidTarget = this.getClosestEntity(this.entity.level(), (LivingEntity)this.entity, this.entity.getX(), this.entity.getY(), this.entity.getZ(), this.entity.getBoundingBox().inflate((double)this.avoidDistance, 3.0, (double)this.avoidDistance));
        if (this.avoidTarget == null) {
            return false;
        }
        Vec3 posToMove = DefaultRandomPos.getPosAway((PathfinderMob)this.entity, (int)16, (int)7, (Vec3)this.avoidTarget.position());
        if (posToMove == null) {
            return false;
        }
        if (this.avoidTarget.distanceToSqr(posToMove.x, posToMove.y, posToMove.z) < this.avoidTarget.distanceToSqr((Entity)this.entity)) {
            return false;
        }
        this.path = this.navigation.createPath(posToMove.x, posToMove.y, posToMove.z, 0);
        return this.path != null;
    }

    @Nullable
    private SkullPike getClosestEntity(Level world, LivingEntity living, double x, double y, double z, AABB bounds) {
        return this.getClosestEntity(world.getEntitiesOfClass(SkullPike.class, bounds, skullPike -> true), living, x, y, z);
    }

    @Nullable
    private SkullPike getClosestEntity(List<SkullPike> entities, LivingEntity target, double x, double y, double z) {
        double d0 = -1.0;
        SkullPike t = null;
        for (SkullPike t1 : entities) {
            if (!t1.isVisible((Entity)target)) continue;
            double d1 = t1.distanceToSqr(x, y, z);
            if (d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            t = t1;
        }
        return t;
    }

    public boolean canContinueToUse() {
        return !this.navigation.isDone();
    }

    public void start() {
        this.navigation.moveTo(this.path, this.farSpeed);
    }

    public void stop() {
        this.avoidTarget = null;
    }

    public void tick() {
        if (this.entity.distanceToSqr((Entity)this.avoidTarget) < 49.0) {
            this.entity.getNavigation().setSpeedModifier(this.nearSpeed);
        } else {
            this.entity.getNavigation().setSpeedModifier(this.farSpeed);
        }
    }
}

