/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.handler.SimilarBlockTypeHandler;
import org.violetmoon.quark.content.client.module.ImprovedTooltipsModule;
import org.violetmoon.zeta.client.event.play.ZGatherTooltipComponents;

public class ShulkerBoxTooltips {
    public static final ResourceLocation WIDGET_RESOURCE = Quark.asResource("textures/misc/shulker_widget.png");

    public static void makeTooltip(ZGatherTooltipComponents event) {
        ItemStack stack = event.getItemStack();
        if (SimilarBlockTypeHandler.isShulkerBox(stack)) {
            CompoundTag cmp = ((CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)).copyTag();
            if (cmp.contains("LootTable")) {
                return;
            }
            if (!cmp.contains("id")) {
                return;
            }
            ClientPacketListener listener = Minecraft.getInstance().getConnection();
            BlockEntity te = BlockEntity.loadStatic((BlockPos)BlockPos.ZERO, (BlockState)((BlockItem)stack.getItem()).getBlock().defaultBlockState(), (CompoundTag)cmp, (HolderLookup.Provider)listener.registryAccess());
            if (te != null) {
                List tooltip = event.getTooltipElements();
                ArrayList tooltipCopy = new ArrayList(tooltip);
                for (int i = 1; i < tooltipCopy.size(); ++i) {
                    String s;
                    Either either = (Either)tooltipCopy.get(i);
                    if (!either.left().isPresent() || (s = ((FormattedText)either.left().get()).getString()).startsWith("\u00a7") && !s.startsWith("\u00a7o")) continue;
                    tooltip.remove(either);
                }
                if (!ImprovedTooltipsModule.shulkerBoxRequireShift || Screen.hasShiftDown()) {
                    tooltip.add(1, Either.right((Object)new ShulkerComponent(stack)));
                }
                if (ImprovedTooltipsModule.shulkerBoxRequireShift && !Screen.hasShiftDown()) {
                    tooltip.add(1, Either.left((Object)Component.translatable((String)"quark.misc.shulker_box_shift")));
                }
            }
        }
    }

    public record ShulkerComponent(ItemStack stack) implements ClientTooltipComponent,
    TooltipComponent
    {
        private static final int[][] TARGET_RATIOS = new int[][]{{1, 1}, {9, 3}, {9, 5}, {9, 6}, {9, 8}, {9, 9}, {12, 9}};
        private static final int CORNER = 5;
        private static final int BUFFER = 1;
        private static final int EDGE = 18;

        public void renderImage(@NotNull Font font, int tooltipX, int tooltipY, @NotNull GuiGraphics guiGraphics) {
            Minecraft mc = Minecraft.getInstance();
            PoseStack pose = guiGraphics.pose();
            CompoundTag cmp = ((CustomData)this.stack.get(DataComponents.BLOCK_ENTITY_DATA)).copyTag();
            if (cmp != null) {
                BlockEntity te;
                if (cmp.contains("LootTable")) {
                    return;
                }
                if (!cmp.contains("id")) {
                    cmp = cmp.copy();
                    cmp.putString("id", "minecraft:shulker_box");
                }
                if ((te = BlockEntity.loadStatic((BlockPos)BlockPos.ZERO, (BlockState)((BlockItem)this.stack.getItem()).getBlock().defaultBlockState(), (CompoundTag)cmp, (HolderLookup.Provider)mc.player.registryAccess())) != null && te instanceof RandomizableContainerBlockEntity) {
                    RandomizableContainerBlockEntity randomizable = (RandomizableContainerBlockEntity)te;
                    randomizable.setLootTable(null, 0L);
                }
            }
        }

        public static void renderTooltipBackground(GuiGraphics guiGraphics, Minecraft mc, PoseStack matrix, int x, int y, int width, int height, int color) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)WIDGET_RESOURCE);
            RenderSystem.setShaderColor((float)((float)((color & 0xFF0000) >> 16) / 255.0f), (float)((float)((color & 0xFF00) >> 8) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
            guiGraphics.blit(WIDGET_RESOURCE, x, y, 0.0f, 0.0f, 5, 5, 256, 256);
            guiGraphics.blit(WIDGET_RESOURCE, x + 5 + 18 * width, y + 5 + 18 * height, 25.0f, 25.0f, 5, 5, 256, 256);
            guiGraphics.blit(WIDGET_RESOURCE, x + 5 + 18 * width, y, 25.0f, 0.0f, 5, 5, 256, 256);
            guiGraphics.blit(WIDGET_RESOURCE, x, y + 5 + 18 * height, 0.0f, 25.0f, 5, 5, 256, 256);
            for (int row = 0; row < height; ++row) {
                guiGraphics.blit(WIDGET_RESOURCE, x, y + 5 + 18 * row, 0.0f, 6.0f, 5, 18, 256, 256);
                guiGraphics.blit(WIDGET_RESOURCE, x + 5 + 18 * width, y + 5 + 18 * row, 25.0f, 6.0f, 5, 18, 256, 256);
                for (int col = 0; col < width; ++col) {
                    if (row == 0) {
                        guiGraphics.blit(WIDGET_RESOURCE, x + 5 + 18 * col, y, 6.0f, 0.0f, 18, 5, 256, 256);
                        guiGraphics.blit(WIDGET_RESOURCE, x + 5 + 18 * col, y + 5 + 18 * height, 6.0f, 25.0f, 18, 5, 256, 256);
                    }
                    guiGraphics.blit(WIDGET_RESOURCE, x + 5 + 18 * col, y + 5 + 18 * row, 6.0f, 6.0f, 18, 18, 256, 256);
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public int getHeight() {
            return 65;
        }

        public int getWidth(@NotNull Font font) {
            return 171;
        }
    }
}

