/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.module;

import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.violetmoon.quark.api.IUsageTickerOverride;
import org.violetmoon.quark.api.event.UsageTickerEvent;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.client.event.play.ZClientTick;
import org.violetmoon.zeta.client.event.play.ZRenderGuiOverlay;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="client")
public class UsageTickerModule
extends ZetaModule {
    @Config(description="Switch the armor display to the off hand side and the hand display to the main hand side")
    public static boolean invert = false;
    @Config
    public static int shiftLeft = 0;
    @Config
    public static int shiftRight = 0;
    @Config
    public static boolean enableMainHand = true;
    @Config
    public static boolean enableOffHand = true;
    @Config
    public static boolean enableArmor = true;

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends UsageTickerModule {
        public static List<TickerElement> elements = new ArrayList<TickerElement>();

        @LoadEvent
        public final void configChanged(ZConfigChanged event) {
            elements = new ArrayList<TickerElement>();
            if (enableMainHand) {
                elements.add(new TickerElement(EquipmentSlot.MAINHAND));
            }
            if (enableOffHand) {
                elements.add(new TickerElement(EquipmentSlot.OFFHAND));
            }
            if (enableArmor) {
                elements.add(new TickerElement(EquipmentSlot.HEAD));
                elements.add(new TickerElement(EquipmentSlot.CHEST));
                elements.add(new TickerElement(EquipmentSlot.LEGS));
                elements.add(new TickerElement(EquipmentSlot.FEET));
            }
        }

        @PlayEvent
        public void clientTick(ZClientTick.End event) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null && mc.level != null) {
                for (TickerElement ticker : elements) {
                    if (ticker == null) continue;
                    ticker.tick(mc.player);
                }
            }
        }

        @PlayEvent
        public void renderHUD(ZRenderGuiOverlay.Hotbar.Post event) {
            Window window = event.getWindow();
            LocalPlayer player = Minecraft.getInstance().player;
            float partial = event.getPartialTick().getGameTimeDeltaTicks();
            GuiGraphics guiGraphics = event.getGuiGraphics();
            for (TickerElement ticker : elements) {
                if (ticker == null) continue;
                ticker.render(guiGraphics, window, player, invert, partial);
            }
        }

        public static class TickerElement {
            private static final int MAX_TIME = 60;
            private static final int ANIM_TIME = 5;
            public int liveTicks;
            public final EquipmentSlot slot;
            public ItemStack currStack = ItemStack.EMPTY;
            public ItemStack currRealStack = ItemStack.EMPTY;
            public int currCount;

            public TickerElement(EquipmentSlot slot) {
                this.slot = slot;
            }

            public void tick(LocalPlayer player) {
                int count;
                ItemStack realStack = this.getStack((Player)player);
                ItemStack displayedStack = this.getLogicalStack(realStack, count = this.getStackCount((Player)player, realStack, realStack, false), player, false);
                if (displayedStack.isEmpty()) {
                    this.liveTicks = 0;
                } else if (this.shouldChange(realStack, this.currRealStack, count, this.currCount) || this.shouldChange(displayedStack, this.currStack, count, this.currCount)) {
                    boolean animatingOut;
                    boolean done = this.liveTicks == 0;
                    boolean animatingIn = this.liveTicks > 55;
                    boolean bl = animatingOut = this.liveTicks < 5 && !done;
                    if (animatingOut) {
                        this.liveTicks = 60 - this.liveTicks;
                    } else if (!animatingIn) {
                        this.liveTicks = !done ? 55 : 60;
                    }
                } else if (this.liveTicks > 0) {
                    --this.liveTicks;
                }
                this.currCount = count;
                this.currStack = displayedStack;
                this.currRealStack = realStack;
            }

            public void render(GuiGraphics guiGraphics, Window window, LocalPlayer player, boolean invert, float partialTicks) {
                if (this.liveTicks > 0) {
                    float mul;
                    float animProgress = this.liveTicks < 5 ? Math.max(0.0f, (float)this.liveTicks - partialTicks) / 5.0f : Math.min(5.0f, (float)(60 - this.liveTicks) + partialTicks) / 5.0f;
                    float anim = -animProgress * (animProgress - 2.0f) * 20.0f;
                    float x = (float)window.getGuiScaledWidth() / 2.0f;
                    float y = (float)window.getGuiScaledHeight() - anim;
                    int barWidth = 190;
                    boolean armor = this.slot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR;
                    HumanoidArm primary = player.getMainArm();
                    HumanoidArm ourSide = armor != invert ? primary : primary.getOpposite();
                    int slots = armor ? 4 : 2;
                    int index = slots - this.slot.getIndex() - 1;
                    float f = mul = ourSide == HumanoidArm.LEFT ? -1.0f : 1.0f;
                    if (ourSide != primary && !player.getItemInHand(InteractionHand.OFF_HAND).isEmpty()) {
                        barWidth += 58;
                    }
                    x += (float)barWidth / 2.0f * mul + (float)(index * 20);
                    if (ourSide == HumanoidArm.LEFT) {
                        x -= (float)(slots * 20);
                        x += (float)shiftLeft;
                    } else {
                        x += (float)shiftRight;
                    }
                    ItemStack stack = this.getRenderedStack(player);
                    guiGraphics.renderItem(stack, (int)x, (int)y);
                    guiGraphics.renderItemDecorations(Minecraft.getInstance().font, stack, (int)x, (int)y);
                }
            }

            public boolean shouldChange(ItemStack currStack, ItemStack prevStack, int currentTotal, int pastTotal) {
                return currStack.getItem() != prevStack.getItem() || currStack.isDamageableItem() && currStack.getDamageValue() != prevStack.getDamageValue() || currentTotal != pastTotal;
            }

            public ItemStack getStack(Player player) {
                return player.getItemBySlot(this.slot);
            }

            public ItemStack getLogicalStack(ItemStack stack, int count, LocalPlayer player, boolean renderPass) {
                boolean verifySize = true;
                ItemStack returnStack = stack;
                boolean logicLock = false;
                Item item = stack.getItem();
                if (item instanceof IUsageTickerOverride) {
                    IUsageTickerOverride over = (IUsageTickerOverride)item;
                    returnStack = stack = over.getUsageTickerItem(stack, player.level().registryAccess());
                    verifySize = over.shouldUsageTickerCheckMatchSize(this.currStack);
                } else if (TickerElement.isProjectileWeapon(player.level().registryAccess(), stack)) {
                    returnStack = player.getProjectile(stack);
                    logicLock = true;
                }
                if (!logicLock) {
                    if (!stack.isStackable() && this.slot.getType() == EquipmentSlot.Type.HAND) {
                        returnStack = ItemStack.EMPTY;
                    } else if (verifySize && stack.isStackable() && count == stack.getCount()) {
                        returnStack = ItemStack.EMPTY;
                    }
                }
                UsageTickerEvent.GetStack event = new UsageTickerEvent.GetStack(this.slot, returnStack, stack, count, renderPass, (Player)player);
                NeoForge.EVENT_BUS.post((Event)event);
                return event.isCanceled() ? ItemStack.EMPTY : event.getResultStack();
            }

            public int getStackCount(Player player, ItemStack displayStack, ItemStack original, boolean renderPass) {
                int val = 1;
                if (displayStack.isStackable()) {
                    Predicate<ItemStack> predicate = stackAt -> ItemStack.isSameItemSameComponents((ItemStack)stackAt, (ItemStack)displayStack);
                    int total = 0;
                    Inventory inventory = player.getInventory();
                    for (int i = 0; i < inventory.getContainerSize(); ++i) {
                        ItemStack stackAt2 = inventory.getItem(i);
                        if (predicate.test(stackAt2)) {
                            total += stackAt2.getCount();
                            continue;
                        }
                        Item item = stackAt2.getItem();
                        if (!(item instanceof IUsageTickerOverride)) continue;
                        IUsageTickerOverride over = (IUsageTickerOverride)item;
                        total += over.getUsageTickerCountForItem(stackAt2, predicate);
                    }
                    val = Math.max(total, displayStack.getCount());
                }
                UsageTickerEvent.GetCount event = new UsageTickerEvent.GetCount(this.slot, displayStack, original, val, renderPass, player);
                NeoForge.EVENT_BUS.post((Event)event);
                return event.isCanceled() ? 0 : event.getResultCount();
            }

            private static boolean isProjectileWeapon(RegistryAccess access, ItemStack stack) {
                Holder.Reference enchantment = access.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.INFINITY);
                return stack.getItem() instanceof ProjectileWeaponItem && Quark.ZETA.itemExtensions.get(stack).getEnchantmentLevelZeta(stack, (Holder)enchantment) == 0;
            }

            public ItemStack getRenderedStack(LocalPlayer player) {
                int count;
                ItemStack stack = this.getStack((Player)player);
                ItemStack logicalStack = this.getLogicalStack(stack, count = this.getStackCount((Player)player, stack, stack, true), player, true).copy();
                if (logicalStack != stack) {
                    count = this.getStackCount((Player)player, logicalStack, stack, true);
                }
                logicalStack.setCount(count);
                if (logicalStack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                return logicalStack;
            }
        }
    }
}

