/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.config.definition;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.config.type.ConvulsionMatrixConfig;
import org.violetmoon.zeta.client.ZetaClient;
import org.violetmoon.zeta.client.config.definition.ClientDefinitionExt;
import org.violetmoon.zeta.client.config.screen.AbstractSectionInputScreen;
import org.violetmoon.zeta.client.config.widget.PencilButton;
import org.violetmoon.zeta.config.ChangeSet;
import org.violetmoon.zeta.config.SectionDefinition;
import org.violetmoon.zeta.config.ValueDefinition;

public class ConvulsionMatrixClientDefinition
implements ClientDefinitionExt<SectionDefinition> {
    private final ConvulsionMatrixConfig.Params params;
    private final ValueDefinition<List<Double>> r;
    private final ValueDefinition<List<Double>> g;
    private final ValueDefinition<List<Double>> b;

    public ConvulsionMatrixClientDefinition(ConvulsionMatrixConfig cfg, SectionDefinition def) {
        this.params = cfg.params;
        this.r = def.getValueErased("R", List.class);
        this.g = def.getValueErased("G", List.class);
        this.b = def.getValueErased("B", List.class);
        Preconditions.checkNotNull(this.r, (Object)"need an 'R' value in this section");
        Preconditions.checkNotNull(this.g, (Object)"need an 'G' value in this section");
        Preconditions.checkNotNull(this.b, (Object)"need an 'B' value in this section");
    }

    public String getSubtitle(ChangeSet changes, SectionDefinition def) {
        List r_ = changes.getExactSizeCopy(this.r, 3, (Object)0.0);
        List g_ = changes.getExactSizeCopy(this.g, 3, (Object)0.0);
        List b_ = changes.getExactSizeCopy(this.b, 3, (Object)0.0);
        return Stream.of(r_, g_, b_).flatMap(Collection::stream).map(d -> String.format("%.1f", d)).collect(Collectors.joining(", ", "[", "]"));
    }

    public void addWidgets(ZetaClient zc, Screen parent, ChangeSet changes, SectionDefinition def, Consumer<AbstractWidget> widgets) {
        ConvulsionMatrixInputScreen newScreen = new ConvulsionMatrixInputScreen(zc, parent, changes, def);
        widgets.accept((AbstractWidget)new PencilButton(zc, 230, 3, arg_0 -> ConvulsionMatrixClientDefinition.lambda$addWidgets$1((Screen)newScreen, arg_0)));
    }

    private static /* synthetic */ void lambda$addWidgets$1(Screen newScreen, Button b1) {
        Minecraft.getInstance().setScreen(newScreen);
    }

    class ConvulsionMatrixInputScreen
    extends AbstractSectionInputScreen {
        ExtendedSlider[] sliders;
        private static final Component EMPTY = Component.empty();

        public ConvulsionMatrixInputScreen(ZetaClient zc, Screen parent, ChangeSet changes, SectionDefinition def) {
            super(zc, parent, changes, def);
            this.sliders = new ExtendedSlider[9];
        }

        protected List<Double> with(ValueDefinition<List<Double>> def, int index, double value) {
            List copy = this.changes.getExactSizeCopy(def, 3, (Object)0.0);
            copy.set(index, value);
            return copy;
        }

        protected void init() {
            super.init();
            int w = 70;
            int p = 12;
            int x = this.width / 2 - 33;
            int y = 55;
            this.sliders[0] = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)this.makeSliderPlease(x + w * 0, y + 0, w - p, 20, ConvulsionMatrixClientDefinition.this.r, 0));
            this.sliders[1] = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)this.makeSliderPlease(x + w * 1, y + 0, w - p, 20, ConvulsionMatrixClientDefinition.this.r, 1));
            this.sliders[2] = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)this.makeSliderPlease(x + w * 2, y + 0, w - p, 20, ConvulsionMatrixClientDefinition.this.r, 2));
            this.sliders[3] = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)this.makeSliderPlease(x + w * 0, y + 25, w - p, 20, ConvulsionMatrixClientDefinition.this.g, 0));
            this.sliders[4] = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)this.makeSliderPlease(x + w * 1, y + 25, w - p, 20, ConvulsionMatrixClientDefinition.this.g, 1));
            this.sliders[5] = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)this.makeSliderPlease(x + w * 2, y + 25, w - p, 20, ConvulsionMatrixClientDefinition.this.g, 2));
            this.sliders[6] = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)this.makeSliderPlease(x + w * 0, y + 50, w - p, 20, ConvulsionMatrixClientDefinition.this.b, 0));
            this.sliders[7] = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)this.makeSliderPlease(x + w * 1, y + 50, w - p, 20, ConvulsionMatrixClientDefinition.this.b, 1));
            this.sliders[8] = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)this.makeSliderPlease(x + w * 2, y + 50, w - p, 20, ConvulsionMatrixClientDefinition.this.b, 2));
            int i = 0;
            for (Map.Entry<String, double[]> entry : ConvulsionMatrixClientDefinition.this.params.presetMap.entrySet()) {
                String name = entry.getKey();
                double[] preset = entry.getValue();
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)name), __ -> this.setFromArray(preset)).size(w - p, 20).pos(x + w * i, y + 115).build());
                ++i;
            }
            this.forceUpdateWidgets();
        }

        protected void forceUpdateWidgets() {
            this.setFromList(Stream.of(this.changes.getExactSizeCopy(ConvulsionMatrixClientDefinition.this.r, 3, (Object)0.0), this.changes.getExactSizeCopy(ConvulsionMatrixClientDefinition.this.g, 3, (Object)0.0), this.changes.getExactSizeCopy(ConvulsionMatrixClientDefinition.this.b, 3, (Object)0.0)).flatMap(Collection::stream).toList());
        }

        private ExtendedSlider makeSliderPlease(final int x, final int y, int width, int height, final ValueDefinition<List<Double>> binding, final int bindingIndex) {
            return new ExtendedSlider(x, y, width, height, EMPTY, EMPTY, 0.0, 2.0, 0.0, 0.0, 1, false){

                public void setValue(double value) {
                    super.setValue(value);
                    ConvulsionMatrixInputScreen.this.changes.set(binding, ConvulsionMatrixInputScreen.this.with((ValueDefinition<List<Double>>)binding, bindingIndex, value));
                }

                protected void applyValue() {
                    this.setValue(ConvulsionMatrixInputScreen.this.snap(this));
                }

                public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                    Minecraft mc = Minecraft.getInstance();
                    super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
                    String displayVal = String.format("%.2f", this.getValue());
                    int valueColor = ConvulsionMatrixInputScreen.this.changes.isDirty(binding) ? ChatFormatting.GOLD.getColor() : 0xFFFFFF;
                    guiGraphics.drawString(mc.font, displayVal, x + (this.getWidth() / 2 - ConvulsionMatrixInputScreen.this.font.width(displayVal) / 2), y + 6, valueColor);
                }
            };
        }

        public void tick() {
            this.updateButtonStatus(true);
        }

        public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            PoseStack mstack = guiGraphics.pose();
            this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
            super.render(guiGraphics, mouseX, mouseY, partialTicks);
            int x = this.width / 2 - 203;
            int y = 10;
            int size = 60;
            int titleLeft = this.width / 2 + 66;
            guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)ConvulsionMatrixClientDefinition.this.params.name).withStyle(ChatFormatting.BOLD), titleLeft, 20, 0xFFFFFF);
            guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)"Presets"), titleLeft, 155, 0xFFFFFF);
            int sliders = 0;
            for (Renderable renderable : this.renderables) {
                if (!(renderable instanceof ExtendedSlider)) continue;
                ExtendedSlider slider = (ExtendedSlider)renderable;
                switch (sliders) {
                    case 0: {
                        guiGraphics.drawString(this.font, "R =", slider.getX() - 20, slider.getY() + 5, 0xFF0000);
                        guiGraphics.drawString(this.font, "R", slider.getX() + (slider.getWidth() / 2 - 2), slider.getY() - 12, 0xFF0000);
                        break;
                    }
                    case 1: {
                        guiGraphics.drawString(this.font, "G", slider.getX() + (slider.getWidth() / 2 - 2), slider.getY() - 12, 65280);
                        break;
                    }
                    case 2: {
                        guiGraphics.drawString(this.font, "B", slider.getX() + (slider.getWidth() / 2 - 2), slider.getY() - 12, 30719);
                        break;
                    }
                    case 3: {
                        guiGraphics.drawString(this.font, "G =", slider.getX() - 20, slider.getY() + 5, 65280);
                        break;
                    }
                    case 6: {
                        guiGraphics.drawString(this.font, "B =", slider.getX() - 20, slider.getY() + 5, 30719);
                    }
                }
                if (sliders % 3 != 0) {
                    guiGraphics.drawString(this.font, "+", slider.getX() - 9, slider.getY() + 5, 0xFFFFFF);
                }
                ++sliders;
            }
            String[] biomes = ConvulsionMatrixClientDefinition.this.params.biomeNames;
            int[] colors = ConvulsionMatrixClientDefinition.this.params.testColors;
            int[] folliageColors = ConvulsionMatrixClientDefinition.this.params.folliageTestColors;
            boolean renderFolliage = ConvulsionMatrixClientDefinition.this.params.shouldDisplayFolliage();
            double[] matrix = this.getToDoubleArray();
            for (int i = 0; i < biomes.length; ++i) {
                String name = biomes[i];
                int color = colors[i];
                int convolved = ConvulsionMatrixConfig.convolve(matrix, color);
                int convolvedFolliage = 0;
                if (renderFolliage) {
                    int folliage = folliageColors[i];
                    convolvedFolliage = ConvulsionMatrixConfig.convolve(matrix, folliage);
                }
                int cx = x + i % 2 * (size + 5);
                int cy = y + i / 2 * (size + 5);
                guiGraphics.fill(cx - 1, cy - 1, cx + size + 1, cy + size + 1, -16777216);
                guiGraphics.fill(cx, cy, cx + size, cy + size, convolved);
                guiGraphics.fill(cx + size / 2 - 1, cy + size / 2 - 1, cx + size, cy + size, 0x22000000);
                if (renderFolliage) {
                    guiGraphics.fill(cx + size / 2, cy + size / 2, cx + size, cy + size, convolvedFolliage);
                }
                guiGraphics.drawString(this.font, name, cx + 2, cy + 2, 0x55000000);
                if (!renderFolliage) continue;
                guiGraphics.renderItem(new ItemStack((ItemLike)Items.OAK_SAPLING), cx + size - 18, cy + size - 16);
                mstack.pushPose();
                mstack.translate(0.0f, 0.0f, 999.0f);
                guiGraphics.fill(cx + size / 2, cy + size / 2, cx + size, cy + size, convolvedFolliage & 0x55FFFFFF);
                mstack.popPose();
            }
        }

        protected void setFromArray(double[] values) {
            for (int i = 0; i < 9; ++i) {
                this.sliders[i].setValue(values[i]);
            }
        }

        protected void setFromList(List<Double> values) {
            for (int i = 0; i < 9; ++i) {
                this.sliders[i].setValue(values.get(i).doubleValue());
            }
        }

        protected double[] getToDoubleArray() {
            double[] values = new double[9];
            for (int i = 0; i < 9; ++i) {
                values[i] = this.sliders[i].getValue();
            }
            return values;
        }

        private double snap(ExtendedSlider slider) {
            double val = slider.getValue();
            val = this.snap(val, 0.5, slider);
            val = this.snap(val, 1.0, slider);
            val = this.snap(val, 1.5, slider);
            return val;
        }

        private double snap(double val, double correct, ExtendedSlider slider) {
            if (Math.abs(val - correct) < 0.02) {
                slider.setValue(correct);
                return correct;
            }
            return val;
        }
    }
}

