/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.play.ZPlayNoteBlock;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="tweaks")
public class MoreNoteBlockSoundsModule
extends ZetaModule {
    @Config(flag="amethyst_note_block")
    public static boolean enableAmethystSound = true;
    @Hint(value="amethyst_note_block")
    Item amethyst_block = Items.f_150998_;

    @PlayEvent
    public void noteBlockPlayed(ZPlayNoteBlock event) {
        BlockPos pos;
        LevelAccessor world = event.getLevel();
        if (world.m_8055_(pos = event.getPos()).m_60734_() != Blocks.f_50065_) {
            return;
        }
        if (enableAmethystSound && event.getInstrument() == NoteBlockInstrument.HARP && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (this.isAmethyst(world.m_8055_(pos.m_7495_()))) {
                event.setCanceled(true);
                int note = (Integer)event.getState().m_61143_((Property)NoteBlock.f_55013_);
                float pitch = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
                world.m_5594_(null, pos, SoundEvents.f_144243_, SoundSource.RECORDS, 1.0f, pitch);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, (double)note / 24.0);
            }
        }
    }

    private boolean isAmethyst(BlockState state) {
        return state.m_60827_() == SoundType.f_154654_ || state.m_60827_() == SoundType.f_154655_ || state.m_60734_() == Blocks.f_152493_ || state.m_60734_() == Blocks.f_152494_ || state.m_60734_() == Blocks.f_152495_;
    }
}

