/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.item;

import java.util.function.BooleanSupplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.item.IZetaItem;
import org.violetmoon.zeta.item.ZetaArmorItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;

public class ForgottenHatItem
extends ZetaArmorItem
implements IZetaItem {
    private static final ResourceLocation TEXTURE = Quark.asResource(":textures/misc/forgotten_hat_worn.png");
    private final ZetaModule module;

    public ForgottenHatItem(ZetaModule module) {
        super(ArmorMaterials.LEATHER, ArmorItem.Type.HELMET, new Item.Properties().stacksTo(1).durability(0).rarity(Rarity.RARE).attributes(ForgottenHatItem.createAttributes()));
        Quark.ZETA.registry.registerItem((Item)this, "forgotten_hat");
        this.module = module;
        CreativeTabManager.addToCreativeTabNextTo((ResourceKey)CreativeModeTabs.TOOLS_AND_UTILITIES, (ItemLike)this, (ItemLike)Items.SADDLE, (boolean)true);
    }

    public ZetaModule getModule() {
        return this.module;
    }

    public IZetaItem setCondition(BooleanSupplier condition) {
        return this;
    }

    public boolean doesConditionApply() {
        return true;
    }

    public boolean canEquipZeta(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        return armorType == EquipmentSlot.HEAD;
    }

    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return TEXTURE;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public static ItemAttributeModifiers createAttributes() {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        builder.add(Attributes.ARMOR, new AttributeModifier(Quark.asResource("forgotten_hat_armor"), 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HEAD);
        builder.add(Attributes.LUCK, new AttributeModifier(Quark.asResource("forgotten_hat_luck"), 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HEAD);
        builder.add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(Quark.asResource("forgotten_hat_entity_interaction_range"), 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HEAD);
        builder.add(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(Quark.asResource("forgotten_hat_block_interaction_range"), 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HEAD);
        return builder.build();
    }
}

