/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.block.TinyPotatoBlock;
import org.violetmoon.quark.addons.oddities.util.TinyPotatoInfo;
import org.violetmoon.quark.api.IRuneColorProvider;
import org.violetmoon.quark.base.components.QuarkDataComponents;
import org.violetmoon.quark.base.handler.ContributorRewardHandler;
import org.violetmoon.quark.content.tools.base.RuneColor;
import org.violetmoon.zeta.item.ZetaBlockItem;

public class TinyPotatoBlockItem
extends ZetaBlockItem
implements IRuneColorProvider {
    private static final int NOT_MY_NAME = 17;
    private static final List<String> TYPOS = List.of("vaskii", "vazki", "voskii", "vazkkii", "vazkki", "vazzki", "vaskki", "vozkii", "vazkil", "vaskil", "vazkill", "vaskill", "vaski");

    public TinyPotatoBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public boolean canEquipZeta(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        Player player;
        return armorType == EquipmentSlot.HEAD && entity instanceof Player && ContributorRewardHandler.getTier(player = (Player)entity) > 0;
    }

    @NotNull
    public String getDescriptionId(@NotNull ItemStack stack) {
        if (TinyPotatoBlock.isAngry(stack)) {
            return super.getDescriptionId(stack) + ".angry";
        }
        return super.getDescriptionId(stack);
    }

    private void updateData(ItemStack stack) {
        CompoundTag tileTag = ((CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)).copyTag();
        if (tileTag != null && tileTag.contains("angery", 99)) {
            boolean angry = tileTag.getBoolean("angery");
            if (angry) {
                stack.set(QuarkDataComponents.IS_ANGRY, (Object)true);
            } else if (TinyPotatoBlock.isAngry(stack)) {
                stack.set(QuarkDataComponents.IS_ANGRY, (Object)false);
            }
            tileTag.remove("angery");
        }
        if (Boolean.TRUE.equals(stack.get(QuarkDataComponents.IS_ANGRY))) {
            stack.set(QuarkDataComponents.IS_ANGRY, (Object)false);
        }
    }

    public boolean onEntityItemUpdateZeta(ItemStack stack, ItemEntity entity) {
        this.updateData(stack);
        return super.onEntityItemUpdateZeta(stack, entity);
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level world, @NotNull Entity holder, int itemSlot, boolean isSelected) {
        this.updateData(stack);
        if (!world.isClientSide && holder instanceof Player) {
            int ticks;
            Player player = (Player)holder;
            if (holder.tickCount % 30 == 0 && TYPOS.contains(ChatFormatting.stripFormatting((String)stack.getDisplayName().getString())) && (ticks = ((Integer)stack.get(QuarkDataComponents.TICKS)).intValue()) < 17) {
                player.sendSystemMessage((Component)Component.translatable((String)("quark.misc.you_came_to_the_wrong_neighborhood." + ticks)).withStyle(ChatFormatting.RED));
                stack.set(QuarkDataComponents.TICKS, (Object)(ticks + 1));
            }
        }
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return stack.has(DataComponents.CUSTOM_NAME) && TinyPotatoInfo.fromComponent(stack.getHoverName()).enchanted() || super.isFoil(stack);
    }

    @Override
    public RuneColor getRuneColor(ItemStack stack) {
        return stack.has(DataComponents.CUSTOM_NAME) ? TinyPotatoInfo.fromComponent(stack.getHoverName()).runeColor() : null;
    }
}

