/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.item;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.api.ITrowelable;
import org.violetmoon.quark.api.IUsageTickerOverride;
import org.violetmoon.quark.base.components.QuarkDataComponents;
import org.violetmoon.quark.content.tools.module.TrowelModule;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.MiscUtil;

public class TrowelItem
extends ZetaItem
implements IUsageTickerOverride {
    public TrowelItem(ZetaModule module) {
        super("trowel", module, new Item.Properties().durability(255));
        CreativeTabManager.addToCreativeTabNextTo((ResourceKey)CreativeModeTabs.TOOLS_AND_UTILITIES, (ItemLike)this, (ItemLike)Items.SHEARS, (boolean)false);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        InteractionHand hand = context.getHand();
        ArrayList<Integer> targets = new ArrayList<Integer>();
        Inventory inventory = player.getInventory();
        for (int i = 0; i < Inventory.getSelectionSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!TrowelItem.isValidTarget(stack, context)) continue;
            targets.add(i);
        }
        if (targets.isEmpty()) {
            return InteractionResult.PASS;
        }
        ItemStack trowel = player.getItemInHand(hand);
        long seed = Optional.ofNullable((Long)trowel.get(QuarkDataComponents.TAG_PLACING_SEED)).orElse(0L);
        Random rand = new Random(seed);
        trowel.set(QuarkDataComponents.TAG_PLACING_SEED, (Object)rand.nextLong());
        int targetSlot = (Integer)targets.get(rand.nextInt(targets.size()));
        ItemStack toPlaceStack = inventory.getItem(targetSlot);
        player.setItemInHand(hand, toPlaceStack);
        InteractionResult result = toPlaceStack.useOn((UseOnContext)new TrowelBlockItemUseContext(context, toPlaceStack));
        ItemStack newHandItem = player.getItemInHand(hand);
        player.setItemInHand(hand, trowel);
        inventory.setItem(targetSlot, newHandItem);
        if (result.consumesAction()) {
            trowel.set(QuarkDataComponents.TAG_LAST_STACK, (Object)toPlaceStack);
            if (TrowelModule.maxDamage > 0) {
                MiscUtil.damageStack((ItemStack)context.getItemInHand(), (int)1, (Player)player, (EquipmentSlot)(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND));
            }
        }
        return result;
    }

    private static boolean isValidTarget(ItemStack stack, UseOnContext context) {
        Item item = stack.getItem();
        if (stack.is(TrowelModule.whitelist)) {
            return true;
        }
        if (stack.is(TrowelModule.blacklist)) {
            return false;
        }
        if (item instanceof ITrowelable) {
            ITrowelable t = (ITrowelable)item;
            return t.canBeTroweled(stack, context);
        }
        return !stack.isEmpty() && item instanceof BlockItem;
    }

    public static ItemStack getLastStack(ItemStack stack) {
        return (ItemStack)stack.get(QuarkDataComponents.TAG_LAST_STACK);
    }

    @Override
    public ItemStack getUsageTickerItem(ItemStack stack, RegistryAccess access) {
        return TrowelItem.getLastStack(stack);
    }

    static class TrowelBlockItemUseContext
    extends BlockPlaceContext {
        public TrowelBlockItemUseContext(UseOnContext context, ItemStack stack) {
            super(context.getLevel(), context.getPlayer(), context.getHand(), stack, new BlockHitResult(context.getClickLocation(), context.getClickedFace(), context.getClickedPos(), context.isInside()));
        }
    }
}

