/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.module;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.JukeboxSongs;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.zeta.client.event.play.ZClientTick;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.loading.ZLootTableLoad;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="tools")
public class EndermoshMusicDiscModule
extends ZetaModule {
    @Config
    protected boolean playEndermoshDuringEnderdragonFight = false;
    @Config
    protected boolean addToEndCityLoot = true;
    @Config
    protected int lootWeight = 5;
    @Config
    protected int lootQuality = 1;
    @Hint
    public Item endermosh;

    @LoadEvent
    public final void register(ZRegister event) {
        this.endermosh = new ZetaItem("music_disc_endermosh", (ZetaModule)this, new Item.Properties().rarity(Rarity.RARE).jukeboxPlayable(JukeboxSongs.THIRTEEN));
    }

    @PlayEvent
    public void onLootTableLoad(ZLootTableLoad event) {
        ResourceLocation res;
        if (this.addToEndCityLoot && (res = event.getName()).equals((Object)BuiltInLootTables.END_CITY_TREASURE.location())) {
            LootPoolEntryContainer entry = LootItem.lootTableItem((ItemLike)this.endermosh).setWeight(this.lootWeight).setQuality(this.lootQuality).build();
            event.add(entry);
        }
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends EndermoshMusicDiscModule {
        private boolean isFightingDragon;
        private int delay;
        private SimpleSoundInstance sound;

        @PlayEvent
        public void clientTick(ZClientTick.End event) {
            if (this.playEndermoshDuringEnderdragonFight) {
                boolean wasFightingDragon = this.isFightingDragon;
                Minecraft mc = Minecraft.getInstance();
                this.isFightingDragon = mc.level != null && mc.level.dimension().location().equals((Object)LevelStem.END.location()) && mc.gui.getBossOverlay().shouldPlayMusic();
                int targetDelay = 50;
                if (this.isFightingDragon) {
                    if (this.delay == 50) {
                        this.sound = SimpleSoundInstance.forMusic((SoundEvent)QuarkSounds.MUSIC_ENDERMOSH);
                        mc.getSoundManager().playDelayed((SoundInstance)this.sound, 0);
                        mc.gui.setNowPlaying(this.endermosh.getDescription());
                    }
                    double x = mc.player.getX();
                    double z = mc.player.getZ();
                    if (mc.screen == null && x * x + z * z < 3000.0) {
                        ++this.delay;
                    }
                } else if (wasFightingDragon && this.sound != null) {
                    mc.getSoundManager().stop((SoundInstance)this.sound);
                    this.delay = 0;
                    this.sound = null;
                }
            }
        }
    }
}

