/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="tweaks")
public class GoldToolsHaveFortuneModule
extends ZetaModule {
    private static final Tier[] TIERS = new Tier[]{Tiers.WOOD, Tiers.STONE, Tiers.IRON, Tiers.DIAMOND, Tiers.NETHERITE};
    @Config
    @Config.Min(value=0.0)
    public static int fortuneLevel = 2;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=4.0)
    public static int harvestLevel = 2;
    @Config
    public static boolean displayBakedEnchantmentsInTooltip = true;
    @Config
    public static boolean italicTooltip = true;
    @Config(description="Enchantments other than Gold's Fortune/Looting to bake into items. Format is \"item+enchant@level\", such as \"minecraft:stick+sharpness@10\".")
    public static List<String> bakedEnchantments = Lists.newArrayList();
    private static final Map<Item, Object2IntMap<Enchantment>> wellBakedEnchantments = new HashMap<Item, Object2IntMap<Enchantment>>();
    @Hint(key="gold_tool_fortune", content={"fortuneLevel"})
    List<Item> gold_tools = Arrays.asList(Items.GOLDEN_AXE, Items.GOLDEN_HOE, Items.GOLDEN_PICKAXE, Items.GOLDEN_SHOVEL, Items.GOLDEN_SWORD);
    @Hint(key="gold_tool_harvest_level", content={"harvestLevel"})
    List<Item> gold_tools_2 = this.gold_tools;
    private static boolean staticEnabled;

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.isEnabled();
        wellBakedEnchantments.clear();
        for (String enchantment : bakedEnchantments) {
            ResourceLocation enchantLoc;
            String[] split2;
            Item item;
            ResourceLocation itemLoc;
            String[] split1 = enchantment.split("\\+");
            if (split1.length == 2 && (itemLoc = ResourceLocation.tryParse((String)split1[0])) != null && (item = (Item)BuiltInRegistries.ITEM.get(itemLoc)) != Items.AIR && (split2 = split1[1].split("@")).length != 0 && split2.length <= 2 && (enchantLoc = ResourceLocation.tryParse((String)split2[0])) == null) continue;
        }
        if (fortuneLevel > 0) {
            for (Item item : BuiltInRegistries.ITEM) {
                TieredItem tiered;
                if (item instanceof TieredItem && (tiered = (TieredItem)item).getTier() != Tiers.GOLD) continue;
            }
        }
    }

    public static int getActualEnchantmentLevel(Enchantment enchant, ItemStack stack, int prev) {
        int forcedLevel;
        Object2IntMap<Enchantment> pastry;
        Item item = stack.getItem();
        if (staticEnabled && wellBakedEnchantments.containsKey(item) && (pastry = wellBakedEnchantments.get(item)).containsKey((Object)enchant) && (forcedLevel = pastry.getOrDefault((Object)enchant, 0)) > prev) {
            return forcedLevel;
        }
        return prev;
    }

    public static void addEnchantmentsIfMissing(ItemStack stack, Map<Enchantment, Integer> map) {
        Item item = stack.getItem();
        if (staticEnabled && wellBakedEnchantments.containsKey(item)) {
            Object2IntMap<Enchantment> pastry = wellBakedEnchantments.get(item);
            for (Enchantment enchantment : pastry.keySet()) {
                int effectiveLevel;
                int level = map.getOrDefault(enchantment, 0);
                if (level >= (effectiveLevel = GoldToolsHaveFortuneModule.getActualEnchantmentLevel(enchantment, stack, level))) continue;
                map.put(enchantment, effectiveLevel);
            }
        }
    }

    public static Tier getEffectiveTier(Tier realTier) {
        if (!staticEnabled || realTier != Tiers.GOLD) {
            return realTier;
        }
        return TIERS[harvestLevel];
    }

    public static boolean shouldShowEnchantments(ItemStack stack) {
        return wellBakedEnchantments.containsKey(stack.getItem());
    }

    public static void fakeEnchantmentTooltip(ItemStack stack, List<Component> components) {
    }

    public static ListTag hideSmallerEnchantments(ItemStack stack, ListTag tag) {
        ArrayList toRemove;
        if (staticEnabled && displayBakedEnchantmentsInTooltip && !(toRemove = Lists.newArrayList()).isEmpty()) {
            tag = tag.copy();
            tag.removeIf(it -> {
                if (it instanceof CompoundTag) {
                    CompoundTag compoundTag = (CompoundTag)it;
                }
                return false;
            });
        }
        return tag;
    }
}

