/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.client.render.be;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Calendar;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.block.be.TinyPotatoBlockEntity;
import org.violetmoon.quark.addons.oddities.module.TinyPotatoModule;
import org.violetmoon.quark.addons.oddities.util.TinyPotatoInfo;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.tools.base.RuneColor;
import org.violetmoon.quark.content.tools.module.ColorRunesModule;
import org.violetmoon.quark.mixin.mixins.client.accessor.AccessorModelManager;

public class TinyPotatoRenderer
implements BlockEntityRenderer<TinyPotatoBlockEntity> {
    public static final String DEFAULT = "default";
    public static final String HALLOWEEN = "halloween";
    public static final String ANGRY = "angry";
    private static final Pattern ESCAPED = Pattern.compile("[^a-z0-9/._-]");
    private final BlockRenderDispatcher blockRenderDispatcher;

    public static boolean isTheSpookDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 10 && calendar.get(5) == 31;
    }

    public TinyPotatoRenderer(BlockEntityRendererProvider.Context ctx) {
        this.blockRenderDispatcher = ctx.getBlockRenderDispatcher();
    }

    public static BakedModel getModelFromDisplayName(Component displayName, boolean angry) {
        TinyPotatoInfo info = TinyPotatoInfo.fromComponent(displayName);
        return TinyPotatoRenderer.getModel(info.name(), angry);
    }

    private static BakedModel getModel(String name, boolean angry) {
        ModelManager bmm = Minecraft.getInstance().getModelManager();
        Map<ResourceLocation, BakedModel> mm = ((AccessorModelManager)bmm).getBakedRegistry();
        BakedModel missing = bmm.getMissingModel();
        ResourceLocation location = TinyPotatoRenderer.taterLocation(name);
        BakedModel model = mm.get(location);
        if (model == null) {
            if (TinyPotatoRenderer.isTheSpookDay()) {
                return mm.getOrDefault(TinyPotatoRenderer.taterLocation(HALLOWEEN), missing);
            }
            if (angry) {
                return mm.getOrDefault(TinyPotatoRenderer.taterLocation(ANGRY), missing);
            }
            return mm.getOrDefault(TinyPotatoRenderer.taterLocation(DEFAULT), missing);
        }
        return model;
    }

    private static ResourceLocation taterLocation(String name) {
        return Quark.asResource("tiny_potato/" + TinyPotatoRenderer.normalizeName(name));
    }

    private static String normalizeName(String name) {
        return ESCAPED.matcher(name).replaceAll("_");
    }

    public void render(@NotNull TinyPotatoBlockEntity potato, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffers, int light, int overlay) {
        boolean render;
        ms.pushPose();
        TinyPotatoInfo info = TinyPotatoInfo.fromComponent(potato.name);
        RenderType layer = Sheets.translucentCullBlockSheet();
        BakedModel model = TinyPotatoRenderer.getModel(info.name(), potato.angry);
        ms.translate(0.5f, 0.0f, 0.5f);
        Direction potatoFacing = (Direction)potato.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        float rotY = 0.0f;
        switch (potatoFacing) {
            default: {
                rotY = 180.0f;
                break;
            }
            case NORTH: {
                break;
            }
            case EAST: {
                rotY = 90.0f;
                break;
            }
            case WEST: {
                rotY = 270.0f;
            }
        }
        ms.mulPose(Axis.YN.rotationDegrees(rotY));
        float jump = potato.jumpTicks;
        if (jump > 0.0f) {
            jump -= partialTicks;
        }
        float up = (float)Math.abs(Math.sin((double)(jump / 10.0f) * Math.PI)) * 0.2f;
        float rotZ = (float)Math.sin((double)(jump / 10.0f) * Math.PI) * 2.0f;
        float wiggle = (float)Math.sin((double)(jump / 10.0f) * Math.PI) * 0.05f;
        ms.translate(wiggle, up, 0.0f);
        ms.mulPose(Axis.ZP.rotationDegrees(rotZ));
        boolean bl = render = !info.name().equals("mami") && !info.name().equals("soaryn") && (!info.name().equals("eloraam") || jump == 0.0f);
        if (render) {
            ms.pushPose();
            ms.translate(-0.5f, 0.0f, -0.5f);
            RuneColor runeColor = info.runeColor();
            if (runeColor != null) {
                ColorRunesModule.setTargetColor(runeColor);
            }
            VertexConsumer buffer = ItemRenderer.getFoilBuffer((MultiBufferSource)buffers, (RenderType)layer, (boolean)true, (boolean)info.enchanted());
            this.renderModel(ms, buffer, light, overlay, model);
            ms.popPose();
        }
        ms.translate(0.0f, 1.5f, 0.0f);
        ms.pushPose();
        ms.mulPose(Axis.ZP.rotationDegrees(180.0f));
        this.renderItems(potato, potatoFacing, ms, buffers, light, overlay);
        ms.popPose();
        ms.mulPose(Axis.ZP.rotationDegrees(-rotZ));
        ms.mulPose(Axis.YN.rotationDegrees(-rotY));
        this.renderName(potato, info.name(), ms, buffers, light);
        ms.popPose();
    }

    private void renderName(TinyPotatoBlockEntity potato, String name, PoseStack ms, MultiBufferSource buffers, int light) {
        Minecraft mc = Minecraft.getInstance();
        HitResult pos = mc.hitResult;
        if (Minecraft.renderNames() && !name.isEmpty() && pos != null && pos.getType() == HitResult.Type.BLOCK && potato.getBlockPos().equals((Object)((BlockHitResult)pos).getBlockPos())) {
            ms.pushPose();
            ms.translate(0.0f, -0.6f, 0.0f);
            ms.mulPose(mc.getEntityRenderDispatcher().cameraOrientation());
            float f1 = 0.02666667f;
            ms.scale(-f1, -f1, f1);
            int halfWidth = mc.font.width(potato.name.getString()) / 2;
            float opacity = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
            int opacityRGB = (int)(opacity * 255.0f) << 24;
            mc.font.drawInBatch(potato.name, (float)(-halfWidth), 0.0f, 0x20FFFFFF, false, ms.last().pose(), buffers, Font.DisplayMode.SEE_THROUGH, opacityRGB, light);
            mc.font.drawInBatch(potato.name, (float)(-halfWidth), 0.0f, -1, false, ms.last().pose(), buffers, Font.DisplayMode.NORMAL, 0, light);
            if (name.equals("pahimar") || name.equals("soaryn")) {
                ms.translate(0.0f, 14.0f, 0.0f);
                String str = name.equals("pahimar") ? "[WIP]" : "(soon)";
                halfWidth = mc.font.width(str) / 2;
                mc.font.drawInBatch(str, (float)(-halfWidth), 0.0f, 0x20FFFFFF, false, ms.last().pose(), buffers, Font.DisplayMode.SEE_THROUGH, opacityRGB, light);
                mc.font.drawInBatch(str, (float)(-halfWidth), 0.0f, -1, false, ms.last().pose(), buffers, Font.DisplayMode.SEE_THROUGH, 0, light);
            }
            ms.popPose();
        }
    }

    private void renderItems(TinyPotatoBlockEntity potato, Direction facing, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ms.pushPose();
        ms.mulPose(Axis.ZP.rotationDegrees(180.0f));
        ms.translate(0.0f, -1.0f, 0.0f);
        float s = 0.2857143f;
        ms.scale(s, s, s);
        for (int i = 0; i < potato.getContainerSize(); ++i) {
            ItemStack stack = potato.getItem(i);
            if (stack.isEmpty()) continue;
            ms.pushPose();
            Direction side = Direction.values()[i];
            if (side.getAxis() != Direction.Axis.Y) {
                float sideAngle = side.toYRot() - facing.toYRot();
                side = Direction.fromYRot((double)sideAngle);
            }
            boolean block = stack.getItem() instanceof BlockItem;
            boolean mySon = stack.getItem() == TinyPotatoModule.tiny_potato.asItem();
            switch (side) {
                case UP: {
                    if (mySon) {
                        ms.translate(0.0f, -0.375f, 0.5f);
                    } else if (block) {
                        ms.translate(0.0f, 0.3f, 0.5f);
                    }
                    ms.translate(0.0f, -0.5f, -0.4f);
                    break;
                }
                case DOWN: {
                    ms.translate(0.0f, -2.3f, -0.88f);
                    if (mySon) {
                        ms.translate(0.0f, 1.25f, 0.5f);
                        break;
                    }
                    if (!block) break;
                    ms.translate(0.0f, 1.0f, 0.6f);
                    break;
                }
                case NORTH: {
                    ms.translate(0.0f, -1.9f, 0.02f);
                    if (mySon) {
                        ms.translate(0.0f, -0.29f, 0.6f);
                        break;
                    }
                    if (!block) break;
                    ms.translate(0.0f, 1.0f, 0.6f);
                    break;
                }
                case SOUTH: {
                    ms.translate(0.0f, -1.6f, -0.89f);
                    if (mySon) {
                        ms.translate(0.0f, -0.59f, 0.26f);
                        break;
                    }
                    if (!block) break;
                    ms.translate(0.0f, 1.0f, 0.5f);
                    break;
                }
                case EAST: {
                    if (mySon) {
                        ms.translate(-0.35f, -0.29f, -0.06f);
                    } else if (block) {
                        ms.translate(-0.4f, 0.8f, 0.0f);
                    } else {
                        ms.mulPose(Axis.YP.rotationDegrees(-90.0f));
                    }
                    ms.translate(-0.3f, -1.9f, 0.04f);
                    break;
                }
                case WEST: {
                    if (mySon) {
                        TinyPotatoInfo info;
                        ms.translate(0.95f, -0.29f, 0.9f);
                        if (stack.getComponents().has(DataComponents.CUSTOM_NAME) && (info = TinyPotatoInfo.fromComponent(stack.getHoverName())).name().equals("kingdaddydmac")) {
                            ms.translate(0.55f, 0.0f, 0.0f);
                        }
                    } else if (block) {
                        ms.translate(1.0f, 0.8f, 1.0f);
                    } else {
                        ms.mulPose(Axis.YP.rotationDegrees(-90.0f));
                    }
                    ms.translate(-0.3f, -1.9f, -0.92f);
                }
            }
            if (mySon) {
                ms.scale(1.1f, 1.1f, 1.1f);
            } else if (block) {
                ms.scale(0.5f, 0.5f, 0.5f);
            }
            if (block && side == Direction.NORTH) {
                ms.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
            this.renderItem(ms, buffers, light, overlay, stack);
            ms.popPose();
        }
        ms.popPose();
    }

    private void renderModel(PoseStack ms, VertexConsumer buffer, int light, int overlay, BakedModel model) {
        this.blockRenderDispatcher.getModelRenderer().renderModel(ms.last(), buffer, null, model, 1.0f, 1.0f, 1.0f, light, overlay);
    }

    private void renderItem(PoseStack ms, MultiBufferSource buffers, int light, int overlay, ItemStack stack) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.HEAD, light, overlay, ms, buffers, (Level)Minecraft.getInstance().level, 0);
    }
}

