/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.inventory;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.block.be.MatrixEnchantingTableBlockEntity;
import org.violetmoon.quark.addons.oddities.module.MatrixEnchantingModule;

public class MatrixEnchantingMenu
extends AbstractContainerMenu {
    public final MatrixEnchantingTableBlockEntity enchanter;

    public MatrixEnchantingMenu(int id, Inventory playerInv, MatrixEnchantingTableBlockEntity tile) {
        super(MatrixEnchantingModule.menuType, id);
        this.enchanter = tile;
        this.addSlot(new Slot(this, (Container)tile, 0, 15, 20){

            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSlot(new Slot((Container)tile, 1, 15, 44){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return MatrixEnchantingMenu.this.isLapis(stack);
            }
        });
        this.addSlot(new Slot((Container)tile, 2, 59, 32){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }

            public void onTake(@NotNull Player thePlayer, @NotNull ItemStack stack) {
                MatrixEnchantingMenu.this.finish(thePlayer, stack);
                super.onTake(thePlayer, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInv, k, 8 + k * 18, 142));
        }
    }

    public static MatrixEnchantingMenu fromNetwork(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        MatrixEnchantingTableBlockEntity te = (MatrixEnchantingTableBlockEntity)playerInventory.player.level().getBlockEntity(pos);
        return new MatrixEnchantingMenu(windowId, playerInventory, te);
    }

    private boolean isLapis(ItemStack stack) {
        return stack.is(Tags.Items.GEMS_LAPIS);
    }

    private void finish(Player player, ItemStack stack) {
        this.enchanter.setItem(0, ItemStack.EMPTY);
        player.awardStat(Stats.ENCHANT_ITEM);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.ENCHANTED_ITEM.trigger(serverPlayer, stack, 1);
            if (this.enchanter.isMatrixInfluenced()) {
                MatrixEnchantingModule.influenceTrigger.trigger(serverPlayer);
            }
        }
        player.level().playSound(null, this.enchanter.getBlockPos(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, player.level().random.nextFloat() * 0.1f + 0.9f);
    }

    public boolean stillValid(@NotNull Player playerIn) {
        BlockPos pos;
        Level world = this.enchanter.getLevel();
        if (world.getBlockState(pos = this.enchanter.getBlockPos()).getBlock() != MatrixEnchantingModule.matrixEnchanter) {
            return false;
        }
        return playerIn.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int index) {
        ItemStack originalStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            originalStack = stackInSlot.copy();
            if (index < 3) {
                if (!this.moveItemStackTo(stackInSlot, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.isLapis(stackInSlot)) {
                if (!this.moveItemStackTo(stackInSlot, 1, 2, true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (((Slot)this.slots.getFirst()).hasItem() || !((Slot)this.slots.getFirst()).mayPlace(stackInSlot)) {
                    return ItemStack.EMPTY;
                }
                if (!stackInSlot.isEmpty() && !stackInSlot.getComponents().isEmpty()) {
                    ((Slot)this.slots.getFirst()).set(stackInSlot.split(1));
                } else if (!stackInSlot.isEmpty()) {
                    ((Slot)this.slots.getFirst()).set(new ItemStack((ItemLike)stackInSlot.getItem(), 1));
                    stackInSlot.shrink(1);
                }
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stackInSlot.getCount() == originalStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, stackInSlot);
        }
        return originalStack;
    }
}

