/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.config.definition;

import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.config.type.RGBAColorConfig;
import org.violetmoon.zeta.client.ZetaClient;
import org.violetmoon.zeta.client.config.definition.ClientDefinitionExt;
import org.violetmoon.zeta.client.config.screen.AbstractSectionInputScreen;
import org.violetmoon.zeta.client.config.widget.PencilButton;
import org.violetmoon.zeta.config.ChangeSet;
import org.violetmoon.zeta.config.SectionDefinition;
import org.violetmoon.zeta.config.ValueDefinition;

public class RGBClientDefinition
implements ClientDefinitionExt<SectionDefinition> {
    protected final ValueDefinition<Double> r;
    protected final ValueDefinition<Double> g;
    protected final ValueDefinition<Double> b;
    @Nullable
    protected final ValueDefinition<Double> a;

    public RGBClientDefinition(SectionDefinition def) {
        this.r = def.getValue("R", Double.class);
        this.g = def.getValue("G", Double.class);
        this.b = def.getValue("B", Double.class);
        this.a = def.getValue("A", Double.class);
        Preconditions.checkNotNull(this.r, (Object)"need an 'R' value in this section");
        Preconditions.checkNotNull(this.g, (Object)"need an 'G' value in this section");
        Preconditions.checkNotNull(this.b, (Object)"need an 'B' value in this section");
    }

    public String getSubtitle(ChangeSet changes, SectionDefinition def) {
        double r = (Double)changes.get(this.r);
        double g = (Double)changes.get(this.g);
        double b = (Double)changes.get(this.b);
        if (this.a == null) {
            return String.format("[%.1f, %.1f, %.1f]", r, g, b);
        }
        double a = (Double)changes.get(this.a);
        return String.format("[%.1f, %.1f, %.1f, %.1f]", r, g, b, a);
    }

    public void addWidgets(ZetaClient zc, Screen parent, ChangeSet changes, SectionDefinition def, Consumer<AbstractWidget> widgets) {
        RGBInputScreen newScreen = new RGBInputScreen(zc, parent, changes, def);
        widgets.accept((AbstractWidget)new PencilButton(zc, 230, 3, arg_0 -> RGBClientDefinition.lambda$addWidgets$0((Screen)newScreen, arg_0)));
    }

    private static /* synthetic */ void lambda$addWidgets$0(Screen newScreen, Button b1) {
        Minecraft.getInstance().setScreen(newScreen);
    }

    class RGBInputScreen
    extends AbstractSectionInputScreen {
        protected ExtendedSlider rslide;
        protected ExtendedSlider gslide;
        protected ExtendedSlider bslide;
        @Nullable
        protected ExtendedSlider aslide;
        private static final Component EMPTY = Component.empty();

        public RGBInputScreen(ZetaClient zc, Screen parent, ChangeSet changes, SectionDefinition def) {
            super(zc, parent, changes, def);
        }

        protected void init() {
            super.init();
            int w = 100;
            int p = 12;
            int x = this.width / 2 - 110;
            int y = 55;
            this.rslide = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)this.makeSliderPlease(x, y, w - p, 20, RGBClientDefinition.this.r, "R =", 0xFF0000));
            this.gslide = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)this.makeSliderPlease(x, y + 25, w - p, 20, RGBClientDefinition.this.g, "G = ", 65280));
            this.bslide = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)this.makeSliderPlease(x, y + 50, w - p, 20, RGBClientDefinition.this.b, "B = ", 30719));
            if (RGBClientDefinition.this.a != null) {
                this.aslide = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)this.makeSliderPlease(x, y + 75, w - p, 20, RGBClientDefinition.this.a, "A = ", 0xFFFFFF));
            }
            this.forceUpdateWidgets();
        }

        protected void forceUpdateWidgets() {
            this.rslide.setValue(((Double)this.changes.get(RGBClientDefinition.this.r)).doubleValue());
            this.gslide.setValue(((Double)this.changes.get(RGBClientDefinition.this.g)).doubleValue());
            this.bslide.setValue(((Double)this.changes.get(RGBClientDefinition.this.b)).doubleValue());
            if (this.aslide != null) {
                this.aslide.setValue(((Double)this.changes.get(RGBClientDefinition.this.a)).doubleValue());
            }
        }

        private ExtendedSlider makeSliderPlease(final int x, final int y, int width, int height, final ValueDefinition<Double> binding, final String label, final int labelColor) {
            return new ExtendedSlider(x, y + 50, width, height, EMPTY, EMPTY, 0.0, 1.0, 0.0, 0.0, 1, false){

                protected void applyValue() {
                    this.setValue(RGBInputScreen.this.snap(this));
                    RGBInputScreen.this.changes.set(binding, (Object)this.getValue());
                }

                public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                    super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
                    String displayVal = String.format("%.2f", this.getValue());
                    int valueColor = RGBInputScreen.this.changes.isDirty(binding) ? ChatFormatting.GOLD.getColor() : 0xFFFFFF;
                    guiGraphics.drawString(RGBInputScreen.this.font, displayVal, (float)x + (float)(this.getWidth() / 2 - RGBInputScreen.this.font.width(displayVal) / 2), (float)(y + 6), valueColor, true);
                    guiGraphics.drawString(RGBInputScreen.this.font, label, x - 20, y + 5, labelColor, true);
                }
            };
        }

        public void tick() {
            this.updateButtonStatus(true);
        }

        public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
            super.render(guiGraphics, mouseX, mouseY, partialTicks);
            int titleLeft = this.width / 2;
            guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)this.def.getTranslatedDisplayName(x$0 -> I18n.get((String)x$0, (Object[])new Object[0]))).withStyle(ChatFormatting.BOLD), titleLeft, 20, 0xFFFFFF);
            int cx = this.width / 2 + 20;
            int cy = 55;
            int size = 95;
            int color = RGBAColorConfig.forColor(this.rslide.getValue(), this.gslide.getValue(), this.bslide.getValue(), this.aslide == null ? 1.0 : this.aslide.getValue()).getColor();
            guiGraphics.fill(cx - 1, cy - 1, cx + size + 1, cy + size + 1, -16777216);
            guiGraphics.fill(cx, cy, cx + size, cy + size, -6710887);
            guiGraphics.fill(cx, cy, cx + size / 2, cy + size / 2, -10066330);
            guiGraphics.fill(cx + size / 2, cy + size / 2, cx + size, cy + size, -10066330);
            guiGraphics.fill(cx, cy, cx + size, cy + size, color);
        }

        private double snap(ExtendedSlider s) {
            double val = s.getValue();
            val = this.snap(val, 0.0, s);
            val = this.snap(val, 0.25, s);
            val = this.snap(val, 0.5, s);
            val = this.snap(val, 0.75, s);
            val = this.snap(val, 1.0, s);
            return val;
        }

        private double snap(double val, double target, ExtendedSlider s) {
            if (Math.abs(val - target) < 0.02) {
                s.setValue(target);
                return target;
            }
            return val;
        }
    }
}

