/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.capability;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.module.CrateModule;
import org.violetmoon.quark.base.handler.SortingHandler;

public class CrateItemHandler
extends ItemStackHandler {
    private boolean needsUpdate = false;
    private final int maxItems = CrateModule.maxItems;
    public int displayTotal = 0;
    public int displaySlots = 0;
    private int cachedTotal = -1;

    public CrateItemHandler() {
        super(CrateModule.maxItems);
    }

    private int getTotal() {
        if (this.cachedTotal != -1) {
            return this.cachedTotal;
        }
        int items = 0;
        for (ItemStack stack : this.stacks) {
            items += stack.getCount();
        }
        this.cachedTotal = items;
        return items;
    }

    private void changeTotal(ItemStack oldStack, ItemStack newStack) {
        int diff = newStack.getCount() - oldStack.getCount();
        if (diff != 0) {
            this.changeTotal(diff);
        }
    }

    private void changeTotal(int change) {
        this.cachedTotal = this.getTotal() + change;
    }

    public void recalculate() {
        if (!this.needsUpdate) {
            return;
        }
        this.needsUpdate = false;
        this.displayTotal = 0;
        this.displaySlots = 0;
        NonNullList newStacks = NonNullList.withSize((int)this.maxItems, (Object)ItemStack.EMPTY);
        int idx = 0;
        for (ItemStack stack : this.stacks) {
            if (stack.isEmpty()) continue;
            newStacks.set(idx, (Object)stack);
            this.displayTotal += stack.getCount();
            ++this.displaySlots;
            ++idx;
        }
        this.stacks = newStacks;
        this.cachedTotal = -1;
    }

    public void clear() {
        this.needsUpdate = false;
        this.stacks = NonNullList.withSize((int)this.maxItems, (Object)ItemStack.EMPTY);
        this.displayTotal = 0;
        this.displaySlots = 0;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.stacks) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void spill(Level level, BlockPos worldPosition) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>((Collection<ItemStack>)this.stacks);
        SortingHandler.mergeStacks(stacks);
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) continue;
            Containers.dropItemStack((Level)level, (double)worldPosition.getX(), (double)worldPosition.getY(), (double)worldPosition.getZ(), (ItemStack)stack);
        }
    }

    public int getSlotLimit(int slot) {
        ItemStack stackInSlot = this.getStackInSlot(slot);
        int total = this.getTotal();
        return Mth.clamp((int)(stackInSlot.getCount() + this.maxItems - total), (int)0, (int)64);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        ItemStack oldStack = ((ItemStack)this.stacks.get(slot)).copy();
        super.setStackInSlot(slot, stack);
        ItemStack newStack = ((ItemStack)this.stacks.get(slot)).copy();
        this.changeTotal(oldStack, newStack);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack oldStack = ((ItemStack)this.stacks.get(slot)).copy();
        ItemStack retStack = super.insertItem(slot, stack, simulate);
        ItemStack newStack = ((ItemStack)this.stacks.get(slot)).copy();
        if (!simulate) {
            this.changeTotal(oldStack, newStack);
        }
        return retStack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack oldStack = ((ItemStack)this.stacks.get(slot)).copy();
        ItemStack retStack = super.extractItem(slot, amount, simulate);
        ItemStack newStack = ((ItemStack)this.stacks.get(slot)).copy();
        if (!simulate) {
            this.changeTotal(oldStack, newStack);
        }
        return retStack;
    }

    public void onContentsChanged(int slot) {
        this.needsUpdate = true;
    }

    protected void onLoad() {
        this.needsUpdate = true;
        this.recalculate();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        ListTag items = new ListTag();
        for (ItemStack stack : this.stacks) {
            if (stack.isEmpty()) continue;
            items.add((Object)stack.save(provider, (Tag)new CompoundTag()));
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("stacks", (Tag)items);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.stacks = NonNullList.withSize((int)this.maxItems, (Object)ItemStack.EMPTY);
        ListTag items = nbt.getList("stacks", 10);
        for (int i = 0; i < items.size(); ++i) {
            this.stacks.set(i, (Object)ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)items.getCompound(i)));
        }
        this.onLoad();
    }
}

