/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block.be;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.violetmoon.quark.addons.oddities.magnetsystem.MagnetSystem;
import org.violetmoon.quark.addons.oddities.module.MagnetsModule;
import org.violetmoon.quark.api.IMagnetMoveAction;
import org.violetmoon.quark.base.Quark;

public class MagnetizedBlockBlockEntity
extends BlockEntity {
    private BlockState magnetState;
    private CompoundTag subTile;
    private Direction magnetFacing;
    private static final ThreadLocal<Direction> MOVING_ENTITY = ThreadLocal.withInitial(() -> null);
    private float progress;
    private float lastProgress;
    private long lastTicked;

    public MagnetizedBlockBlockEntity(BlockPos pos, BlockState state) {
        super(MagnetsModule.magnetizedBlockType, pos, state);
    }

    public MagnetizedBlockBlockEntity(BlockPos pos, BlockState state, BlockState magnetStateIn, CompoundTag subTileIn, Direction magnetFacingIn) {
        this(pos, state);
        this.magnetState = magnetStateIn;
        this.subTile = subTileIn;
        this.magnetFacing = magnetFacingIn;
    }

    public Direction getFacing() {
        return this.magnetFacing;
    }

    public float getProgress(float ticks) {
        if (ticks > 1.0f) {
            ticks = 1.0f;
        }
        return Mth.lerp((float)ticks, (float)this.lastProgress, (float)this.progress);
    }

    public float getOffsetX(float ticks) {
        return (float)this.magnetFacing.getStepX() * this.getExtendedProgress(this.getProgress(ticks));
    }

    public float getOffsetY(float ticks) {
        return (float)this.magnetFacing.getStepY() * this.getExtendedProgress(this.getProgress(ticks));
    }

    public float getOffsetZ(float ticks) {
        return (float)this.magnetFacing.getStepZ() * this.getExtendedProgress(this.getProgress(ticks));
    }

    private float getExtendedProgress(float partialTicks) {
        return partialTicks - 1.0f;
    }

    private void moveCollidedEntities(float progress) {
        List boundingBoxes;
        AABB containingBox;
        List entities;
        if (this.level == null) {
            return;
        }
        boolean sticky = Quark.ZETA.blockExtensions.get(this.magnetState).isStickyBlockZeta(this.magnetState);
        Direction direction = this.magnetFacing;
        double movement = progress - this.progress;
        VoxelShape collision = this.magnetState.getCollisionShape((BlockGetter)this.level, this.getBlockPos());
        if (!collision.isEmpty() && !(entities = this.level.getEntities(null, this.getMovementArea(containingBox = this.moveByPositionAndProgress(this.getEnclosingBox(boundingBoxes = collision.toAabbs())), direction, movement).minmax(containingBox))).isEmpty()) {
            for (Entity entity : entities) {
                AABB entityBox;
                AABB aList;
                AABB movementArea;
                if (entity.getPistonPushReaction() == PushReaction.IGNORE) continue;
                if (sticky) {
                    Vec3 motion = entity.getDeltaMovement();
                    double dX = motion.x;
                    double dY = motion.y;
                    double dZ = motion.z;
                    switch (direction.getAxis()) {
                        case X: {
                            dX = direction.getStepX();
                            break;
                        }
                        case Y: {
                            dY = direction.getStepY();
                            break;
                        }
                        case Z: {
                            dZ = direction.getStepZ();
                        }
                    }
                    entity.setDeltaMovement(dX, dY, dZ);
                }
                double motion = 0.0;
                Iterator iterator = boundingBoxes.iterator();
                while (!(!iterator.hasNext() || (movementArea = this.getMovementArea(this.moveByPositionAndProgress(aList = (AABB)iterator.next()), direction, movement)).intersects(entityBox = entity.getBoundingBox()) && (motion = Math.max(motion, this.getMovement(movementArea, direction, entityBox))) >= movement)) {
                }
                if (!(motion > 0.0)) continue;
                motion = Math.min(motion, movement) + 0.01;
                MOVING_ENTITY.set(direction);
                entity.move(MoverType.PISTON, new Vec3(motion * (double)direction.getStepX(), motion * (double)direction.getStepY(), motion * (double)direction.getStepZ()));
                MOVING_ENTITY.set(null);
            }
        }
    }

    private AABB getEnclosingBox(List<AABB> boxes) {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 1.0;
        double maxY = 1.0;
        double maxZ = 1.0;
        for (AABB bb : boxes) {
            minX = Math.min(bb.minX, minX);
            minY = Math.min(bb.minY, minY);
            minZ = Math.min(bb.minZ, minZ);
            maxX = Math.max(bb.maxX, maxX);
            maxY = Math.max(bb.maxY, maxY);
            maxZ = Math.max(bb.maxZ, maxZ);
        }
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private double getMovement(AABB bb1, Direction facing, AABB bb2) {
        return switch (facing.getAxis()) {
            case Direction.Axis.X -> MagnetizedBlockBlockEntity.getDeltaX(bb1, facing, bb2);
            case Direction.Axis.Z -> MagnetizedBlockBlockEntity.getDeltaZ(bb1, facing, bb2);
            default -> MagnetizedBlockBlockEntity.getDeltaY(bb1, facing, bb2);
        };
    }

    private AABB moveByPositionAndProgress(AABB bb) {
        double progress = this.getExtendedProgress(this.progress);
        return bb.move((double)this.worldPosition.getX() + progress * (double)this.magnetFacing.getStepX(), (double)this.worldPosition.getY() + progress * (double)this.magnetFacing.getStepY(), (double)this.worldPosition.getZ() + progress * (double)this.magnetFacing.getStepZ());
    }

    private AABB getMovementArea(AABB bb, Direction dir, double movement) {
        double d0 = movement * (double)dir.getAxisDirection().getStep();
        double d1 = Math.min(d0, 0.0);
        double d2 = Math.max(d0, 0.0);
        return switch (dir) {
            case Direction.WEST -> new AABB(bb.minX + d1, bb.minY, bb.minZ, bb.minX + d2, bb.maxY, bb.maxZ);
            case Direction.EAST -> new AABB(bb.maxX + d1, bb.minY, bb.minZ, bb.maxX + d2, bb.maxY, bb.maxZ);
            case Direction.DOWN -> new AABB(bb.minX, bb.minY + d1, bb.minZ, bb.maxX, bb.minY + d2, bb.maxZ);
            case Direction.NORTH -> new AABB(bb.minX, bb.minY, bb.minZ + d1, bb.maxX, bb.maxY, bb.minZ + d2);
            case Direction.SOUTH -> new AABB(bb.minX, bb.minY, bb.maxZ + d1, bb.maxX, bb.maxY, bb.maxZ + d2);
            default -> new AABB(bb.minX, bb.maxY + d1, bb.minZ, bb.maxX, bb.maxY + d2, bb.maxZ);
        };
    }

    private static double getDeltaX(AABB bb1, Direction facing, AABB bb2) {
        return facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? bb1.maxX - bb2.minX : bb2.maxX - bb1.minX;
    }

    private static double getDeltaY(AABB bb1, Direction facing, AABB bb2) {
        return facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? bb1.maxY - bb2.minY : bb2.maxY - bb1.minY;
    }

    private static double getDeltaZ(AABB bb1, Direction facing, AABB bb2) {
        return facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? bb1.maxZ - bb2.minZ : bb2.maxZ - bb1.minZ;
    }

    public BlockState getMagnetState() {
        return this.magnetState;
    }

    private IMagnetMoveAction getMoveAction() {
        Block block = this.magnetState.getBlock();
        if (block instanceof IMagnetMoveAction) {
            IMagnetMoveAction moveAction = (IMagnetMoveAction)block;
            return moveAction;
        }
        return MagnetSystem.getMoveAction(block);
    }

    public void finalizeContents(BlockState blockState) {
        IMagnetMoveAction action;
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        SoundType soundType = blockState.getSoundType();
        this.level.playSound(null, this.worldPosition, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) * 0.05f, soundType.getPitch() * 0.8f);
        BlockEntity newTile = this.getSubTile(this.worldPosition);
        if (newTile != null) {
            this.level.setBlockEntity(newTile);
        }
        if ((action = this.getMoveAction()) != null) {
            action.onMagnetMoved(this.level, this.worldPosition, this.magnetFacing, blockState, newTile);
        }
    }

    public BlockEntity getSubTile(BlockPos pos) {
        if (this.subTile != null && !this.subTile.isEmpty()) {
            CompoundTag tileData = this.subTile.copy();
            tileData.putInt("x", this.worldPosition.getX());
            tileData.putInt("y", this.worldPosition.getY());
            tileData.putInt("z", this.worldPosition.getZ());
            return BlockEntity.loadStatic((BlockPos)pos, (BlockState)this.magnetState, (CompoundTag)this.subTile, (HolderLookup.Provider)this.level.registryAccess());
        }
        return null;
    }

    public void clearMagnetTileEntity() {
        if (this.lastProgress < 1.0f && this.level != null) {
            this.lastProgress = this.progress = 1.0f;
            this.level.removeBlockEntity(this.worldPosition);
            this.setRemoved();
            if (this.level.getBlockState(this.worldPosition).getBlock() == MagnetsModule.magnetized_block) {
                BlockState blockstate = Block.updateFromNeighbourShapes((BlockState)this.magnetState, (LevelAccessor)this.level, (BlockPos)this.worldPosition);
                this.setAndUpdateBlock(blockstate, 3);
            }
        }
    }

    private void setAndUpdateBlock(BlockState blockstate, int flag) {
        Level level;
        if (this.level == null) {
            return;
        }
        this.level.setBlock(this.worldPosition, blockstate, flag);
        this.level.neighborChanged(this.worldPosition, blockstate.getBlock(), this.worldPosition);
        if ((blockstate.getBlock() instanceof ButtonBlock || blockstate.getBlock() instanceof BasePressurePlateBlock) && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            blockstate.tick(serverLevel, this.worldPosition, serverLevel.random);
            blockstate = this.level.getBlockState(this.worldPosition);
        }
        this.finalizeContents(blockstate);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MagnetizedBlockBlockEntity be) {
        be.tick();
    }

    public void tick() {
        if (this.level == null) {
            return;
        }
        this.lastTicked = this.level.getGameTime();
        this.lastProgress = this.progress;
        if (this.lastProgress >= 1.0f) {
            this.level.removeBlockEntity(this.worldPosition);
            this.setRemoved();
            if (this.magnetState != null && this.level.getBlockState(this.worldPosition).getBlock() == MagnetsModule.magnetized_block) {
                BlockState blockstate = Block.updateFromNeighbourShapes((BlockState)this.magnetState, (LevelAccessor)this.level, (BlockPos)this.worldPosition);
                if (blockstate.isAir()) {
                    this.level.setBlock(this.worldPosition, this.magnetState, 84);
                    Block.updateOrDestroy((BlockState)this.magnetState, (BlockState)blockstate, (LevelAccessor)this.level, (BlockPos)this.worldPosition, (int)3);
                } else {
                    if (blockstate.getValues().containsKey(BlockStateProperties.WATERLOGGED) && ((Boolean)blockstate.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                        blockstate = (BlockState)blockstate.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.FALSE);
                    }
                    this.setAndUpdateBlock(blockstate, 67);
                }
            }
        } else {
            float newProgress = this.progress + 0.5f;
            this.moveCollidedEntities(newProgress);
            this.progress = newProgress;
            if (this.progress >= 1.0f) {
                this.progress = 1.0f;
            }
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.magnetState = NbtUtils.readBlockState((HolderGetter)this.level.holderLookup(Registries.BLOCK), (CompoundTag)tag.getCompound("blockState"));
        this.magnetFacing = Direction.from3DDataValue((int)tag.getInt("facing"));
        this.lastProgress = this.progress = tag.getFloat("progress");
        this.subTile = tag.getCompound("subTile");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.writeNBTData(this.serializeAttachments(provider), false);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.writeNBTData(tag, true);
    }

    private CompoundTag writeNBTData(CompoundTag compound, boolean includeSubTile) {
        compound.put("blockState", (Tag)NbtUtils.writeBlockState((BlockState)this.magnetState));
        if (includeSubTile) {
            compound.put("subTile", (Tag)this.subTile);
        }
        compound.putInt("facing", this.magnetFacing.get3DDataValue());
        compound.putFloat("progress", this.lastProgress);
        return compound;
    }

    public VoxelShape getCollisionShape(BlockGetter world, BlockPos pos) {
        Direction direction = MOVING_ENTITY.get();
        if ((double)this.progress < 1.0 && direction == this.magnetFacing) {
            return Shapes.empty();
        }
        float progress = this.getExtendedProgress(this.progress);
        double dX = (float)this.magnetFacing.getStepX() * progress;
        double dY = (float)this.magnetFacing.getStepY() * progress;
        double dZ = (float)this.magnetFacing.getStepZ() * progress;
        return this.magnetState.getCollisionShape(world, pos).move(dX, dY, dZ);
    }

    public long getLastTicked() {
        return this.lastTicked;
    }
}

