/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.block;

import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.world.block.GlowShroomRingBlock;
import org.violetmoon.quark.content.world.module.GlimmeringWealdModule;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.MiscUtil;

public class HugeGlowShroomBlock
extends HugeMushroomBlock
implements IZetaBlock {
    private final ZetaModule module;
    private final boolean glowing;

    public HugeGlowShroomBlock(String name, ZetaModule module, boolean glowing) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM_BLOCK).lightLevel(b -> glowing ? 12 : 0).hasPostProcess((a, b, c) -> glowing).emissiveRendering((a, b, c) -> glowing).randomTicks().noOcclusion());
        this.module = module;
        this.glowing = glowing;
        this.module.zeta().registry.registerBlock((Block)this, name, true);
        CreativeTabManager.addToCreativeTab((ResourceKey)CreativeModeTabs.NATURAL_BLOCKS, (ItemLike)this);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return false;
    }

    public int getFlammabilityZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 0;
    }

    public int getFireSpreadSpeedZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 0;
    }

    public void animateTick(@NotNull BlockState stateIn, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        super.animateTick(stateIn, worldIn, pos, rand);
        BlockState below = worldIn.getBlockState(pos.below());
        if (this.glowing && rand.nextInt(10) == 0 && (below.isAir() || below.getBlock() == GlimmeringWealdModule.glow_shroom_ring)) {
            worldIn.addParticle((ParticleOptions)ParticleTypes.END_ROD, (double)pos.getX() + rand.nextDouble(), (double)pos.getY(), (double)pos.getZ() + rand.nextDouble(), 0.0, -0.05 - Math.random() * 0.05, 0.0);
        }
    }

    public static boolean place(LevelAccessor worldIn, RandomSource rand, BlockPos pos) {
        int i;
        int i2;
        Block block = worldIn.getBlockState(pos.below()).getBlock();
        if (block != Blocks.DEEPSLATE) {
            return false;
        }
        BlockPos placePos = pos;
        BlockState stem = GlimmeringWealdModule.glow_shroom_stem.defaultBlockState();
        BlockState ring = GlimmeringWealdModule.glow_shroom_ring.defaultBlockState();
        BlockState cap = (BlockState)GlimmeringWealdModule.glow_shroom_block.defaultBlockState().setValue((Property)DOWN, (Comparable)Boolean.valueOf(false));
        int stemHeight1 = 2;
        int stemHeight2 = rand.nextInt(4);
        boolean hasBigCap = rand.nextDouble() < 0.6;
        int totalHeight = stemHeight1 + stemHeight2 + (hasBigCap ? 2 : 1);
        int horizCheck = 2;
        for (i2 = -horizCheck; i2 < horizCheck + 1; ++i2) {
            for (int j = -horizCheck; j < horizCheck + 1; ++j) {
                for (int k = 1; k < totalHeight; ++k) {
                    if (worldIn.getBlockState(placePos.offset(i2, k, j)).isAir()) continue;
                    return false;
                }
            }
        }
        for (i2 = 0; i2 < stemHeight1; ++i2) {
            worldIn.setBlock(placePos, stem, 2);
            placePos = placePos.above();
        }
        if (stemHeight2 > 0) {
            Direction dir = MiscUtil.HORIZONTALS[rand.nextInt(MiscUtil.HORIZONTALS.length)];
            placePos = placePos.relative(dir);
        }
        for (int i3 = 0; i3 < stemHeight2; ++i3) {
            worldIn.setBlock(placePos, stem, 2);
            placePos = placePos.above();
        }
        int ringHeight = Math.min(2, stemHeight2);
        for (i = 0; i < ringHeight; ++i) {
            for (Direction ringDir : MiscUtil.HORIZONTALS) {
                worldIn.setBlock(placePos.relative(ringDir).relative(Direction.DOWN, i + 1), (BlockState)ring.setValue((Property)GlowShroomRingBlock.FACING, (Comparable)ringDir), 2);
            }
        }
        for (i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                worldIn.setBlock(placePos.offset(i, 0, j), cap, 2);
            }
        }
        if (hasBigCap) {
            worldIn.setBlock(placePos.above(), cap, 2);
        }
        return true;
    }

    public ZetaModule getModule() {
        return this.module;
    }

    public IZetaBlock setCondition(BooleanSupplier condition) {
        return this;
    }

    public boolean doesConditionApply() {
        return true;
    }
}

