/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.management.module;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.violetmoon.quark.base.network.message.ChangeHotbarMessage;
import org.violetmoon.zeta.client.event.load.ZKeyMapping;
import org.violetmoon.zeta.client.event.play.ZClientTick;
import org.violetmoon.zeta.client.event.play.ZInput;
import org.violetmoon.zeta.client.event.play.ZRenderGuiOverlay;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="management")
public class HotbarChangerModule
extends ZetaModule {
    private static final ResourceLocation WIDGETS = ResourceLocation.withDefaultNamespace((String)"textures/gui/widgets.png");
    private static final int MAX_HEIGHT = 90;
    public static float height = 0.0f;
    public static float oldHeight = 0.0f;
    public static int currentHeldItem = -1;
    public static boolean animating;
    public static boolean keyDown;
    public static boolean hotbarChangeOpen;
    public static boolean shifting;

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends HotbarChangerModule {
        private static KeyMapping changeHotbarKey;
        @Config
        public double animationTime = 7.0;

        @LoadEvent
        public void registerKeybinds(ZKeyMapping event) {
            changeHotbarKey = event.init("quark.keybind.change_hotbar", "z", "quark.gui.keygroup.misc");
        }

        @PlayEvent
        public void onMouseInput(ZInput.MouseButton event) {
            this.acceptInput(-1);
        }

        @PlayEvent
        public void onKeyInput(ZInput.Key event) {
            this.acceptInput(event.getKey());
        }

        @PlayEvent
        public void hudHeathPre(ZRenderGuiOverlay.PlayerHealth.Pre event) {
            float shift = -this.getRealHeight(event.getPartialTick().getGameTimeDeltaTicks()) + 22.0f;
            if (shift < 0.0f) {
                event.getGuiGraphics().pose().translate(0.0f, shift, 0.0f);
                shifting = true;
            }
        }

        @PlayEvent
        public void hudDebugTextPre(ZRenderGuiOverlay.DebugText.Pre event) {
            this.hudOverlay((ZRenderGuiOverlay)event);
        }

        @PlayEvent
        public void hudPotionIconsPre(ZRenderGuiOverlay.PotionIcons.Pre event) {
            this.hudOverlay((ZRenderGuiOverlay)event);
        }

        public void hudOverlay(ZRenderGuiOverlay event) {
            float shift = -this.getRealHeight(event.getPartialTick().getGameTimeDeltaTicks()) + 22.0f;
            if (shifting) {
                event.getGuiGraphics().pose().translate(0.0f, -shift, 0.0f);
                shifting = false;
            }
        }

        @PlayEvent
        public void hudPost(ZRenderGuiOverlay.Hotbar.Pre event) {
            int i;
            if (height <= 0.0f) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            GuiGraphics guiGraphics = event.getGuiGraphics();
            PoseStack matrix = guiGraphics.pose();
            matrix.pushPose();
            matrix.translate(0.0f, 0.0f, -500.0f);
            RenderSystem.enableDepthTest();
            Window res = event.getWindow();
            float realHeight = this.getRealHeight(event.getPartialTick().getGameTimeDeltaTicks());
            float xStart = (float)res.getGuiScaledWidth() / 2.0f - 91.0f;
            float yStart = (float)res.getGuiScaledHeight() - realHeight;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            for (i = 0; i < 3; ++i) {
                matrix.pushPose();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
                matrix.translate(xStart, yStart + (float)(i * 21), 0.0f);
                guiGraphics.blit(WIDGETS, 0, 0, 0, 0, 182, 22);
                matrix.popPose();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (i = 0; i < 3; ++i) {
                Object draw = Integer.toString(i + 1);
                KeyMapping key = mc.options.keyHotbarSlots[i];
                if (!key.isUnbound()) {
                    draw = key.getTranslatedKeyMessage().getString();
                }
                draw = String.valueOf(ChatFormatting.BOLD) + (String)draw;
                guiGraphics.drawString(mc.font, (String)draw, xStart - (float)mc.font.width((String)draw) - 2.0f, yStart + (float)(i * 21) + 7.0f, 0xFFFFFF, true);
            }
            for (i = 0; i < 27; ++i) {
                ItemStack invStack = player.getInventory().getItem(i + 9);
                int x = (int)(xStart + (float)(i % 9 * 20) + 3.0f);
                int y = (int)(yStart + (float)(i / 9 * 21) + 3.0f);
                guiGraphics.renderItem(invStack, x, y);
                guiGraphics.renderItemDecorations(mc.font, invStack, x, y);
            }
            matrix.popPose();
        }

        @PlayEvent
        public void clientTick(ZClientTick.End event) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                Inventory inventory = player.getInventory();
                if (currentHeldItem != -1 && inventory.selected != currentHeldItem) {
                    inventory.selected = currentHeldItem;
                    currentHeldItem = -1;
                }
            }
            if (hotbarChangeOpen && oldHeight < 1.0f) {
                oldHeight = height;
                height += 1.0f / (float)this.animationTime;
                height = Mth.clamp((float)height, (float)0.0f, (float)1.0f);
                animating = true;
            } else if (!hotbarChangeOpen && oldHeight > 0.0f) {
                oldHeight = height;
                height -= 1.0f / (float)this.animationTime;
                height = Mth.clamp((float)height, (float)0.0f, (float)1.0f);
                animating = true;
            } else {
                animating = false;
            }
        }

        private void acceptInput(int currInput) {
            Minecraft mc = Minecraft.getInstance();
            boolean down = changeHotbarKey.isDown();
            boolean wasDown = keyDown;
            keyDown = down;
            if (mc.isWindowActive()) {
                if (down && !wasDown) {
                    hotbarChangeOpen = !hotbarChangeOpen;
                } else if (hotbarChangeOpen) {
                    for (int i = 0; i < 3; ++i) {
                        if (!this.isKeyDownOrFallback(mc.options.keyHotbarSlots[i], 49 + i, currInput)) continue;
                        PacketDistributor.sendToServer((CustomPacketPayload)new ChangeHotbarMessage(i + 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        hotbarChangeOpen = false;
                        currentHeldItem = mc.player.getInventory().selected;
                        return;
                    }
                }
            }
        }

        private boolean isKeyDownOrFallback(KeyMapping key, int input, int currInput) {
            if (key.isUnbound()) {
                return currInput != -1 && input == currInput;
            }
            return key.isDown();
        }

        private float getRealHeight(float part) {
            return Mth.lerp((float)part, (float)oldHeight, (float)height) * 90.0f;
        }
    }
}

