/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import aurelienribon.tweenengine.Tween;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.violetmoon.quark.base.handler.ContributorRewardHandler;
import org.violetmoon.quark.base.network.message.RequestEmoteMessage;
import org.violetmoon.quark.content.tweaks.client.emote.CustomEmoteIconResourcePack;
import org.violetmoon.quark.content.tweaks.client.emote.EmoteBase;
import org.violetmoon.quark.content.tweaks.client.emote.EmoteDescriptor;
import org.violetmoon.quark.content.tweaks.client.emote.EmoteHandler;
import org.violetmoon.quark.content.tweaks.client.emote.ModelAccessor;
import org.violetmoon.quark.content.tweaks.client.screen.NotButton;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.client.event.load.ZKeyMapping;
import org.violetmoon.zeta.client.event.play.ZInput;
import org.violetmoon.zeta.client.event.play.ZRenderGuiOverlay;
import org.violetmoon.zeta.client.event.play.ZRenderLiving;
import org.violetmoon.zeta.client.event.play.ZScreen;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZModulesReady;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="tweaks")
public class EmotesModule
extends ZetaModule {
    private static final Set<String> DEFAULT_EMOTE_NAMES = ImmutableSet.of((Object)"no", (Object)"yes", (Object)"wave", (Object)"salute", (Object)"cheer", (Object)"clap", (Object[])new String[]{"think", "point", "shrug", "headbang", "weep", "facepalm"});
    private static final Set<String> PATREON_EMOTES = ImmutableSet.of((Object)"dance", (Object)"tpose", (Object)"dab", (Object)"jet", (Object)"exorcist", (Object)"zombie", (Object[])new String[0]);
    public static final int EMOTE_BUTTON_WIDTH = 25;
    public static final int EMOTES_PER_ROW = 3;
    @Config(description="The enabled default emotes. Remove from this list to disable them. You can also re-order them, if you feel like it.")
    public static List<String> enabledEmotes = Lists.newArrayList(DEFAULT_EMOTE_NAMES);
    @Config(description="The list of Custom Emotes to be loaded.\nWatch the tutorial on Custom Emotes to learn how to make your own: https://youtu.be/ourHUkan6aQ")
    public static List<String> customEmotes = Lists.newArrayList();
    @Config(description="Enable this to make custom emotes read the file every time they're triggered so you can edit on the fly.\nDO NOT ship enabled this in a modpack, please.")
    public static boolean customEmoteDebug = false;
    @Config
    public static int buttonShiftX = 0;
    @Config
    public static int buttonShiftY = 0;
    public static boolean emotesVisible = false;
    public static File emotesDir;

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends EmotesModule {
        public static CustomEmoteIconResourcePack resourcePack;
        private static Map<KeyMapping, String> emoteKeybinds;
        private static NotButton emoteToggleButton;
        private static List<NotButton> emoteButtons;
        boolean theMouseIsPressedNowThankYou = false;

        @LoadEvent
        public void onReady(ZModulesReady e) {
            Minecraft mc = Minecraft.getInstance();
            if (mc == null) {
                return;
            }
            emotesDir = new File(mc.gameDirectory, "/config/quark_emotes");
            if (!emotesDir.exists()) {
                emotesDir.mkdirs();
            }
        }

        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            Tween.registerAccessor(HumanoidModel.class, ModelAccessor.INSTANCE);
        }

        @LoadEvent
        public void registerKeybinds(ZKeyMapping event) {
            int sortOrder = 0;
            emoteKeybinds = new HashMap<KeyMapping, String>();
            for (String s : DEFAULT_EMOTE_NAMES) {
                emoteKeybinds.put(event.init("quark.emote." + s, null, "quark.gui.keygroup.emote", sortOrder++), s);
            }
            for (String s : PATREON_EMOTES) {
                emoteKeybinds.put(event.init("quark.keybind.patreon_emote." + s, null, "quark.gui.keygroup.emote", sortOrder++), s);
            }
        }

        @LoadEvent
        public void configChanged(ZConfigChanged e) {
            EmoteHandler.clearEmotes();
            for (String s : enabledEmotes) {
                if (!DEFAULT_EMOTE_NAMES.contains(s)) continue;
                EmoteHandler.addEmote(s);
            }
            for (String s : PATREON_EMOTES) {
                EmoteHandler.addEmote(s);
            }
            for (String s : customEmotes) {
                EmoteHandler.addCustomEmote(s);
            }
        }

        @PlayEvent
        public void mouseStupidAwfulBad(ZInput.MouseButton event) {
            if (event.getButton() == 0) {
                if (event.getAction() == 1) {
                    this.theMouseIsPressedNowThankYou = true;
                } else if (event.getAction() == 0) {
                    this.theMouseIsPressedNowThankYou = false;
                }
            }
        }

        @PlayEvent
        public void initGui(ZScreen.Init.Post event) {
            if (event.getScreen() instanceof ChatScreen) {
                emoteButtons.clear();
                Window window = Minecraft.getInstance().getWindow();
                int windowWidth = window.getGuiScaledWidth();
                int windowHeight = window.getGuiScaledHeight();
                TreeMap<Integer, List> descriptorSorting = new TreeMap<Integer, List>();
                for (EmoteDescriptor desc : EmoteHandler.emoteMap.values()) {
                    if (desc.getTier() > ContributorRewardHandler.localPatronTier) continue;
                    List descriptors = descriptorSorting.computeIfAbsent(desc.getTier(), k -> new LinkedList());
                    descriptors.add(desc);
                }
                int rows = 0;
                int row = 0;
                Minecraft mc = Minecraft.getInstance();
                boolean expandDown = (Boolean)mc.options.showSubtitles().get();
                Set keys = descriptorSorting.keySet();
                Iterator iterator = keys.iterator();
                while (iterator.hasNext()) {
                    int tier = (Integer)iterator.next();
                    List descriptors = (List)descriptorSorting.get(tier);
                    if (descriptors == null) continue;
                    rows += descriptors.size() / 3;
                    if (descriptors.size() % 3 == 0) continue;
                    ++rows;
                }
                int buttonX = buttonShiftX;
                int buttonY = (expandDown ? 2 : windowHeight - 40) + buttonShiftY;
                Iterator iterator2 = keys.iterator();
                while (iterator2.hasNext()) {
                    int tier = (Integer)iterator2.next();
                    int rowPos = 0;
                    int tierRow = 0;
                    List descriptors = (List)descriptorSorting.get(tier);
                    if (descriptors != null) {
                        for (EmoteDescriptor desc : descriptors) {
                            int rowSize = Math.min(descriptors.size() - tierRow * 3, 3);
                            int x = buttonX + windowWidth - 2 - 100 + (((rowPos + 1) * 2 + 3 - rowSize) * 25 / 2 + 1);
                            int y = buttonY + 25 * (rows - row) * (expandDown ? 1 : -1);
                            NotButton button = new NotButton(x, y, 24, 24, desc, () -> PacketDistributor.sendToServer((CustomPacketPayload)new RequestEmoteMessage(desc.getRegistryName()), (CustomPacketPayload[])new CustomPacketPayload[0]));
                            emoteButtons.add(button);
                            if (++rowPos != 3) continue;
                            ++tierRow;
                            ++row;
                            rowPos = 0;
                        }
                    }
                    if (rowPos == 0) continue;
                    ++row;
                }
                emoteToggleButton = new NotButton(buttonX + windowWidth - 2 - 75, buttonY, 75, 20, Component.translatable((String)"quark.gui.button.emotes"), () -> emotesVisible ^= true);
                event.getScreen().renderables.add((gfx, mouseX, mouseY, partialTicks) -> {
                    emoteToggleButton.draw(gfx, mouseX, mouseY, this.theMouseIsPressedNowThankYou);
                    if (emotesVisible) {
                        for (NotButton b : emoteButtons) {
                            b.draw(gfx, mouseX, mouseY, this.theMouseIsPressedNowThankYou);
                        }
                    }
                });
            }
        }

        @PlayEvent
        public void onKeyInput(ZInput.Key event) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.isWindowActive()) {
                for (KeyMapping key : emoteKeybinds.keySet()) {
                    if (!key.isDown()) continue;
                    String emote = emoteKeybinds.get(key);
                    PacketDistributor.sendToServer((CustomPacketPayload)new RequestEmoteMessage(emote), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return;
                }
            }
        }

        @PlayEvent
        public void drawCrosshair(ZRenderGuiOverlay.Crosshair.Post event) {
            Minecraft mc = Minecraft.getInstance();
            Window res = event.getWindow();
            GuiGraphics guiGraphics = event.getGuiGraphics();
            PoseStack stack = guiGraphics.pose();
            EmoteBase emote = EmoteHandler.getPlayerEmote((Player)mc.player);
            if (emote != null && emote.timeDone < emote.totalTime) {
                ResourceLocation resource = emote.desc.texture;
                int x = res.getGuiScaledWidth() / 2 - 16;
                int y = res.getGuiScaledHeight() / 2 - 60;
                float transparency = 1.0f;
                float tween = 5.0f;
                if (emote.timeDone < tween) {
                    transparency = emote.timeDone / tween;
                } else if (emote.timeDone > emote.totalTime - tween) {
                    transparency = (emote.totalTime - emote.timeDone) / tween;
                }
                stack.pushPose();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                guiGraphics.blit(resource, x, y, 0.0f, 0.0f, 32, 32, 32, 32);
                RenderSystem.enableBlend();
                String name = I18n.get((String)emote.desc.getTranslationKey(), (Object[])new Object[0]);
                guiGraphics.drawString(mc.font, name, (float)res.getGuiScaledWidth() / 2.0f - (float)mc.font.width(name) / 2.0f, (float)(y + 34), 0xFFFFFF + ((int)(transparency * 255.0f) << 24), true);
                stack.popPose();
            }
        }

        @PlayEvent
        public void preRenderLiving(ZRenderLiving.PreHighest event) {
            Entity entity = event.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                EmoteHandler.preRender(event.getPoseStack(), player);
            }
        }

        @PlayEvent
        public void postRenderLiving(ZRenderLiving.PostLowest event) {
            Entity entity = event.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                EmoteHandler.postRender(event.getPoseStack(), player);
            }
        }

        static {
            emoteButtons = new ArrayList<NotButton>();
        }
    }
}

