/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.mixin.mixins;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.violetmoon.quark.content.experimental.module.GameNerfsModule;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorChunkAccess;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorSinglePoolElement;

@Mixin(value={JigsawPlacement.class})
public class ChunkGeneratorMixin {
    @WrapOperation(method={"addPieces(Lnet/minecraft/world/level/levelgen/structure/Structure$GenerationContext;Lnet/minecraft/core/Holder;Ljava/util/Optional;ILnet/minecraft/core/BlockPos;ZLjava/util/Optional;I)Ljava/util/Optional;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/levelgen/structure/pools/StructureTemplatePool;getRandomTemplate(Lnet/minecraft/util/RandomSource;)Lnet/minecraft/world/level/levelgen/structure/pools/StructurePoolElement;")})
    private static StructurePoolElement quark$reduceVillagesFrequency(StructureTemplatePool instance, RandomSource pRandom, Operation<StructurePoolElement> operation, @Local(argsOnly=true) Holder<StructureTemplatePool> structure, @Local(ordinal=0, argsOnly=true) Optional<ResourceLocation> startPool, @Local(argsOnly=true) BlockPos pos, @Local(argsOnly=true) Structure.GenerationContext context) {
        ProtoChunk pc;
        LevelHeightAccessor levelHeightAccessor;
        String id;
        Optional<String> left;
        StructurePoolElement original = (StructurePoolElement)operation.call(new Object[]{instance, pRandom});
        if (GameNerfsModule.villageSpawnNerf && (left = ChunkGeneratorMixin.quark$getPoolId(original)).isPresent() && (id = left.get()).contains("village") && id.contains("town_centers") && (levelHeightAccessor = context.heightAccessor()) instanceof ProtoChunk && (levelHeightAccessor = ((AccessorChunkAccess)(pc = (ProtoChunk)levelHeightAccessor)).getLevelHeightAccessor()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)levelHeightAccessor;
            BlockPos spawn = sl.getSharedSpawnPos();
            double spawnDistanceSq = spawn.distSqr((Vec3i)pos);
            RandomSource r = RandomSource.create((long)pos.asLong());
            float maxDist = GameNerfsModule.villageSpawnNerfDistance;
            double probability = 1.0 - spawnDistanceSq / (double)(maxDist * maxDist);
            if (r.nextDouble() < probability) {
                int tries = 0;
                while (!id.contains("zombie")) {
                    if (tries++ > 4) {
                        return EmptyPoolElement.INSTANCE;
                    }
                    original = (StructurePoolElement)operation.call(new Object[]{instance, pRandom});
                    Optional<String> s = ChunkGeneratorMixin.quark$getPoolId(original);
                    if (s.isPresent()) {
                        id = s.get();
                    }
                    ++tries;
                }
            }
        }
        return original;
    }

    @Unique
    private static Optional<String> quark$getPoolId(StructurePoolElement le) {
        if (le instanceof AccessorSinglePoolElement) {
            AccessorSinglePoolElement se = (AccessorSinglePoolElement)le;
            Optional left = se.getTemplate().left();
            return left.map(ResourceLocation::getPath);
        }
        return Optional.empty();
    }
}

