/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.management.module;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.UUID;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.network.message.ShareItemC2SMessage;
import org.violetmoon.zeta.client.event.play.ZScreen;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="management")
public class ItemSharingModule
extends ZetaModule {
    @Config(description="In ticks.")
    @Config.Min(value=0.0)
    private static int cooldown = 100;
    @Config
    public static boolean renderItemsInChat = true;
    private static final Object2IntMap<UUID> lastSendTimes = new Object2IntOpenHashMap();

    public static boolean canShare(UUID sender, MinecraftServer server) {
        int lastSend;
        if (!((ItemSharingModule)Quark.ZETA.modules.get(ItemSharingModule.class)).isEnabled()) {
            return false;
        }
        int now = server.getTickCount();
        if (now - (lastSend = lastSendTimes.getOrDefault((Object)sender, -cooldown)) >= cooldown) {
            lastSendTimes.put((Object)sender, now);
            return true;
        }
        return false;
    }

    public static MutableComponent createStackComponent(ItemStack stack) {
        return ItemSharingModule.createStackComponent(stack, (MutableComponent)stack.getDisplayName());
    }

    public static MutableComponent createStackComponent(ItemStack stack, MutableComponent component) {
        if (!Quark.ZETA.modules.isEnabled(ItemSharingModule.class) || !renderItemsInChat) {
            return component;
        }
        Style style = component.getStyle();
        if (stack.getCount() > 64) {
            ItemStack copyStack = stack.copy();
            copyStack.setCount(64);
            style = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(copyStack)));
            component.withStyle(style);
        }
        MutableComponent out = Component.literal((String)"   ");
        out.setStyle(style);
        return out.append((Component)component);
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends ItemSharingModule {
        public static float alphaValue = 1.0f;
        private static long lastClientShare = -1L;

        public static boolean requestShare() {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null || !Screen.hasShiftDown()) {
                return false;
            }
            Screen screen = mc.screen;
            if (!(screen instanceof AbstractContainerScreen)) {
                return false;
            }
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            for (GuiEventListener c : gui.children()) {
                EditBox tf;
                if (!(c instanceof EditBox) || !(tf = (EditBox)c).isFocused()) continue;
                return false;
            }
            Slot slot = gui.getSlotUnderMouse();
            if (slot == null) {
                return false;
            }
            ItemStack stack = slot.getItem();
            if (stack.isEmpty()) {
                return false;
            }
            if (mc.level.getGameTime() - lastClientShare <= (long)cooldown) {
                return false;
            }
            lastClientShare = mc.level.getGameTime();
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ShareItemC2SMessage(stack));
            return true;
        }

        @PlayEvent
        public void onKeyInput(ZScreen.KeyPressed.Pre event) {
            KeyMapping key = this.getChatKey();
            if (key.getKey().getType() == InputConstants.Type.KEYSYM && event.getKeyCode() == key.getKey().getValue()) {
                event.setCanceled(Client.requestShare());
            }
        }

        @PlayEvent
        public void onMouseInput(ZScreen.MouseButtonPressed.Pre event) {
            KeyMapping key = this.getChatKey();
            int btn = event.getButton();
            if (key.getKey().getType() == InputConstants.Type.MOUSE && btn != 0 && btn == key.getKey().getValue()) {
                event.setCanceled(Client.requestShare());
            }
        }

        public static void renderItemForMessage(GuiGraphics guiGraphics, FormattedCharSequence sequence, float x, float y, int color) {
            if (!Quark.ZETA.modules.isEnabled(ItemSharingModule.class) || !renderItemsInChat) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            StringBuilder before = new StringBuilder();
            int halfSpace = mc.font.width(" ") / 2;
            sequence.accept((counter_, style, character) -> {
                String sofar = before.toString();
                if (sofar.endsWith("  ")) {
                    Client.render(mc, guiGraphics, sofar.substring(0, sofar.length() - 2), character == 32 ? 0.0f : (float)(-halfSpace), x, y, style, color);
                    return false;
                }
                before.append((char)character);
                return true;
            });
        }

        private static void render(Minecraft mc, GuiGraphics guiGraphics, String before, float extraShift, float x, float y, Style style, int color) {
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            PoseStack pose = guiGraphics.pose();
            HoverEvent hoverEvent = style.getHoverEvent();
            if (hoverEvent != null && hoverEvent.getAction() == HoverEvent.Action.SHOW_ITEM) {
                ItemStack stack;
                HoverEvent.ItemStackInfo contents = (HoverEvent.ItemStackInfo)hoverEvent.getValue(HoverEvent.Action.SHOW_ITEM);
                ItemStack itemStack = stack = contents != null ? contents.getItemStack() : ItemStack.EMPTY;
                if (stack.isEmpty()) {
                    stack = new ItemStack((ItemLike)Blocks.BARRIER);
                }
                float shift = (float)mc.font.width(before) + extraShift;
                if (a > 0.0f) {
                    alphaValue = a;
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().mulPose(pose.last().pose());
                    guiGraphics.pose().translate(shift + x, y, 0.0f);
                    guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
                    guiGraphics.renderItem(stack, 0, 0);
                    guiGraphics.pose().popPose();
                    RenderSystem.applyModelViewMatrix();
                    alphaValue = 1.0f;
                }
            }
        }

        private KeyMapping getChatKey() {
            return Minecraft.getInstance().options.keyChat;
        }
    }
}

