/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.management.module;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.config.QuarkGeneralConfig;
import org.violetmoon.quark.base.handler.SimilarBlockTypeHandler;
import org.violetmoon.quark.base.network.message.ScrollOnBundleMessage;
import org.violetmoon.quark.content.management.client.screen.HeldShulkerBoxScreen;
import org.violetmoon.quark.content.management.inventory.HeldShulkerBoxContainer;
import org.violetmoon.quark.content.management.inventory.HeldShulkerBoxMenu;
import org.violetmoon.quark.mixin.mixins.client.accessor.AccessorCustomCreativeSlot;
import org.violetmoon.quark.mixin.mixins.client.accessor.AccessorMenuScreens;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.client.event.play.ZRenderTooltip;
import org.violetmoon.zeta.client.event.play.ZScreen;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.util.RegistryUtil;

@ZetaLoadModule(category="management")
public class ExpandedItemInteractionsModule
extends ZetaModule {
    @Config
    public static boolean enableArmorInteraction = true;
    @Config(flag="shulker_box_interaction")
    public static boolean enableShulkerBoxInteraction = true;
    @Config(flag="lava_interaction")
    public static boolean enableLavaInteraction = true;
    @Config
    public static boolean allowOpeningShulkerBoxes = true;
    @Config(flag="allow_rotating_bundles")
    public static boolean allowRotatingBundles = true;
    @Hint(value="lava_interaction")
    Item lava_bucket = Items.LAVA_BUCKET;
    @Hint(value="allow_rotating_bundles", key="rotating_bundles")
    Item bundle = Items.BUNDLE;
    @Hint(value="shulker_box_interaction", key="shulker_box_right_click")
    List<Item> shulkers;
    private static boolean staticEnabled = false;
    public static MenuType<HeldShulkerBoxMenu> heldShulkerBoxMenuType;

    @LoadEvent
    public final void register(ZRegister event) {
        heldShulkerBoxMenuType = IMenuTypeExtension.create(HeldShulkerBoxMenu::fromNetwork);
        Quark.ZETA.registry.register(heldShulkerBoxMenuType, "held_shulker_box", Registries.MENU);
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.isEnabled();
        this.shulkers = RegistryUtil.massRegistryGet(QuarkGeneralConfig.shulkerBoxes, (Registry)BuiltInRegistries.ITEM);
    }

    public static boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (!staticEnabled || action == ClickAction.PRIMARY) {
            return false;
        }
        ItemStack stackAt = slot.getItem();
        if (enableShulkerBoxInteraction && ExpandedItemInteractionsModule.shulkerOverride(stack, stackAt, slot, action, player, false)) {
            if (player.containerMenu != null) {
                player.containerMenu.slotsChanged(slot.container);
            }
            return true;
        }
        return false;
    }

    public static boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack incoming, Slot slot, ClickAction action, Player player, SlotAccess accessor) {
        if (!staticEnabled || action == ClickAction.PRIMARY) {
            return false;
        }
        if (enableLavaInteraction && ExpandedItemInteractionsModule.lavaBucketOverride(stack, incoming, slot, action, player)) {
            return true;
        }
        if (enableArmorInteraction && ExpandedItemInteractionsModule.armorOverride(stack, incoming, slot, action, player, false)) {
            return true;
        }
        return enableShulkerBoxInteraction && ExpandedItemInteractionsModule.shulkerOverride(stack, incoming, slot, action, player, true);
    }

    public static void scrollOnBundle(ServerPlayer player, int containerId, int stateId, int slotNum, double scrollDelta) {
        if (!staticEnabled || !allowRotatingBundles) {
            return;
        }
        if (-0.1 <= scrollDelta && scrollDelta <= 0.1) {
            return;
        }
        player.resetLastActionTime();
        if (player.containerMenu.containerId == containerId) {
            if (player.isSpectator()) {
                player.containerMenu.sendAllDataToRemote();
            } else if (!player.containerMenu.stillValid((Player)player)) {
                Quark.LOG.debug("Player {} interacted with invalid menu {}", (Object)player, (Object)player.containerMenu);
            } else {
                boolean flag = stateId != player.containerMenu.getStateId();
                player.containerMenu.suppressRemoteUpdates();
                Slot under = player.containerMenu.getSlot(slotNum);
                if (under != null) {
                    ItemStack underStack = under.getItem();
                    ExpandedItemInteractionsModule.rotateBundle(underStack, scrollDelta);
                }
                player.containerMenu.resumeRemoteUpdates();
                if (flag) {
                    player.containerMenu.broadcastFullState();
                } else {
                    player.containerMenu.broadcastChanges();
                }
            }
        }
    }

    private static void rotateBundle(ItemStack stack, double scrollDelta) {
        List items;
        BundleContents bundleContents;
        if (stack.is(Items.BUNDLE) && (bundleContents = (BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS)) != null && (items = (List)bundleContents.items()).size() > 1) {
            ArrayList<ItemStack> rotatedItems = new ArrayList<ItemStack>();
            if (scrollDelta < 0.0) {
                rotatedItems.add((ItemStack)items.get(items.size() - 1));
                for (int i = 0; i < items.size() - 1; ++i) {
                    rotatedItems.add((ItemStack)items.get(i));
                }
            } else {
                for (int i = 1; i < items.size(); ++i) {
                    rotatedItems.add((ItemStack)items.get(i));
                }
                rotatedItems.add((ItemStack)items.get(0));
            }
            stack.set(DataComponents.BUNDLE_CONTENTS, (Object)new BundleContents(rotatedItems));
        }
    }

    private static boolean armorOverride(ItemStack stack, ItemStack incoming, Slot slot, ClickAction action, Player player, boolean simulate) {
        if (incoming.isEmpty()) {
            if (stack.getCount() > 1) {
                return false;
            }
            EquipmentSlot equipSlot = null;
            Item item = stack.getItem();
            if (item instanceof ArmorItem) {
                ArmorItem armor = (ArmorItem)item;
                equipSlot = armor.getEquipmentSlot();
            } else if (stack.getItem() instanceof ElytraItem) {
                equipSlot = EquipmentSlot.CHEST;
            }
            if (equipSlot != null) {
                ItemStack currArmor = player.getItemBySlot(equipSlot);
                if (slot.mayPickup(player) && (slot.mayPlace(currArmor) || currArmor.isEmpty()) && (currArmor.isEmpty() || EnchantmentHelper.getTagEnchantmentLevel((Holder)player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.BINDING_CURSE), (ItemStack)currArmor) <= 0 && currArmor != stack)) {
                    if (!simulate) {
                        player.setItemSlot(equipSlot, stack.copy());
                        if (currArmor.isEmpty()) {
                            slot.remove(1);
                        } else {
                            slot.set(currArmor.copy());
                        }
                        slot.onQuickCraft(stack, currArmor);
                        slot.onTake(player, stack);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean canTrashItem(ItemStack stack, ItemStack incoming, Slot slot, Player player) {
        return stack.getItem() == Items.LAVA_BUCKET && !incoming.isEmpty() && !player.getAbilities().instabuild && slot.allowModification(player) && slot.mayPlace(stack) && !incoming.has(DataComponents.FIRE_RESISTANT) && !SimilarBlockTypeHandler.isShulkerBox(incoming);
    }

    public static boolean lavaBucketOverride(ItemStack stack, ItemStack incoming, Slot slot, ClickAction action, Player player) {
        if (ExpandedItemInteractionsModule.canTrashItem(stack, incoming, slot, player)) {
            incoming.setCount(0);
            if (!player.level().isClientSide) {
                player.level().playSound(null, player.blockPosition(), SoundEvents.LAVA_EXTINGUISH, SoundSource.PLAYERS, 0.25f, 2.0f + (float)Math.random());
            }
            return true;
        }
        return false;
    }

    public static boolean canOpenShulkerBox(ItemStack stack, ItemStack incoming, Slot slot, Player player) {
        return incoming.isEmpty() && allowOpeningShulkerBoxes && (!player.hasContainerOpen() || player.containerMenu instanceof InventoryMenu) && slot.container == player.getInventory() && SimilarBlockTypeHandler.isShulkerBox(stack) && slot.mayPickup(player);
    }

    private static boolean shulkerOverride(ItemStack shulkerStack, ItemStack incoming, Slot slot, ClickAction action, Player player, boolean isStackedOnMe) {
        ItemStack finished;
        if (shulkerStack.getCount() != 1) {
            return false;
        }
        if (isStackedOnMe && ExpandedItemInteractionsModule.canOpenShulkerBox(shulkerStack, incoming, slot, player)) {
            int lockedSlot = slot.getSlotIndex();
            if (player instanceof ServerPlayer) {
                ServerPlayer splayer = (ServerPlayer)player;
                HeldShulkerBoxContainer container = new HeldShulkerBoxContainer((Player)splayer, lockedSlot);
                player.openMenu((MenuProvider)container);
            } else {
                player.playSound(SoundEvents.SHULKER_BOX_OPEN, 1.0f, 1.0f);
            }
            return true;
        }
        if (!incoming.isEmpty() && ExpandedItemInteractionsModule.tryAddToShulkerBox(player, shulkerStack, incoming, slot, true, true, isStackedOnMe) != null && (finished = ExpandedItemInteractionsModule.tryAddToShulkerBox(player, shulkerStack, incoming, slot, false, isStackedOnMe, isStackedOnMe)) != null) {
            if (isStackedOnMe) {
                player.playSound(SoundEvents.SHULKER_BOX_OPEN, 0.7f, 1.5f);
                slot.set(finished);
            }
            return true;
        }
        return false;
    }

    public static BlockEntity getShulkerBoxEntity(ItemStack shulkerBox, RegistryAccess access) {
        CompoundTag cmp = ((CustomData)shulkerBox.get(DataComponents.BLOCK_ENTITY_DATA)).copyTag();
        if (cmp.contains("LootTable")) {
            return null;
        }
        BlockEntity te = null;
        cmp = cmp.copy();
        cmp.putString("id", "minecraft:shulker_box");
        if (shulkerBox.getItem() instanceof BlockItem) {
            Block shulkerBoxBlock = Block.byItem((Item)shulkerBox.getItem());
            BlockState defaultState = shulkerBoxBlock.defaultBlockState();
            if (shulkerBoxBlock instanceof EntityBlock && (te = ((EntityBlock)shulkerBoxBlock).newBlockEntity(BlockPos.ZERO, defaultState)) != null) {
                te.loadWithComponents(cmp, (HolderLookup.Provider)access);
            }
        }
        return te;
    }

    private static ItemStack tryAddToShulkerBox(Player player, ItemStack shulkerBox, ItemStack stack, Slot slot, boolean simulate, boolean useCopy, boolean allowDump) {
        IItemHandler iItemHandler;
        Optional<IItemHandler> handlerHolder;
        if (!SimilarBlockTypeHandler.isShulkerBox(shulkerBox) || !slot.mayPickup(player)) {
            return null;
        }
        BlockEntity tile = ExpandedItemInteractionsModule.getShulkerBoxEntity(shulkerBox, player.level().registryAccess());
        if (tile != null && tile.getLevel() != null && (handlerHolder = Optional.ofNullable((IItemHandler)tile.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), null))).isPresent() && (iItemHandler = handlerHolder.orElse((IItemHandler)new ItemStackHandler())) instanceof IItemHandler) {
            ItemStack result;
            boolean did;
            IItemHandler iItemHandler2;
            Optional<IItemHandler> otherHolder;
            BlockEntity otherShulker;
            IItemHandler handler = iItemHandler;
            if (SimilarBlockTypeHandler.isShulkerBox(stack) && allowDump && (otherShulker = ExpandedItemInteractionsModule.getShulkerBoxEntity(stack, player.level().registryAccess())) != null && otherShulker.getLevel() != null && (otherHolder = Optional.ofNullable((IItemHandler)otherShulker.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, otherShulker.getBlockPos(), null))).isPresent() && (iItemHandler2 = otherHolder.orElse((IItemHandler)new ItemStackHandler())) instanceof IItemHandler) {
                IItemHandler otherHandler = iItemHandler2;
                boolean any = false;
                for (int i = 0; i < otherHandler.getSlots(); ++i) {
                    ItemStack result2;
                    ItemStack inserting = otherHandler.extractItem(i, 64, true);
                    if (inserting.isEmpty() || !(result2 = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)inserting, (boolean)true)).isEmpty() && result2.getCount() == inserting.getCount()) continue;
                    if (simulate) {
                        return shulkerBox;
                    }
                    ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)otherHandler.extractItem(i, inserting.getCount() - result2.getCount(), false), (boolean)false);
                    any = true;
                }
                if (any) {
                    ItemStack workStack = useCopy ? shulkerBox.copy() : shulkerBox;
                    workStack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tile.saveWithId((HolderLookup.Provider)player.level().registryAccess())));
                    stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)otherShulker.saveWithId((HolderLookup.Provider)player.level().registryAccess())));
                    if (slot.mayPlace(workStack)) {
                        return workStack;
                    }
                }
            }
            boolean bl = did = (result = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.copy(), (boolean)simulate)).isEmpty() || result.getCount() != stack.getCount();
            if (did) {
                ItemStack workStack;
                ItemStack itemStack = workStack = useCopy ? shulkerBox.copy() : shulkerBox;
                if (!simulate) {
                    stack.setCount(result.getCount());
                }
                workStack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tile.saveWithId((HolderLookup.Provider)player.level().registryAccess())));
                if (slot.mayPlace(workStack)) {
                    return workStack;
                }
            }
        }
        return null;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends ExpandedItemInteractionsModule {
        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            AccessorMenuScreens.invokeRegister(heldShulkerBoxMenuType, HeldShulkerBoxScreen::new);
        }

        @PlayEvent
        public void gatherTooltip(ZRenderTooltip.GatherComponents.Low event) {
            AbstractContainerScreen containerGui;
            if (!(enableArmorInteraction || enableShulkerBoxInteraction && allowOpeningShulkerBoxes)) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            Screen gui = mc.screen;
            if (mc.player != null && gui instanceof AbstractContainerScreen && (containerGui = (AbstractContainerScreen)gui).getMenu().getCarried().isEmpty()) {
                Slot under = containerGui.getSlotUnderMouse();
                if (under == null || under instanceof AccessorCustomCreativeSlot) {
                    return;
                }
                ItemStack underStack = under.getItem();
                if (event.getItemStack() == underStack) {
                    if (enableArmorInteraction && ExpandedItemInteractionsModule.armorOverride(underStack, ItemStack.EMPTY, under, ClickAction.SECONDARY, (Player)mc.player, true)) {
                        event.getTooltipElements().add(Either.left((Object)Component.translatable((String)"quark.misc.equip_armor").withStyle(ChatFormatting.YELLOW)));
                    } else if (enableShulkerBoxInteraction && Client.canOpenShulkerBox(underStack, ItemStack.EMPTY, under, (Player)mc.player)) {
                        event.getTooltipElements().add(Either.left((Object)Component.translatable((String)"quark.misc.open_shulker").withStyle(ChatFormatting.YELLOW)));
                    }
                }
            }
        }

        @PlayEvent
        public void onDrawScreen(ZScreen.Render.Post event) {
            AbstractContainerScreen containerGui;
            ItemStack held;
            Minecraft mc = Minecraft.getInstance();
            Screen gui = mc.screen;
            GuiGraphics guiGraphics = event.getGuiGraphics();
            if (mc.player != null && gui instanceof AbstractContainerScreen && !(held = (containerGui = (AbstractContainerScreen)gui).getMenu().getCarried()).isEmpty()) {
                Slot under = containerGui.getSlotUnderMouse();
                if (under == null || under instanceof AccessorCustomCreativeSlot) {
                    return;
                }
                ItemStack underStack = under.getItem();
                int x = event.getMouseX();
                int y = event.getMouseY();
                if (enableLavaInteraction && ExpandedItemInteractionsModule.canTrashItem(underStack, held, under, (Player)mc.player)) {
                    guiGraphics.renderComponentTooltip(mc.font, List.of(Component.translatable((String)"quark.misc.trash_item").withStyle(ChatFormatting.RED)), x, y);
                } else if (enableShulkerBoxInteraction && ExpandedItemInteractionsModule.tryAddToShulkerBox((Player)mc.player, underStack, held, under, true, true, true) != null) {
                    guiGraphics.renderComponentTooltip(mc.font, List.of(Component.translatable((String)(SimilarBlockTypeHandler.isShulkerBox(held) ? "quark.misc.merge_shulker_box" : "quark.misc.insert_shulker_box")).withStyle(ChatFormatting.YELLOW)), x, y, underStack);
                } else if (enableShulkerBoxInteraction && SimilarBlockTypeHandler.isShulkerBox(underStack)) {
                    guiGraphics.renderComponentTooltip(mc.font, Screen.getTooltipFromItem((Minecraft)mc, (ItemStack)underStack), x, y, underStack);
                }
            }
        }

        @PlayEvent
        public void onScroll(ZScreen.MouseScrolled.Pre event) {
            if (!allowRotatingBundles) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            Screen gui = mc.screen;
            double scrollDelta = event.getScrollDeltaY();
            if (mc.player != null && gui instanceof AbstractContainerScreen) {
                List items;
                BundleContents bundleContents;
                AbstractContainerScreen containerGui = (AbstractContainerScreen)gui;
                Slot under = containerGui.getSlotUnderMouse();
                if (under == null || under instanceof AccessorCustomCreativeSlot) {
                    return;
                }
                ItemStack underStack = under.getItem();
                if (underStack.is(Items.BUNDLE) && (bundleContents = (BundleContents)underStack.get(DataComponents.BUNDLE_CONTENTS)) != null && (items = (List)bundleContents.items()).size() > 1) {
                    AbstractContainerMenu menu = containerGui.getMenu();
                    event.setCanceled(true);
                    if (scrollDelta < -0.1 || scrollDelta > 0.1) {
                        ExpandedItemInteractionsModule.rotateBundle(underStack, scrollDelta);
                        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ScrollOnBundleMessage(menu.containerId, menu.getStateId(), under.index, scrollDelta));
                    }
                }
            }
        }
    }
}

