/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.block.be;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DispenserMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.automation.block.FeedingTroughBlock;
import org.violetmoon.quark.content.automation.module.FeedingTroughModule;
import org.violetmoon.zeta.util.MiscUtil;

public class FeedingTroughBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> stacks = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private long internalRng = 0L;

    public FeedingTroughBlockEntity(BlockPos pos, BlockState state) {
        super(FeedingTroughModule.blockEntityType, pos, state);
    }

    public void updateFoodHolder(Animal mob, Ingredient temptations, FakePlayer foodHolder) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (!temptations.test(stack) || !mob.isFood(stack)) continue;
            Inventory inventory = foodHolder.getInventory();
            inventory.items.set(inventory.selected, (Object)stack);
            Vec3 througPos = new Vec3((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ()).add(0.5, -1.0, 0.5);
            Vec3 mobPosition = mob.position();
            Vec3 direction = mobPosition.subtract(througPos);
            Vec2 angles = MiscUtil.getMinecraftAnglesLossy((Vec3)direction);
            Vec3 newPos = Vec3.ZERO;
            float maxDist = 5.0f;
            newPos = direction.lengthSqr() > (double)(maxDist * maxDist) ? mobPosition.add(direction.normalize().scale((double)(-maxDist))) : througPos.add(direction.normalize().scale(-1.0));
            foodHolder.moveTo(newPos.x, newPos.y, newPos.z, angles.y, angles.x);
            return;
        }
    }

    public FeedResult tryFeedingAnimal(Animal animal) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (!animal.isFood(stack)) continue;
            SoundEvent soundEvent = animal.getEatingSound(stack);
            if (soundEvent != null) {
                animal.playSound(soundEvent, 0.5f + 0.5f * (float)this.level.random.nextInt(2), (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f + 1.0f);
            }
            this.addItemParticles((Entity)animal, stack, 16);
            stack.shrink(1);
            this.setChanged();
            if (this.getSpecialRand().nextDouble() < FeedingTroughModule.loveChance) {
                List animalsAround = this.level.getEntitiesOfClass(Animal.class, new AABB(this.worldPosition).inflate(FeedingTroughModule.range));
                if (animalsAround.size() <= FeedingTroughModule.maxAnimals) {
                    animal.setInLove(null);
                }
                return FeedResult.SECS;
            }
            return FeedResult.FED;
        }
        return FeedResult.NONE;
    }

    public void setChanged() {
        super.setChanged();
        BlockState state = this.getBlockState();
        if (this.level != null && state.getBlock() instanceof FeedingTroughBlock) {
            boolean shouldBeFull;
            boolean full = (Boolean)state.getValue((Property)FeedingTroughBlock.FULL);
            boolean bl = shouldBeFull = !this.isEmpty();
            if (full != shouldBeFull) {
                this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)FeedingTroughBlock.FULL, (Comparable)Boolean.valueOf(shouldBeFull)), 2);
            }
        }
    }

    private void addItemParticles(Entity entity, ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 direction = new Vec3(((double)entity.level().random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            direction = direction.xRot(-entity.getXRot() * ((float)Math.PI / 180));
            direction = direction.yRot(-entity.getYRot() * ((float)Math.PI / 180));
            double yVelocity = (double)(-entity.level().random.nextFloat()) * 0.6 - 0.3;
            Vec3 position = new Vec3(((double)entity.level().random.nextFloat() - 0.5) * 0.3, yVelocity, 0.6);
            Vec3 entityPos = entity.position();
            position = position.xRot(-entity.getXRot() * ((float)Math.PI / 180));
            position = position.yRot(-entity.getYRot() * ((float)Math.PI / 180));
            position = position.add(entityPos.x, entityPos.y + (double)entity.getEyeHeight(), entityPos.z);
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), position.x, position.y, position.z, 1, direction.x, direction.y + 0.05, direction.z, 0.0);
                continue;
            }
            if (this.level == null) continue;
            this.level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), position.x, position.y, position.z, direction.x, direction.y + 0.05, direction.z);
        }
    }

    private Random getSpecialRand() {
        Random specialRand = new Random(this.internalRng);
        this.internalRng = specialRand.nextLong();
        return specialRand;
    }

    public int getContainerSize() {
        return 9;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"quark.container.feeding_trough");
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.internalRng = tag.getLong("rng");
        this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.stacks, (HolderLookup.Provider)provider);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putLong("rng", this.internalRng);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.stacks, (HolderLookup.Provider)provider);
        }
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> items) {
        this.stacks = items;
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int id, @NotNull Inventory playerInventory) {
        return new DispenserMenu(this, id, playerInventory, (Container)this){

            public MenuType<?> getType() {
                return FeedingTroughModule.menuType;
            }
        };
    }

    public static enum FeedResult {
        FED,
        SECS,
        NONE;

    }
}

