/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.network.message;

import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.violetmoon.quark.base.network.QuarkNetwork;
import org.violetmoon.quark.base.network.message.ShareItemS2CMessage;
import org.violetmoon.quark.content.management.module.ItemSharingModule;

public record ShareItemC2SMessage(ItemStack toShare) implements ServerboundPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ShareItemC2SMessage> STREAM_CODEC = ItemStack.STREAM_CODEC.map(ShareItemC2SMessage::new, ShareItemC2SMessage::toShare);

    public void handle(ServerPlayer player) {
        MinecraftServer server = player.getServer();
        if (server == null) {
            return;
        }
        if (!ItemSharingModule.canShare(player.getUUID(), server)) {
            return;
        }
        Component senderName = player.getDisplayName();
        CatnipServices.NETWORK.sendToAllClients((CustomPacketPayload)new ShareItemS2CMessage(player.getUUID(), senderName, this.toShare));
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return QuarkNetwork.SHARE_ITEM_C2S_MESSAGE;
    }
}

