/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.tesseract.graph.standard;

import it.unimi.dsi.fastutil.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.gtreimagined.tesseract.graph.IElement;
import org.gtreimagined.tesseract.graph.IGrid;
import org.gtreimagined.tesseract.graph.INetwork;
import org.gtreimagined.tesseract.graph.INotableElement;
import org.gtreimagined.tesseract.graph.IRouteTracker;
import org.gtreimagined.tesseract.graph.IRoutingInfo;

public abstract class StandardNetwork<TSelf extends StandardNetwork<TSelf, TElement, TNotableElement, TRoutingInfo, TGrid>, TElement extends IElement<TElement, TNotableElement, TRoutingInfo, TSelf, TGrid>, TNotableElement extends INotableElement<TNotableElement, TRoutingInfo, TElement, TSelf, TGrid>, TRoutingInfo extends IRoutingInfo<TRoutingInfo>, TGrid extends IGrid<TGrid, TElement, TNotableElement, TRoutingInfo, TSelf>>
implements INetwork<TSelf, TElement, TNotableElement, TRoutingInfo, TGrid> {
    public final HashSet<TElement> elements = new HashSet();
    public final HashMap<Class<?>, Collection<Object>> components = new HashMap();
    public IRouteTracker<TRoutingInfo, TNotableElement, TElement, TSelf, TGrid> routeTracker = this.createRouteTracker();
    private boolean networkChanged = false;

    protected StandardNetwork() {
    }

    protected abstract IRouteTracker<TRoutingInfo, TNotableElement, TElement, TSelf, TGrid> createRouteTracker();

    @Override
    public void addElement(TElement element) {
        this.elements.add(element);
        this.routeTracker.onElementAdded(element);
        this.networkChanged = true;
        for (Pair<Class<?>, Object> component : element.getComponents()) {
            this.addComponentImpl((Class)component.left(), component.right());
        }
    }

    @Override
    public void removeElement(TElement element) {
        this.elements.remove(element);
        this.routeTracker.onElementRemoved(element);
        this.networkChanged = true;
        if (element != null && element.getNetwork() == this) {
            for (Pair<Class<?>, Object> component : element.getComponents()) {
                this.removeComponentImpl((Class)component.left(), component.right());
            }
        }
    }

    private void addComponentImpl(Class<?> iface, Object impl) {
        this.components.computeIfAbsent(iface, x -> new HashSet()).add(impl);
    }

    public <TIface, TImpl extends TIface> void addComponent(Class<TIface> iface, TImpl impl) {
        this.addComponentImpl(iface, impl);
    }

    public void tick() {
        if (this.networkChanged) {
            this.networkChanged = false;
            this.routeTracker.updateEdges();
        }
    }

    private void removeComponentImpl(Class<?> iface, Object impl) {
        Collection<Object> s = this.components.get(iface);
        if (s != null) {
            s.remove(impl);
            if (s.isEmpty()) {
                this.components.remove(iface);
            }
        }
    }

    public <TIface, TImpl extends TIface> void removeComponent(Class<TIface> iface, TImpl impl) {
        this.removeComponentImpl(iface, impl);
    }

    public <TIface> Collection<TIface> getComponents(Class<TIface> iface) {
        return this.components.getOrDefault(iface, Collections.emptyList());
    }

    @Override
    public Collection<TElement> getElements() {
        return this.elements;
    }

    @Override
    public IRouteTracker<TRoutingInfo, TNotableElement, TElement, TSelf, TGrid> getTracker() {
        return this.routeTracker;
    }
}

