package org.gtreimagined.tesseract.fabric;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import team.reborn.energy.api.EnergyStorage;
import org.gtreimagined.tesseract.Tesseract;
import org.gtreimagined.tesseract.TesseractConfig;
import org.gtreimagined.tesseract.api.context.TesseractItemContext;
import org.gtreimagined.tesseract.api.fabric.TesseractLookups;
import org.gtreimagined.tesseract.api.fabric.wrapper.ContainerItemContextWrapper;
import org.gtreimagined.tesseract.api.eu.EUGrid;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;
import org.gtreimagined.tesseract.api.eu.IEnergyItem;
import org.gtreimagined.tesseract.api.hu.HUGrid;

import java.util.function.BiFunction;

public class TesseractImpl extends Tesseract implements ModInitializer {

    public TesseractImpl(){
    }

    private static void onWorldUnload(MinecraftServer server, class_3218 world) {
        if (world == null) return;
        //FE_ENERGY.removeWorld((World) e.getWorld());
        //GraphWrapper.getWrappers().forEach(g -> g.removeWorld(world));
        firstTick.remove(world);
    }

    private static void onEndTick(class_3218 l) {
        if (!hadFirstTick(l)) {
            firstTick.add(l);
            //GraphWrapper.getWrappers().forEach(t -> t.onFirstTick(l));
        }
        if (Tesseract.HEALTH_CHECK_TIME > 0 && l.method_8510() % Tesseract.HEALTH_CHECK_TIME == 0) {
            //GraphWrapper.getWrappers().forEach(GraphWrapper::healthCheck);
        }
    }

    private static void onStartServerTick(){
        EUGrid.INSTANCE.tick();
        HUGrid.INSTANCE.tick();
    }

    private static void onStartTick(class_3218 l) {
        if (!hadFirstTick(l)) {
            firstTick.add(l);
            //GraphWrapper.getWrappers().forEach(t -> t.onFirstTick(l));
        }
        //GraphWrapper.getWrappers().forEach(t -> t.tick(l));
        if (Tesseract.HEALTH_CHECK_TIME > 0 && l.method_8510() % Tesseract.HEALTH_CHECK_TIME == 0) {
            //GraphWrapper.getWrappers().forEach(GraphWrapper::healthCheck);
        }
    }

    private static void onServerStopping(MinecraftServer s) {
        firstTick.clear();
        //FE_ENERGY.clear();
        //GraphWrapper.getWrappers().forEach(GraphWrapper::clear);
    }

    @Override
    public void onInitialize() {
        Tesseract.init();
        TesseractConfig.createConfig();
        ServerLifecycleEvents.SERVER_STOPPING.register(TesseractImpl::onServerStopping);
        ServerTickEvents.START_WORLD_TICK.register(TesseractImpl::onStartTick);
        ServerTickEvents.START_SERVER_TICK.register(server -> onStartServerTick());
        ServerTickEvents.END_WORLD_TICK.register(TesseractImpl::onEndTick);
        ServerWorldEvents.UNLOAD.register((TesseractImpl::onWorldUnload));
        TesseractLookups.ENERGY_HANDLER_ITEM.registerFallback((s, c) -> {
            TesseractItemContext context = new ContainerItemContextWrapper(c);
            if (s.method_7909() instanceof IEnergyItem energyItem && energyItem.canCreate(context)){
                return energyItem.createEnergyHandler(context);
            }
            return null;
        });
    }

    /*public static <T extends BlockEntity> void registerTRETile(BiFunction<T, Direction, IEnergyHandler> euFunction, BiFunction<T, Direction, EnergyContainer> rfFunction, BlockEntityType<T> type){
        EnergyStorage.SIDED.registerForBlockEntity((blockEntity, direction) -> {
            IEnergyHandler handler = euFunction.apply(blockEntity, direction);
            if (handler != null) return (EnergyStorage) handler;
            EnergyContainer node = rfFunction.apply(blockEntity, direction);
            if (node != null) return node instanceof EnergyStorage storage ? storage : new FabricBlockEnergyContainer(node, node instanceof Updatable<?> ? (Updatable<BlockEntity>) node : b -> {}, blockEntity);
            return null;
        }, type);
    }*/

    public static void registerTREItem(BiFunction<class_1799, ContainerItemContext, IEnergyHandler> function, class_1792 type){
        EnergyStorage.ITEM.registerForItems((stack, context) -> (EnergyStorage) function.apply(stack, context), type);
    }
}
