/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.tesseract.util;

import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class Pos {
    protected long value;
    protected int x;
    protected int y;
    protected int z;
    private static final int[] MULTIPLY_DE_BRUIJN_BIT_POSITION = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};
    private static final int NUM_X_BITS;
    private static final int NUM_Z_BITS;
    private static final int NUM_Y_BITS;
    private static final long X_MASK;
    private static final long Y_MASK;
    private static final long Z_MASK;
    private static final int Z_FIELD;
    private static final int Y_FIELD = 0;
    private static final int X_FIELD;

    private static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    private static int smallestEncompassingPowerOfTwo(int value) {
        int i = value - 1;
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i + 1;
    }

    private static int log2DeBruijn(int value) {
        value = Pos.isPowerOfTwo(value) ? value : Pos.smallestEncompassingPowerOfTwo(value);
        return MULTIPLY_DE_BRUIJN_BIT_POSITION[(int)((long)value * 125613361L >> 27) & 0x1F];
    }

    public static long offset(long value, class_2350 dir) {
        int x = Pos.unpackX(value) + dir.method_10148();
        int y = Pos.unpackY(value) + dir.method_10164();
        int z = Pos.unpackZ(value) + dir.method_10165();
        return Pos.packAll(x, y, z);
    }

    public static long sub(long value, long other) {
        int x = Pos.unpackX(value) - Pos.unpackX(other);
        int y = Pos.unpackY(value) - Pos.unpackY(other);
        int z = Pos.unpackZ(value) - Pos.unpackZ(other);
        return Pos.packAll(x, y, z);
    }

    public static class_2350 subToDir(long value, long other) {
        long direction = Pos.sub(value, other);
        return class_2350.method_16365((int)Pos.unpackX(direction), (int)Pos.unpackY(direction), (int)Pos.unpackZ(direction));
    }

    public static class_2350 blockPosToDir(class_2338 value, class_2338 other) {
        return class_2350.method_16365((int)(value.method_10263() - other.method_10263()), (int)(value.method_10264() - other.method_10264()), (int)(value.method_10260() - other.method_10260()));
    }

    private static int log2(int value) {
        return Pos.log2DeBruijn(value) - (Pos.isPowerOfTwo(value) ? 0 : 1);
    }

    public Pos() {
    }

    public Pos(long value) {
        this.x = Pos.unpackX(value);
        this.y = Pos.unpackY(value);
        this.z = Pos.unpackZ(value);
        this.value = value;
    }

    public Pos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.value = Pos.packAll(x, y, z);
    }

    public Pos(Pos pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
        this.value = pos.value;
    }

    public Pos set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.value = Pos.packAll(x, y, z);
        return this;
    }

    public Pos set(Pos pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
        this.value = pos.value;
        return this;
    }

    public Pos add(int x, int y, int z) {
        return this.set(this.x + x, this.y + y, this.z + z);
    }

    public Pos add(Pos pos) {
        return this.set(this.x + pos.x, this.y + pos.y, this.z + pos.z);
    }

    public Pos sub(int x, int y, int z) {
        return this.set(this.x - x, this.y - y, this.z - z);
    }

    public Pos sub(Pos pos) {
        return this.set(this.x - pos.x, this.y - pos.y, this.z - pos.z);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public long asLong() {
        return this.value;
    }

    public Pos offset(class_2350 dir) {
        return new Pos(this.x + dir.method_10148(), this.y + dir.method_10164(), this.z + dir.method_10165());
    }

    public Pos offset(class_2350 dir, int n) {
        return n == 0 ? this : new Pos(this.x + dir.method_10148() * n, this.y + dir.method_10164() * n, this.z + dir.method_10165() * n);
    }

    public static int unpackX(long value) {
        return (int)(value << 64 - X_FIELD - NUM_X_BITS >> 64 - NUM_X_BITS);
    }

    public static int unpackY(long value) {
        return (int)(value << 64 - NUM_Y_BITS >> 64 - NUM_Y_BITS);
    }

    public static int unpackZ(long value) {
        return (int)(value << 64 - Z_FIELD - NUM_Z_BITS >> 64 - NUM_Z_BITS);
    }

    public static long packAll(int x, int y, int z) {
        long i = 0L;
        i |= ((long)x & X_MASK) << X_FIELD;
        i |= ((long)y & Y_MASK) << 0;
        return i |= ((long)z & Z_MASK) << Z_FIELD;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Pos) {
            return this.value == ((Pos)o).value;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    static {
        NUM_Z_BITS = NUM_X_BITS = 1 + Pos.log2(Pos.smallestEncompassingPowerOfTwo(30000000));
        NUM_Y_BITS = 64 - NUM_X_BITS - NUM_Z_BITS;
        X_MASK = (1L << NUM_X_BITS) - 1L;
        Y_MASK = (1L << NUM_Y_BITS) - 1L;
        Z_MASK = (1L << NUM_Z_BITS) - 1L;
        Z_FIELD = NUM_Y_BITS;
        X_FIELD = NUM_Y_BITS + NUM_Z_BITS;
    }
}

