/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.tesseract.graph.standard;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gtreimagined.tesseract.graph.GraphUtils;
import org.gtreimagined.tesseract.graph.IElement;
import org.gtreimagined.tesseract.graph.IGrid;
import org.gtreimagined.tesseract.graph.INotableElement;
import org.gtreimagined.tesseract.graph.IRoutingInfo;
import org.gtreimagined.tesseract.graph.standard.StandardNetwork;

public abstract class StandardGrid<TSelf extends StandardGrid<TSelf, TElement, TNotableElement, TRoutingInfo, TNetwork>, TElement extends IElement<TElement, TNotableElement, TRoutingInfo, TNetwork, TSelf>, TNotableElement extends INotableElement<TNotableElement, TRoutingInfo, TElement, TNetwork, TSelf>, TRoutingInfo extends IRoutingInfo<TRoutingInfo>, TNetwork extends StandardNetwork<TNetwork, TElement, TNotableElement, TRoutingInfo, TSelf>>
implements IGrid<TSelf, TElement, TNotableElement, TRoutingInfo, TNetwork> {
    public static final Logger LOGGER = LogManager.getLogger((String)"Standard Factory Network");
    public final HashSet<TNetwork> networks = new HashSet();
    public final HashSet<TElement> vertices = new HashSet();
    public final SetMultimap<TElement, TElement> edges = MultimapBuilder.hashKeys().hashSetValues().build();

    protected StandardGrid() {
    }

    @Override
    public void addElement(TElement element) {
        this.removeElement(element);
        this.vertices.add(element);
        this.updateNeighbours(element);
        HashSet discovered = new HashSet();
        HashSet networks = new HashSet();
        long pre = System.nanoTime();
        this.walkAdjacency(element, discovered, networks, false);
        long post = System.nanoTime();
        if (GraphUtils.INSTANCE.isDevEnvironment()) {
            LOGGER.info("Walked adjacent elements in " + (double)(post - pre) / 1000.0 + " us");
        }
        if (networks.isEmpty()) {
            TNetwork network = this.createNetwork();
            this.networks.add(network);
            for (IElement e : discovered) {
                if (e.getNetwork() == network) continue;
                e.setNetwork(network);
                ((StandardNetwork)network).addElement((IElement)e);
            }
        } else if (networks.size() == 1) {
            StandardNetwork network = (StandardNetwork)networks.iterator().next();
            for (IElement e : discovered) {
                if (e.getNetwork() == network) continue;
                e.setNetwork(network);
                network.addElement(e);
            }
        } else {
            Iterator iter = networks.iterator();
            StandardNetwork biggestNetwork = (StandardNetwork)iter.next();
            while (iter.hasNext()) {
                StandardNetwork network = (StandardNetwork)iter.next();
                if (network.getElements().size() <= biggestNetwork.getElements().size()) continue;
                biggestNetwork = network;
            }
            pre = System.nanoTime();
            for (StandardNetwork network : networks) {
                if (network == biggestNetwork) continue;
                this.subsume((TNetwork)biggestNetwork, (TNetwork)network);
            }
            post = System.nanoTime();
            if (GraphUtils.INSTANCE.isDevEnvironment()) {
                LOGGER.info("Subsumed " + (networks.size() - 1) + " networks in " + (double)(post - pre) / 1000.0 + " us");
            }
            for (IElement e : discovered) {
                if (e.getNetwork() == biggestNetwork) continue;
                e.setNetwork(biggestNetwork);
                biggestNetwork.addElement(e);
            }
        }
    }

    @Override
    public void addElementQuietly(TNetwork network, TElement element) {
        this.vertices.add(element);
        element.setNetwork(network);
        ((StandardNetwork)network).addElement(element);
    }

    public void tick() {
        for (StandardNetwork network : this.networks) {
            network.tick();
        }
    }

    protected abstract TNetwork createNetwork();

    @Override
    public void removeElement(TElement element) {
        if (!this.vertices.contains(element)) {
            return;
        }
        this.vertices.remove(element);
        Set neighbours = this.edges.removeAll(element);
        StandardNetwork network = (StandardNetwork)element.getNetwork();
        network.removeElement(element);
        element.setNetwork(null);
        if (network.getElements().isEmpty()) {
            network.onNetworkRemoved();
            this.networks.remove(network);
            return;
        }
        for (IElement neighbour : neighbours) {
            this.updateNeighbours(neighbour);
        }
        if (neighbours.size() <= 1) {
            return;
        }
        HashSet neighbouringClumps = new HashSet();
        HashSet discovered = new HashSet();
        long pre = System.nanoTime();
        for (Object neighbour : neighbours) {
            if (discovered.contains(neighbour)) continue;
            HashSet hashSet = new HashSet();
            this.walkAdjacency(neighbour, hashSet, null, true);
            neighbouringClumps.add(hashSet);
            discovered.addAll(hashSet);
        }
        if (neighbouringClumps.size() <= 1) {
            return;
        }
        HashSet biggestClump = null;
        for (HashSet hashSet : neighbouringClumps) {
            if (biggestClump != null && hashSet.size() <= biggestClump.size()) continue;
            biggestClump = hashSet;
        }
        for (HashSet hashSet : neighbouringClumps) {
            if (hashSet == biggestClump) continue;
            for (IElement e : hashSet) {
                network.removeElement(e);
            }
            TNetwork newNetwork = this.createNetwork();
            for (IElement e : hashSet) {
                e.setNetwork(newNetwork);
                ((StandardNetwork)newNetwork).addElement((IElement)e);
            }
            this.networks.add(newNetwork);
        }
        long post = System.nanoTime();
        if (GraphUtils.INSTANCE.isDevEnvironment()) {
            LOGGER.info("Split network in " + (double)(post - pre) / 1000.0 + " us (added " + (neighbouringClumps.size() - 1) + " new networks)");
        }
    }

    @Override
    public void removeElementQuietly(TElement element) {
        if (!this.vertices.contains(element)) {
            return;
        }
        ((StandardNetwork)element.getNetwork()).removeElement(element);
        this.vertices.remove(element);
        element.setNetwork(null);
        for (IElement neighbour : this.edges.removeAll(element)) {
            this.updateNeighbours(neighbour);
        }
    }

    @Override
    public void subsume(TNetwork dest, TNetwork source) {
        for (IElement element : new ArrayList(((StandardNetwork)source).getElements())) {
            ((StandardNetwork)source).removeElement((IElement)element);
            element.setNetwork(dest);
            ((StandardNetwork)dest).addElement((IElement)element);
        }
        source.onNetworkRemoved();
        this.networks.remove(source);
    }

    private void walkAdjacency(TElement start, HashSet<TElement> discovered, HashSet<TNetwork> networks, boolean recurseIntoNetworked) {
        ArrayDeque<TElement> queue = new ArrayDeque<TElement>();
        queue.add(start);
        while (!queue.isEmpty()) {
            IElement current = (IElement)queue.removeFirst();
            if (!discovered.add(current)) continue;
            if (networks != null) {
                networks.add((StandardNetwork)current.getNetwork());
            }
            if (current != start && !recurseIntoNetworked && current.getNetwork() != null) continue;
            queue.addAll(this.edges.get((Object)current));
        }
        if (networks != null) {
            networks.remove(null);
        }
    }

    public void updateNeighbours(TElement element) {
        this.updateNeighbours(element, new HashSet());
    }

    private void updateNeighbours(TElement element, HashSet<TElement> updated) {
        if (!updated.add(element)) {
            return;
        }
        HashSet neighbours = new HashSet();
        element.getNeighbours(neighbours);
        Set oldNeighbours = this.edges.removeAll(element);
        this.edges.putAll(element, neighbours);
        for (IElement oldNeighbour : oldNeighbours) {
            if (neighbours.contains(oldNeighbour)) continue;
            this.updateNeighbours(oldNeighbour, updated);
            if (this.edges.containsEntry((Object)oldNeighbour, element)) {
                LOGGER.error("A factory element isn't following the graph adjacency contract. Edge B -> A was kept when edge A -> B was removed. A = " + element + ", B = " + oldNeighbour);
            }
            oldNeighbour.onNeighbourRemoved(element);
            element.onNeighbourRemoved((IElement)oldNeighbour);
        }
        for (IElement currentNeighbour : neighbours) {
            if (oldNeighbours.contains(currentNeighbour)) continue;
            this.updateNeighbours(currentNeighbour, updated);
            if (!this.edges.containsEntry((Object)currentNeighbour, element)) {
                LOGGER.error("A factory element isn't following the graph adjacency contract. Edge B -> A was not added when edge A -> B was added. A = " + element + ", B = " + currentNeighbour);
            }
            currentNeighbour.onNeighbourAdded(element);
            element.onNeighbourAdded((IElement)currentNeighbour);
        }
    }
}

