/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.tesseract.api;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import java.util.function.Consumer;

public abstract class Transaction<T> {
    private final ObjectArrayList<Consumer<T>> onCommit;
    private final ObjectArrayList<T> transmitted = new ObjectArrayList(1);
    private final Consumer<T> consumer;
    private boolean committed;

    public Transaction(Consumer<T> consumed) {
        this.onCommit = new ObjectArrayList(1);
        this.consumer = consumed;
        this.committed = false;
    }

    protected T addData(T t) {
        if (this.committed) {
            return t;
        }
        this.transmitted.add(t);
        return t;
    }

    public T getLast() {
        if (this.transmitted.size() == 0) {
            throw new IllegalStateException("call to Transaction::getLast without data");
        }
        return (T)this.transmitted.get(this.transmitted.size() - 1);
    }

    public Iterable<T> getOffset(int j) {
        return () -> {
            ObjectListIterator t = this.transmitted.iterator();
            for (int i = 0; i < j; ++i) {
                t.next();
            }
            return t;
        };
    }

    public List<T> getData() {
        return this.transmitted;
    }

    public boolean commitSuccessfull() {
        return this.committed && this.transmitted.size() > 0;
    }

    public void onCommit(Consumer<T> consumer) {
        if (this.committed) {
            return;
        }
        this.onCommit.ensureCapacity(this.transmitted.size());
        this.onCommit.add(this.transmitted.size() - 1, consumer);
    }

    public void withCallbackBefore(int offset, Consumer<T> consumer) {
        for (int i = offset; i < this.onCommit.size(); ++i) {
            Consumer value = (Consumer)this.onCommit.get(i);
            this.onCommit.add(i, consumer.andThen(value));
        }
    }

    public void withCallbackAfter(int offset, Consumer<T> consumer) {
        for (int i = offset; i < this.onCommit.size(); ++i) {
            Consumer value = (Consumer)this.onCommit.get(i);
            this.onCommit.add(i, value.andThen(consumer));
        }
    }

    public void commit() {
        if (this.committed) {
            return;
        }
        for (int i = 0; i < this.transmitted.size(); ++i) {
            if (this.onCommit.get(i) != null) {
                ((Consumer)this.onCommit.get(i)).accept(this.transmitted.get(i));
            }
            this.consumer.accept(this.transmitted.get(i));
        }
        this.committed = true;
    }

    public abstract boolean isValid();

    public abstract boolean canContinue();
}

