package org.gtreimagined.tesseract.api.eu;

import com.google.common.collect.ImmutableSet;
import org.gtreimagined.tesseract.graph.IRoutingInfo;

import java.util.List;
import net.minecraft.class_2350;

public record EURoutingInfo(long maxAmps, long maxVoltage, double actualLoss, long roundedLoss, class_2350 side, List<IEUCable> path) implements IRoutingInfo<EURoutingInfo> {
    public EURoutingInfo(long maxAmps, long maxVoltage, double actualLoss, class_2350 side, List<IEUCable> path) {
        this(maxAmps, maxVoltage, actualLoss, Math.round(actualLoss), side, path);
    }

    @Override
    public EURoutingInfo merge(EURoutingInfo other) {
        long maxAmps = Math.min(this.maxAmps, other.maxAmps);
        long maxVoltage = Math.min(this.maxVoltage, other.maxVoltage);
        double actualLoss = this.actualLoss + other.actualLoss;
        long roundedLoss = Math.round(actualLoss);
        return new EURoutingInfo(maxAmps, maxVoltage, actualLoss, roundedLoss, other.side, ImmutableSet.<IEUCable>builder().addAll(path).addAll(other.path).build().stream().toList());
    }
}
