/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.tesseract.api.eu;

import org.gtreimagined.tesseract.api.eu.IEnergyHandler;

public class EUState {
    long ampsReceived = 0L;
    long ampsSent;
    long euReceived = 0L;
    long euSent;
    public final IEnergyHandler handler;

    public EUState(IEnergyHandler handler) {
        this.handler = handler;
    }

    public void onTick() {
        this.ampsReceived = 0L;
        this.euReceived = 0L;
        this.ampsSent = 0L;
        this.euSent = 0L;
    }

    public long extract(boolean simulate, long amps) {
        if (this.handler.canOutput()) {
            if (simulate) {
                return Math.min(amps, this.handler.getOutputAmperage() - this.ampsSent);
            }
            if (this.ampsSent + amps > this.handler.getOutputAmperage()) {
                return 0L;
            }
            if (!simulate) {
                this.ampsSent += amps;
            }
            return amps;
        }
        return 0L;
    }

    public long receive(boolean simulate, long amps) {
        if (this.handler.canInput()) {
            if (simulate) {
                return Math.min(amps, this.handler.getInputAmperage() - this.ampsReceived);
            }
            if (this.ampsReceived + amps > this.handler.getInputAmperage()) {
                return 0L;
            }
            if (!simulate) {
                this.ampsReceived += amps;
            }
            return amps;
        }
        return 0L;
    }

    public long getAmpsReceived() {
        return this.ampsReceived;
    }

    public long getAmpsSent() {
        return this.ampsSent;
    }
}

