/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.tesseract.api.eu;

import java.util.function.Consumer;
import org.gtreimagined.tesseract.api.Transaction;

public class EUTransaction
extends Transaction<TransferData> {
    public final long voltage;
    public long eu;

    public EUTransaction(long voltage, Consumer<TransferData> consumer) {
        super(consumer);
        this.voltage = voltage;
        this.eu = voltage;
    }

    @Override
    public boolean isValid() {
        return this.eu > 0L;
    }

    @Override
    public boolean canContinue() {
        return this.eu > 0L;
    }

    public TransferData addData(long eu, long consumedEu, double loss, Consumer<TransferData> data) {
        eu = Math.min(eu, this.eu);
        TransferData dat = this.addData(new TransferData(this, eu, this.voltage).setLoss(loss));
        this.eu -= Math.min(this.eu, consumedEu);
        this.onCommit(data);
        return dat;
    }

    public static class TransferData {
        private final long voltage;
        private long eu;
        private double loss;
        public final EUTransaction transaction;

        public TransferData(EUTransaction transaction, long eu, long voltage) {
            this.voltage = voltage;
            this.loss = 0.0;
            this.eu = eu;
            this.transaction = transaction;
        }

        public long getEnergy(long amps, boolean input) {
            return input ? (this.voltage - Math.round(this.loss)) * amps : this.voltage * amps;
        }

        public double getLoss() {
            return this.loss;
        }

        public TransferData setLoss(double loss) {
            this.loss = Math.min((double)this.voltage, loss);
            return this;
        }

        public long getEu() {
            return this.eu;
        }

        public long drainEu(long eu) {
            this.eu -= eu;
            return eu;
        }

        public String toString() {
            return "Transmit eu: " + this.eu + "  voltage: " + this.voltage + " loss: " + this.loss;
        }

        public long getVoltage() {
            return this.voltage;
        }

        public EUTransaction getTransaction() {
            return this.transaction;
        }
    }
}

