/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.tesseract.api.capability;

import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import org.gtreimagined.tesseract.TesseractCapUtils;
import org.gtreimagined.tesseract.api.IConnectable;
import org.gtreimagined.tesseract.api.capability.ITransactionModifier;
import org.gtreimagined.tesseract.api.capability.TesseractBaseCapability;
import org.gtreimagined.tesseract.api.eu.EUNetwork;
import org.gtreimagined.tesseract.api.eu.EUState;
import org.gtreimagined.tesseract.api.eu.EUTransaction;
import org.gtreimagined.tesseract.api.eu.IEUCable;
import org.gtreimagined.tesseract.api.eu.IEUNode;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;
import org.gtreimagined.tesseract.graph.IElement;
import org.gtreimagined.tesseract.util.Pos;

public class TesseractEUCapability<T extends class_2586>
extends TesseractBaseCapability<T>
implements IEnergyHandler {
    private final IEUCable cable;
    private EUTransaction old;

    public TesseractEUCapability(T tile, class_2350 dir, boolean isNode, ITransactionModifier modifier) {
        super(tile, dir, isNode, modifier);
        this.cable = (IEUCable)tile;
    }

    @Override
    public long insertEu(long voltage, boolean simulate) {
        if (this.isSending || !simulate && this.old == null) {
            return 0L;
        }
        if (((IElement)this.tile).getNetwork() == null) {
            return 0L;
        }
        this.isSending = true;
        class_2586 neighbor = this.tile.method_10997().method_8321(this.tile.method_11016().method_10093(this.side));
        if (neighbor instanceof IEUNode) {
            IEUNode node = (IEUNode)neighbor;
            if (!simulate) {
                this.old.commit();
            } else {
                long pos = this.tile.method_11016().method_10063();
                EUTransaction transaction = new EUTransaction(voltage, t -> {});
                if (!this.isNode) {
                    ((EUNetwork)((IElement)this.tile).getNetwork()).insert(transaction, node);
                } else {
                    this.transferAroundPipe(transaction, pos);
                }
                this.old = transaction;
            }
            this.isSending = false;
            return voltage - this.old.eu;
        }
        return 0L;
    }

    @Override
    public long extractEu(long voltage, boolean simulate) {
        return 0L;
    }

    private void transferAroundPipe(EUTransaction transaction, long pos) {
        boolean hasInserted = false;
        boolean lossAdded = false;
        for (class_2350 dir : class_2350.values()) {
            long remainingEu;
            EUTransaction.TransferData data;
            Optional<IEnergyHandler> cap;
            class_2586 otherTile;
            if (dir == this.side || !((IConnectable)this.tile).connects(dir) || (otherTile = this.tile.method_10997().method_8321(class_2338.method_10092((long)Pos.offset(pos, dir)))) == null || (cap = TesseractCapUtils.INSTANCE.getEnergyHandler(otherTile, dir.method_10153())).isEmpty()) continue;
            IEnergyHandler handler = cap.get();
            long loss = Math.round(this.cable.getLoss());
            if (hasInserted && !lossAdded) {
                transaction.addData(0L, loss, 0.0, d -> {});
                lossAdded = true;
            }
            if (this.callback.modify(data = new EUTransaction.TransferData(transaction, remainingEu = lossAdded ? transaction.eu : transaction.eu - loss, transaction.voltage).setLoss(this.cable.getLoss()), dir, false, true) || this.callback.modify(data, this.side, true, true)) continue;
            if (data.getEu() < remainingEu) {
                remainingEu = data.getEu();
            }
            if (data.getLoss() > 0.0) {
                remainingEu -= Math.round(data.getLoss());
            }
            if (remainingEu <= 0L) {
                return;
            }
            long inserted = handler.insertEu(remainingEu, true);
            if (inserted > 0L) {
                transaction.addData(inserted, inserted, this.cable.getLoss(), t -> {
                    if (this.callback.modify(t, dir, false, false) || this.callback.modify(data, this.side, true, false)) {
                        return;
                    }
                    handler.insertEu(t.getEu(), false);
                });
                if (transaction.voltage > this.cable.getVoltage()) {
                    this.cable.onCableOverVoltage(this.tile.method_10997(), pos, transaction.voltage);
                }
            }
            if (transaction.eu == 0L) break;
        }
    }

    @Override
    public long getEnergy() {
        return 0L;
    }

    @Override
    public long getCapacity() {
        return 0L;
    }

    @Override
    public long availableAmpsInput(long voltage) {
        return Long.MAX_VALUE;
    }

    @Override
    public long availableAmpsOutput() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getOutputAmperage() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getOutputVoltage() {
        return this.cable.getVoltage();
    }

    @Override
    public long getInputAmperage() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getInputVoltage() {
        return this.cable.getVoltage();
    }

    @Override
    public boolean canOutput() {
        return true;
    }

    @Override
    public boolean canInput() {
        return true;
    }

    @Override
    public boolean canInput(class_2350 direction) {
        return true;
    }

    @Override
    public boolean canOutput(class_2350 direction) {
        return true;
    }

    @Override
    public EUState getState() {
        return new EUState(this);
    }

    @Override
    public class_2487 serialize(class_2487 tag) {
        return null;
    }

    @Override
    public void deserialize(class_2487 nbt) {
    }
}

