/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.tesseract.api;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.gtreimagined.tesseract.api.IConnectable;
import org.gtreimagined.tesseract.graph.IElement;
import org.gtreimagined.tesseract.graph.IGrid;
import org.gtreimagined.tesseract.graph.INetwork;
import org.gtreimagined.tesseract.graph.INotableElement;
import org.gtreimagined.tesseract.graph.IRoutingInfo;
import org.gtreimagined.tesseract.graph.RoutedNode;

public interface INode<TSelf extends INode<TSelf, TRoutingInfo, TElement, TNetwork, TGrid>, TRoutingInfo extends IRoutingInfo<TRoutingInfo>, TElement extends IElement<TElement, TSelf, TRoutingInfo, TNetwork, TGrid> & IConnectable, TNetwork extends INetwork<TNetwork, TElement, TSelf, TRoutingInfo, TGrid>, TGrid extends IGrid<TGrid, TElement, TSelf, TRoutingInfo, TNetwork>>
extends IElement<TElement, TSelf, TRoutingInfo, TNetwork, TGrid>,
INotableElement<TSelf, TRoutingInfo, TElement, TNetwork, TGrid>,
IConnectable {
    @Override
    default public List<RoutedNode<TSelf, TRoutingInfo>> getRoutedNeighbours() {
        ArrayList<RoutedNode<TSelf, TRoutingInfo>> list = new ArrayList<RoutedNode<TSelf, TRoutingInfo>>();
        if (!this.isActuallyNode()) {
            return list;
        }
        for (class_2350 direction : class_2350.values()) {
            class_2586 source;
            if (!this.isOutput(direction) || (source = this.getBlockEntity()) == null) continue;
            this.addNeighbor(direction, this, list, List.of());
        }
        return list;
    }

    public boolean isOutput(class_2350 var1);

    default public void addNeighbor(class_2350 side, TElement from, List<RoutedNode<TSelf, TRoutingInfo>> list, List<TElement> pathSoFar) {
        class_2586 fromBE = ((IConnectable)from).getBlockEntity();
        if (fromBE == null) {
            return;
        }
        class_2586 neighbor = fromBE.method_10997().method_8321(fromBE.method_11016().method_10093(side));
        if (neighbor != null) {
            INode self;
            if (this.getSelfClass().isInstance(neighbor) && (self = (INode)this.getSelfClass().cast(neighbor)).isActuallyNode()) {
                if (pathSoFar.isEmpty()) {
                    return;
                }
                if (self.isOutput(side.method_10153())) {
                    return;
                }
                if (!((IConnectable)from).connects(side) || !self.connects(side.method_10153())) {
                    return;
                }
                TRoutingInfo routingInfo = this.createRoutingInfo(pathSoFar, side.method_10153());
                list.add(new RoutedNode<INode, TRoutingInfo>(self, routingInfo));
            } else if (this.getElementClass().isInstance(neighbor)) {
                IElement to = (IElement)this.getElementClass().cast(neighbor);
                boolean fromConnects = ((IConnectable)from).connects(side);
                boolean toConnects = ((IConnectable)((Object)to)).connects(side.method_10153());
                if (fromConnects && toConnects && !pathSoFar.contains(to)) {
                    for (class_2350 direction : class_2350.values()) {
                        if (direction == side.method_10153()) continue;
                        this.addNeighbor(direction, (TElement)to, list, (List<TElement>)ImmutableList.builder().addAll(pathSoFar).add((Object)to).build());
                    }
                }
            }
        }
    }

    public Class<TSelf> getSelfClass();

    public Class<TElement> getElementClass();

    public TRoutingInfo createRoutingInfo(List<TElement> var1, class_2350 var2);
}

