package org.gtreimagined.tesseract.fabric;

import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.EnergyMoveable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.gtreimagined.tesseract.api.fabric.wrapper.EnergyMoveableWrapper;
import org.gtreimagined.tesseract.api.fabric.wrapper.EnergyTileWrapper;
import org.gtreimagined.tesseract.api.fabric.wrapper.IEnergyHandlerMoveable;
import org.gtreimagined.tesseract.api.fabric.wrapper.IEnergyHandlerStorage;
import org.jetbrains.annotations.NotNull;
import team.reborn.energy.api.EnergyStorage;
import org.gtreimagined.tesseract.TesseractCapUtils;
import org.gtreimagined.tesseract.TesseractConfig;
import org.gtreimagined.tesseract.api.fabric.TesseractLookups;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;
import org.gtreimagined.tesseract.api.eu.IEnergyHandlerItem;
import org.gtreimagined.tesseract.api.hu.IHeatHandler;

import java.util.Optional;

public class TesseractCapUtilsImpl implements TesseractCapUtils {
    @Override
    public Optional<IEnergyHandlerItem> getEnergyHandlerItem(class_1799 stack){
        IEnergyHandlerItem energyHandler = ContainerItemContext.withInitial(stack).find(TesseractLookups.ENERGY_HANDLER_ITEM);
        return Optional.ofNullable(energyHandler);
    }

    @Override
    public Optional<IEnergyHandlerItem> getWrappedEnergyHandlerItem(class_1799 stack){
        IEnergyHandlerItem energyHandler = ContainerItemContext.withInitial(stack).find(TesseractLookups.ENERGY_HANDLER_ITEM);
        if (energyHandler == null){
            EnergyStorage storage = ContainerItemContext.withInitial(stack).find(EnergyStorage.ITEM);
            if (storage instanceof IEnergyHandlerItem e){
                energyHandler = e;
            }
        }
        return Optional.ofNullable(energyHandler);
    }

    @Override
    public Optional<IEnergyHandler> getEnergyHandler(@NotNull class_2586 entity, class_2350 side){
        IEnergyHandler energyHandler = TesseractLookups.ENERGY_HANDLER_SIDED.find(entity.method_10997(), entity.method_11016(), entity.method_11010(), entity, side);
        if (energyHandler == null) {
            if (FabricLoader.getInstance().isModLoaded("modern_industrialization") && TesseractConfig.ENABLE_MI_COMPAT.get()){
                energyHandler = getEnergyMoveable(entity, side);
                if (energyHandler != null) return Optional.of(energyHandler);
            }
            energyHandler = getEnergyStorage(entity, side);
        }
        return Optional.ofNullable(energyHandler);
    }

    @Override
    public Optional<IHeatHandler> getHeatHandler(class_2586 entity, class_2350 side){
        IHeatHandler heatHandler = TesseractLookups.HEAT_HANDLER_SIDED.find(entity.method_10997(), entity.method_11016(), entity.method_11010(), entity, side);
        return Optional.ofNullable(heatHandler);
    }

    private IEnergyHandler getEnergyStorage(class_2586 be, class_2350 direction){
        EnergyStorage storage = EnergyStorage.SIDED.find(be.method_10997(), be.method_11016(), be.method_11010(), be, direction);
        if (storage == null) return null;
        if (storage instanceof IEnergyHandler moveable1) return moveable1;
        if (storage instanceof IEnergyHandlerStorage handlerStorage) return handlerStorage.getEnergyHandler();
        return new EnergyTileWrapper(be, storage);
    }

    private IEnergyHandler getEnergyMoveable(class_2586 be, class_2350 direction){
        EnergyMoveable moveable = EnergyApi.MOVEABLE.find(be.method_10997(), be.method_11016(), be.method_11010(), be, direction);
        if (moveable == null) return null;
        if (moveable instanceof IEnergyHandler moveable1) return moveable1;
        if (moveable instanceof IEnergyHandlerMoveable moveable1) return moveable1.getEnergyHandler();
        return new EnergyMoveableWrapper(be, moveable);
    }
}
